/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.ApiVersion;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.Variant;
import com.android.ide.common.repository.GradleVersion;
import com.android.manifmerger.ManifestMerger2;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.XmlDocument;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.LoggerProgressIndicatorWrapper;
import com.android.tools.lint.KotlinLintAnalyzerFacade;
import com.android.tools.lint.LintBatchAnalytics;
import com.android.tools.lint.LintCliFlags;
import com.android.tools.lint.LintCliXmlParser;
import com.android.tools.lint.LintCoreApplicationEnvironment;
import com.android.tools.lint.LintCoreProjectEnvironment;
import com.android.tools.lint.LintExternalAnnotationsManager;
import com.android.tools.lint.LintFixPerformer;
import com.android.tools.lint.LintStats;
import com.android.tools.lint.Reporter;
import com.android.tools.lint.TextReporter;
import com.android.tools.lint.Warning;
import com.android.tools.lint.XmlReporter;
import com.android.tools.lint.checks.HardcodedValuesDetector;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.DefaultConfiguration;
import com.android.tools.lint.client.api.GradleVisitor;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintBaseline;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.LintListener;
import com.android.tools.lint.client.api.LintRequest;
import com.android.tools.lint.client.api.UastParser;
import com.android.tools.lint.client.api.XmlParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.tools.lint.helpers.DefaultJavaEvaluator;
import com.android.tools.lint.helpers.DefaultUastParser;
import com.android.tools.lint.kotlin.LintKotlinUtils;
import com.android.utils.CharSequences;
import com.android.utils.ILogger;
import com.android.utils.NullLogger;
import com.android.utils.StdLogger;
import com.google.common.annotations.Beta;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.mock.MockProject;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.impl.file.impl.JavaFileManager;
import com.intellij.util.lang.UrlClassLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCliJavaFileManagerImpl;
import org.jetbrains.kotlin.cli.jvm.index.JavaRoot;
import org.jetbrains.kotlin.cli.jvm.index.JvmDependenciesIndex;
import org.jetbrains.kotlin.cli.jvm.index.JvmDependenciesIndexImpl;
import org.jetbrains.kotlin.cli.jvm.index.SingleJavaFileRootsIndex;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UExpression;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@Beta
public class LintCliClient
extends LintClient {
    protected final List<Warning> warnings = new ArrayList<Warning>();
    protected boolean hasErrors;
    protected int errorCount;
    protected int warningCount;
    protected IssueRegistry registry;
    protected LintDriver driver;
    protected final LintCliFlags flags;
    private Configuration configuration;
    private boolean validatedIds;
    protected DefaultConfiguration overrideConfiguration;
    private static final String LINT_OVERRIDE_CONFIGURATION_ENV_VAR = "LINT_OVERRIDE_CONFIGURATION";
    private static final String LINT_CONFIGURATION_OVERRIDE_PROP = "lint.configuration.override";
    private final Map<File, CharSequence> mFileContents = new HashMap<File, CharSequence>(100);
    private Map<Project, LintClient.ClassPathInfo> mProjectInfo;
    private static Set<File> sAlreadyWarned;
    LintCoreProjectEnvironment projectEnvironment;
    private com.intellij.openapi.project.Project ideaProject;
    private Disposable projectDisposer;

    public LintCliClient(String clientName) {
        super(clientName);
        this.flags = new LintCliFlags();
        TextReporter reporter = new TextReporter(this, this.flags, new PrintWriter(System.out, true), false);
        this.flags.getReporters().add(reporter);
        this.initialize();
    }

    @Deprecated
    public LintCliClient() {
        this("test");
    }

    public LintCliClient(LintCliFlags flags, String clientName) {
        super(clientName);
        this.flags = flags;
        this.initialize();
    }

    private void initialize() {
        String configuration = System.getenv(LINT_OVERRIDE_CONFIGURATION_ENV_VAR);
        if (configuration == null) {
            configuration = System.getProperty(LINT_CONFIGURATION_OVERRIDE_PROP);
        }
        if (configuration != null) {
            File file = new File(configuration);
            if (file.exists()) {
                this.overrideConfiguration = this.createConfigurationFromFile(file);
                System.out.println("Overriding configuration from " + file);
            } else {
                this.log(Severity.ERROR, null, "Configuration override requested but does not exist: " + file, new Object[0]);
            }
        }
    }

    protected String getBaselineVariantName() {
        if (this.flags.isFatalOnly()) {
            return "fatal";
        }
        List projects = this.driver.getProjects();
        for (Project project : projects) {
            Variant variant = project.getCurrentVariant();
            if (variant == null) continue;
            return variant.getName();
        }
        return "all";
    }

    public int run(IssueRegistry registry, List<File> files) throws IOException {
        boolean fixed;
        long startTime = System.currentTimeMillis();
        assert (!this.flags.getReporters().isEmpty());
        this.registry = registry;
        LintRequest lintRequest = this.createLintRequest(files);
        this.driver = this.createDriver(registry, lintRequest);
        this.driver.setAnalysisStartTime(startTime);
        this.addProgressPrinter();
        this.validateIssueIds();
        this.driver.analyze();
        Collections.sort(this.warnings);
        LintBaseline baseline = this.driver.getBaseline();
        LintStats stats = LintStats.Companion.create(this.warnings, baseline);
        for (Reporter reporter : this.flags.getReporters()) {
            reporter.write(stats, this.warnings);
        }
        Collection projects = lintRequest.getProjects();
        if (projects == null) {
            projects = this.getKnownProjects();
        }
        if (!projects.isEmpty()) {
            LintBatchAnalytics analytics = new LintBatchAnalytics();
            analytics.logSession(registry, this.flags, this.driver, projects, this.warnings);
        }
        if (this.flags.isAutoFix() && (fixed = new LintFixPerformer(this, !this.flags.isQuiet()).fix(this.warnings)) && LintClient.Companion.isGradle()) {
            String message = "One or more issues were fixed in the source code.\nAborting the build since the edits to the source files were performed **after** compilation, so the outputs do not contain the fixes. Re-run the build.";
            System.err.println(message);
            return 7;
        }
        File baselineFile = this.flags.getBaselineFile();
        if (baselineFile != null && baseline != null) {
            this.emitBaselineDiagnostics(baseline, baselineFile, stats);
        }
        if (baselineFile != null && !baselineFile.exists() && this.flags.isWriteBaselineIfMissing()) {
            File dir = baselineFile.getParentFile();
            boolean ok = true;
            if (dir != null && !dir.isDirectory()) {
                ok = dir.mkdirs();
            }
            if (!ok) {
                System.err.println("Couldn't create baseline folder " + dir);
            } else {
                XmlReporter reporter = Reporter.createXmlReporter(this, baselineFile, true);
                reporter.setBaselineAttributes(this, this.getBaselineVariantName());
                reporter.write(stats, (List<? extends Warning>)this.warnings);
                System.err.println(this.getBaselineCreationMessage(baselineFile));
                return 6;
            }
        }
        return this.flags.isSetExitCode() ? (this.hasErrors ? 1 : 0) : 0;
    }

    public String getBaselineCreationMessage(File baselineFile) {
        String message = "Created baseline file " + baselineFile + "\n\nAlso breaking the build in case this was not intentional. If you\ndeliberately created the baseline file, re-run the build and this\ntime it should succeed without warnings.\n\nIf not, investigate the baseline path in the lintOptions config\nor verify that the baseline file has been checked into version\ncontrol.\n";
        if (LintClient.Companion.isGradle()) {
            message = message + "\nYou can set the system property lint.baselines.continue=true\nif you want to create many missing baselines in one go.";
        }
        return message;
    }

    public void emitBaselineDiagnostics(LintBaseline baseline, File baselineFile, LintStats stats) {
        boolean hasConsoleOutput = false;
        for (Reporter reporter : this.flags.getReporters()) {
            if (!(reporter instanceof TextReporter) || !((TextReporter)reporter).isWriteToConsole()) continue;
            hasConsoleOutput = true;
            break;
        }
        if (!this.flags.isQuiet() && !hasConsoleOutput) {
            if (stats.getBaselineErrorCount() > 0 || stats.getBaselineWarningCount() > 0) {
                if (this.errorCount == 0 && this.warningCount == 1) {
                    System.out.print("Lint found no new issues");
                } else {
                    System.out.print(String.format("Lint found %1$s", Lint.describeCounts((int)this.errorCount, (int)Math.max(0, this.warningCount - 1), (boolean)true, (boolean)false)));
                    if (stats.getAutoFixedCount() > 0) {
                        System.out.print(String.format(" (%1$s of these were automatically fixed)", stats.getAutoFixedCount()));
                    }
                }
                System.out.print(String.format(" (%1$s filtered by baseline %2$s)", Lint.describeCounts((int)stats.getBaselineErrorCount(), (int)stats.getBaselineWarningCount(), (boolean)true, (boolean)true), baselineFile.getName()));
            } else {
                System.out.print(String.format("Lint found %1$s", Lint.describeCounts((int)this.errorCount, (int)this.warningCount, (boolean)true, (boolean)false)));
            }
            System.out.println();
            if (stats.getBaselineFixedCount() > 0) {
                System.out.println(String.format("\n%1$d errors/warnings were listed in the baseline file (%2$s) but not found in the project; perhaps they have been fixed?", stats.getBaselineFixedCount(), baselineFile));
            }
            String checkVariant = this.getBaselineVariantName();
            String creationVariant = baseline.getAttribute("variant");
            if (creationVariant != null && !creationVariant.equals(checkVariant)) {
                System.out.println("\nNote: The baseline was created using a different target/variant than it was checked against.");
                System.out.println("Creation variant: " + this.getTargetName(creationVariant));
                System.out.println("Current variant: " + this.getTargetName(checkVariant));
            }
            if (stats.getBaselineFixedCount() > 0) {
                String checkVersion = this.getClientRevision();
                String checkClient = LintClient.Companion.getClientName();
                String creationVersion = baseline.getAttribute("version");
                String creationClient = baseline.getAttribute("client");
                if (checkClient.equals(creationClient) && creationVersion != null && checkVersion != null && !creationVersion.equals(checkVersion)) {
                    GradleVersion created = GradleVersion.tryParse((String)creationVersion);
                    GradleVersion current = GradleVersion.tryParse((String)checkVersion);
                    if (created != null && current != null && created.compareTo(current) > 0) {
                        System.out.println("\nNote: The baseline was created with a newer version of " + checkClient + " (" + creationVersion + ") than the current version (" + checkVersion + ")");
                        System.out.println("This means that some of the issues marked as fixed in the baseline may not actually be fixed, but may ");
                        System.out.println("be new issues uncovered by the more recent version of lint.");
                    }
                }
            }
        }
    }

    protected String getTargetName(String baselineVariantName) {
        if (LintClient.isGradle()) {
            if ("all".equals(baselineVariantName)) {
                return "lint";
            }
            if ("fatal".equals(baselineVariantName)) {
                return "lintVitalRelease";
            }
        }
        return baselineVariantName;
    }

    protected void validateIssueIds() {
        this.driver.addLintListener((driver, type, project, context) -> {
            if (type == LintListener.EventType.SCANNING_PROJECT && !this.validatedIds) {
                this.validateIssueIds(project);
            }
        });
    }

    protected LintDriver createDriver(IssueRegistry registry, LintRequest request) {
        this.driver = new LintDriver(registry, (LintClient)this, request);
        this.driver.setAbbreviating(!this.flags.isShowEverything());
        this.driver.setCheckTestSources(this.flags.isCheckTestSources());
        this.driver.setIgnoreTestSources(this.flags.isIgnoreTestSources());
        this.driver.setCheckGeneratedSources(this.flags.isCheckGeneratedSources());
        this.driver.setFatalOnlyMode(this.flags.isFatalOnly());
        this.driver.setCheckDependencies(this.flags.isCheckDependencies());
        File baselineFile = this.flags.getBaselineFile();
        if (baselineFile != null) {
            LintBaseline baseline = new LintBaseline((LintClient)this, baselineFile);
            this.driver.setBaseline(baseline);
            if (this.flags.isRemoveFixedBaselineIssues()) {
                baseline.setWriteOnClose(true);
                baseline.setRemoveFixed(true);
            }
        }
        return this.driver;
    }

    protected void addProgressPrinter() {
        if (!this.flags.isQuiet()) {
            this.driver.addLintListener((LintListener)new ProgressPrinter());
        }
    }

    protected LintRequest createLintRequest(List<File> files) {
        return new LintRequest((LintClient)this, files);
    }

    public void log(Severity severity, Throwable exception, String format, Object ... args) {
        System.out.flush();
        if (!this.flags.isQuiet()) {
            System.err.println();
        }
        if (format != null) {
            System.err.println(String.format(format, args));
        }
        if (exception != null) {
            exception.printStackTrace();
        }
    }

    public XmlParser getXmlParser() {
        return new LintCliXmlParser(this);
    }

    public Configuration getConfiguration(Project project, LintDriver driver) {
        if (this.overrideConfiguration != null) {
            return this.overrideConfiguration;
        }
        return new CliConfiguration(this.getConfiguration(), project, this.flags.isFatalOnly());
    }

    private CharSequence getContents(File file) {
        return this.mFileContents.computeIfAbsent(file, k -> this.readFile(file));
    }

    public UastParser getUastParser(Project project) {
        return new LintCliUastParser(project);
    }

    public GradleVisitor getGradleVisitor() {
        return new GradleVisitor();
    }

    public void report(Context context, Issue issue, Severity severity, Location location, String message, TextFormat format, LintFix fix) {
        File file;
        assert (context.isEnabled(issue) || issue.getCategory() == Category.LINT);
        if (severity.isError()) {
            this.hasErrors = true;
            ++this.errorCount;
        } else if (severity == Severity.WARNING) {
            ++this.warningCount;
        }
        message = format.convertTo(message, TextFormat.RAW);
        Warning warning = new Warning(issue, message, severity, context.getProject());
        this.warnings.add(warning);
        if (location == null) {
            this.log(Severity.ERROR, null, "No location provided for issue " + issue, new Object[0]);
            return;
        }
        warning.location = location;
        warning.file = file = location.getFile();
        warning.path = this.getDisplayPath(context.getProject(), file);
        warning.quickfixData = fix;
        Position startPosition = location.getStart();
        if (startPosition != null) {
            int line;
            warning.line = line = startPosition.getLine();
            warning.offset = startPosition.getOffset();
            Position endPosition = location.getEnd();
            if (endPosition != null) {
                warning.endOffset = endPosition.getOffset();
            }
            if (line >= 0) {
                if (context.file == location.getFile()) {
                    warning.fileContents = context.getContents();
                }
                if (warning.fileContents == null) {
                    warning.fileContents = this.getContents(location.getFile());
                }
                if (this.flags.isShowSourceLines()) {
                    warning.errorLine = LintCliClient.getLine(warning.fileContents, line);
                    if (warning.errorLine != null) {
                        warning.errorLine = warning.errorLine.replace('\t', ' ');
                        int column = startPosition.getColumn();
                        if (column < 0) {
                            column = 0;
                            int i = 0;
                            while (i < warning.errorLine.length() && Character.isWhitespace(warning.errorLine.charAt(i))) {
                                ++i;
                                ++column;
                            }
                        }
                        StringBuilder sb = new StringBuilder(100);
                        sb.append(warning.errorLine);
                        sb.append('\n');
                        for (int i = 0; i < column; ++i) {
                            sb.append(' ');
                        }
                        boolean displayCaret = true;
                        if (endPosition != null) {
                            int endLine = endPosition.getLine();
                            int endColumn = endPosition.getColumn();
                            if (endLine == line && endColumn > column) {
                                for (int i = column; i < endColumn; ++i) {
                                    sb.append('~');
                                }
                                displayCaret = false;
                            }
                        }
                        if (displayCaret) {
                            sb.append('^');
                        }
                        sb.append('\n');
                        warning.errorLine = sb.toString();
                    }
                }
            }
        }
    }

    static String getLine(CharSequence contents, int line) {
        int index = LintCliClient.getLineOffset(contents, line);
        if (index != -1) {
            return LintCliClient.getLineOfOffset(contents, index);
        }
        return null;
    }

    static String getLineOfOffset(CharSequence contents, int offset) {
        int end = CharSequences.indexOf((CharSequence)contents, (char)'\n', (int)offset);
        if (end == -1) {
            end = CharSequences.indexOf((CharSequence)contents, (char)'\r', (int)offset);
        } else if (end > 0 && contents.charAt(end - 1) == '\r') {
            --end;
        }
        return contents.subSequence(offset, end != -1 ? end : contents.length()).toString();
    }

    static int getLineOffset(CharSequence contents, int line) {
        int index = 0;
        for (int i = 0; i < line; ++i) {
            if ((index = CharSequences.indexOf((CharSequence)contents, (char)'\n', (int)index)) == -1) {
                return -1;
            }
            ++index;
        }
        return index;
    }

    public CharSequence readFile(File file) {
        PsiFile psiFile;
        com.intellij.openapi.project.Project project;
        VirtualFile vFile;
        CharSequence contents;
        try {
            contents = Lint.getEncodedString((LintClient)this, (File)file, (boolean)false);
        }
        catch (IOException e) {
            contents = "";
        }
        String path = file.getPath();
        if ((path.endsWith(".java") || path.endsWith(".kt") || path.endsWith(".kts")) && CharSequences.indexOf((CharSequence)contents, (char)'\r') != -1 && (vFile = StandardFileSystems.local().findFileByPath(path)) != null && (project = this.getIdeaProject()) != null && (psiFile = PsiManager.getInstance((com.intellij.openapi.project.Project)project).findFile(vFile)) != null) {
            contents = psiFile.getText();
        }
        return contents;
    }

    boolean isCheckingSpecificIssues() {
        return this.flags.getExactCheckedIds() != null;
    }

    protected LintClient.ClassPathInfo getClassPath(Project project) {
        LintClient.ClassPathInfo info;
        LintClient.ClassPathInfo classPath = super.getClassPath(project);
        List sources = this.flags.getSourcesOverride();
        List classes = this.flags.getClassesOverride();
        List libraries = this.flags.getLibrariesOverride();
        if (classes == null && sources == null && libraries == null) {
            return classPath;
        }
        if (this.mProjectInfo == null) {
            this.mProjectInfo = Maps.newHashMap();
            info = null;
        } else {
            info = this.mProjectInfo.get(project);
        }
        if (info == null) {
            if (sources == null) {
                sources = classPath.getSourceFolders();
            }
            if (classes == null) {
                classes = classPath.getClassFolders();
            }
            if (libraries == null) {
                libraries = classPath.getLibraries(true);
            }
            info = new LintClient.ClassPathInfo(sources, classes, libraries, classPath.getLibraries(false), classPath.getTestSourceFolders(), classPath.getTestLibraries(), classPath.getGeneratedFolders());
            this.mProjectInfo.put(project, info);
        }
        return info;
    }

    public List<File> getResourceFolders(Project project) {
        List<File> resources = this.flags.getResourcesOverride();
        if (resources == null) {
            return super.getResourceFolders(project);
        }
        return resources;
    }

    protected Project createProject(File dir, File referenceDir) {
        Project project = super.createProject(dir, referenceDir);
        String compileSdkVersion = this.flags.getCompileSdkVersionOverride();
        if (compileSdkVersion != null) {
            project.setBuildTargetHash(compileSdkVersion);
        }
        return project;
    }

    private void validateIssueIds(Project project) {
        if (this.driver != null) {
            IssueRegistry registry = this.driver.getRegistry();
            if (!registry.isIssueId(HardcodedValuesDetector.ISSUE.getId())) {
                return;
            }
            this.validatedIds = true;
            this.validateIssueIds(project, registry, this.flags.getExactCheckedIds());
            this.validateIssueIds(project, registry, this.flags.getEnabledIds());
            this.validateIssueIds(project, registry, this.flags.getSuppressedIds());
            this.validateIssueIds(project, registry, this.flags.getSeverityOverrides().keySet());
            if (project != null) {
                Configuration configuration = project.getConfiguration(this.driver);
                configuration.validateIssueIds((LintClient)this, this.driver, project, registry);
            }
        }
    }

    private void validateIssueIds(Project project, IssueRegistry registry, Collection<String> ids) {
        if (ids != null) {
            for (String id : ids) {
                if (registry.getIssue(id) != null) continue;
                this.reportNonExistingIssueId(project, id);
            }
        }
    }

    protected void reportNonExistingIssueId(Project project, String id) {
        String message = String.format("Unknown issue id \"%1$s\"", id);
        if (this.driver != null && project != null && !this.isSuppressed(IssueRegistry.LINT_ERROR)) {
            Location location = Lint.guessGradleLocation((LintClient)this, (File)project.getDir(), (String)id);
            LintClient.Companion.report((LintClient)this, IssueRegistry.LINT_ERROR, message, this.driver, project, location, LintFix.create().data(new Object[]{id}));
        } else {
            this.log(Severity.ERROR, null, "Lint: %1$s", message);
        }
    }

    static String getCleanPath(File file) {
        String path = file.getPath();
        StringBuilder sb = new StringBuilder(path.length());
        if (path.startsWith(File.separator)) {
            sb.append(File.separator);
        }
        block0: for (String element : Splitter.on((char)File.separatorChar).omitEmptyStrings().split((CharSequence)path)) {
            if (element.equals(".")) continue;
            if (element.equals("..") && sb.length() > 0) {
                for (int i = sb.length() - 1; i >= 0; --i) {
                    char c = sb.charAt(i);
                    if (c != File.separatorChar) continue;
                    sb.setLength(i == 0 ? 1 : i);
                    continue block0;
                }
                sb.setLength(0);
                continue;
            }
            if (sb.length() > 1) {
                sb.append(File.separatorChar);
            } else if (sb.length() > 0 && sb.charAt(0) != File.separatorChar) {
                sb.append(File.separatorChar);
            }
            sb.append(element);
        }
        if (path.endsWith(File.separator) && sb.length() > 0 && sb.charAt(sb.length() - 1) != File.separatorChar) {
            sb.append(File.separator);
        }
        return sb.toString();
    }

    String getDisplayPath(Project project, File file) {
        return LintCliClient.getDisplayPath(project, file, this.flags.isFullPath());
    }

    static String getDisplayPath(Project project, File file, boolean fullPath) {
        String path = file.getPath();
        if (!fullPath && path.startsWith(project.getReferenceDir().getPath())) {
            int chop = project.getReferenceDir().getPath().length();
            if (path.length() > chop && path.charAt(chop) == File.separatorChar) {
                ++chop;
            }
            if ((path = path.substring(chop)).isEmpty()) {
                path = file.getName();
            }
        } else if (fullPath) {
            path = LintCliClient.getCleanPath(file.getAbsoluteFile());
        } else if (file.isAbsolute() && file.exists()) {
            path = Reporter.getRelativePath(project.getReferenceDir(), file);
        }
        return path;
    }

    boolean isAllEnabled() {
        return this.flags.isCheckAllWarnings();
    }

    IssueRegistry getRegistry() {
        return this.registry;
    }

    LintDriver getDriver() {
        return this.driver;
    }

    protected Configuration getConfiguration() {
        if (this.configuration == null) {
            if (this.overrideConfiguration != null) {
                this.configuration = this.overrideConfiguration;
                return this.configuration;
            }
            File configFile = this.flags.getDefaultConfiguration();
            if (configFile != null) {
                if (!configFile.exists()) {
                    if (sAlreadyWarned == null || !sAlreadyWarned.contains(configFile)) {
                        this.log(Severity.ERROR, null, "Warning: Configuration file %1$s does not exist", configFile);
                    }
                    if (sAlreadyWarned == null) {
                        sAlreadyWarned = Sets.newHashSet();
                    }
                    sAlreadyWarned.add(configFile);
                }
                this.configuration = this.createConfigurationFromFile(configFile);
            }
        }
        return this.configuration;
    }

    boolean isSuppressed(Issue issue) {
        Category category;
        Set<Category> disabledCategories = this.flags.getDisabledCategories();
        if (disabledCategories != null && (disabledCategories.contains(category = issue.getCategory()) || category.getParent() != null && disabledCategories.contains(category.getParent()))) {
            return true;
        }
        return this.flags.getSuppressedIds().contains(issue.getId());
    }

    public DefaultConfiguration createConfigurationFromFile(File file) {
        return new CliConfiguration(file, this.flags.isFatalOnly());
    }

    public com.intellij.openapi.project.Project getIdeaProject() {
        return this.ideaProject;
    }

    public LintCoreProjectEnvironment getProjectEnvironment() {
        return this.projectEnvironment;
    }

    /*
     * WARNING - void declaration
     */
    public void initializeProjects(Collection<? extends Project> knownProjects) {
        LanguageLevelProjectExtension languageLevelProjectExtension;
        void var9_12;
        LintCoreProjectEnvironment projectEnvironment;
        Disposable parentDisposable;
        LintCoreApplicationEnvironment appEnv = LintCoreApplicationEnvironment.get();
        this.projectDisposer = parentDisposable = Disposer.newDisposable();
        this.projectEnvironment = projectEnvironment = LintCoreProjectEnvironment.create(parentDisposable, appEnv);
        MockProject mockProject = projectEnvironment.getProject();
        this.ideaProject = mockProject;
        boolean includeTests = !this.flags.isIgnoreTestSources();
        Set allProjects = Sets.newIdentityHashSet();
        for (Project project : knownProjects) {
            allProjects.add(project);
            allProjects.addAll(project.getAllLibraries());
        }
        ArrayList<File> files = new ArrayList<File>(50);
        for (Object project : allProjects) {
            files.addAll(project.getJavaSourceFolders());
            if (includeTests) {
                files.addAll(project.getTestSourceFolders());
            }
            files.addAll(project.getGeneratedSourceFolders());
            files.addAll(project.getJavaLibraries(true));
            if (!includeTests) continue;
            files.addAll(project.getTestLibraries());
        }
        this.addBootClassPath(knownProjects, files);
        projectEnvironment.registerPaths(files);
        LanguageLevel languageLevel = LanguageLevel.JDK_1_7;
        for (Project project : knownProjects) {
            Object javaCompileOptions;
            String sourceCompatibility;
            LanguageLevel level;
            AndroidProject model = project.getGradleProjectModel();
            if (model == null || (level = LanguageLevel.parse((String)(sourceCompatibility = (javaCompileOptions = model.getJavaCompileOptions()).getSourceCompatibility()))) == null || !var9_12.isLessThan(level)) continue;
            LanguageLevel languageLevel2 = level;
        }
        com.intellij.openapi.project.Project ideaProject = this.getIdeaProject();
        if (ideaProject != null && (languageLevelProjectExtension = (LanguageLevelProjectExtension)ideaProject.getComponent(LanguageLevelProjectExtension.class)) != null) {
            languageLevelProjectExtension.setLanguageLevel((LanguageLevel)var9_12);
        }
        KotlinCliJavaFileManagerImpl kotlinCliJavaFileManagerImpl = (KotlinCliJavaFileManagerImpl)ServiceManager.getService((com.intellij.openapi.project.Project)mockProject, JavaFileManager.class);
        ArrayList<JavaRoot> roots = new ArrayList<JavaRoot>();
        for (File file : files) {
            VirtualFile vFile;
            if (!file.isDirectory() || (vFile = StandardFileSystems.local().findFileByPath(file.getPath())) == null) continue;
            roots.add(new JavaRoot(vFile, JavaRoot.RootType.SOURCE, null));
        }
        JvmDependenciesIndexImpl index = new JvmDependenciesIndexImpl(roots);
        kotlinCliJavaFileManagerImpl.initialize((JvmDependenciesIndex)index, Collections.emptyList(), new SingleJavaFileRootsIndex(Collections.emptyList()), false);
        super.initializeProjects(knownProjects);
    }

    protected boolean addBootClassPath(Collection<? extends Project> knownProjects, List<File> files) {
        File file;
        IAndroidTarget buildTarget = null;
        boolean isAndroid = false;
        for (Project project : knownProjects) {
            IAndroidTarget t;
            if (project.isAndroidProject()) {
                isAndroid = true;
            }
            if ((t = project.getBuildTarget()) == null) continue;
            if (buildTarget == null) {
                buildTarget = t;
                continue;
            }
            if (buildTarget.getVersion().compareTo(t.getVersion()) <= 0) continue;
            buildTarget = t;
        }
        if (buildTarget != null && (file = buildTarget.getFile(1)) != null) {
            files.add(file);
            return true;
        }
        if (!isAndroid) {
            String string;
            String javaHome = System.getProperty("java.home");
            if (javaHome == null) {
                javaHome = System.getenv("JAVA_HOME");
            }
            if (javaHome != null) {
                File file2 = new File(javaHome, "lib" + File.separator + "rt.jar");
                if (file2.exists()) {
                    files.add(file2);
                    return true;
                }
                File file3 = new File(javaHome, "jre" + File.separator + "lib" + File.separator + "rt.jar");
                if (file3.exists()) {
                    files.add(file3);
                    return true;
                }
            }
            if ((string = System.getProperty("sun.boot.class.path")) != null) {
                Splitter.on((char)File.pathSeparatorChar).split((CharSequence)string).forEach(path -> {
                    File file = new File((String)path);
                    if (file.exists()) {
                        files.add(file);
                    }
                });
                return true;
            }
        }
        return false;
    }

    public void disposeProjects(Collection<? extends Project> knownProjects) {
        if (this.projectDisposer != null) {
            Disposer.dispose((Disposable)this.projectDisposer);
            LintCoreApplicationEnvironment.clearAccessorCache();
        }
        this.ideaProject = null;
        this.projectDisposer = null;
        super.disposeProjects(knownProjects);
    }

    public boolean isOverridingConfiguration() {
        return this.overrideConfiguration != null;
    }

    public void syncConfigOptions() {
        Configuration configuration = this.getConfiguration();
        if (configuration instanceof DefaultConfiguration) {
            Boolean applySuggestions;
            File baselineFile;
            Boolean abortOnError;
            Boolean removeFixedBaselineIssues;
            Boolean explainIssues;
            Boolean checkDependencies;
            Boolean checkGeneratedSources;
            Boolean ignoreTestSources;
            Boolean checkTestSources;
            Boolean fatalOnly;
            Boolean warningsAsErrors;
            Boolean ignoreWarnings;
            DefaultConfiguration config = (DefaultConfiguration)configuration;
            Boolean checkAllWarnings = config.getCheckAllWarnings();
            if (checkAllWarnings != null) {
                this.flags.setCheckAllWarnings(checkAllWarnings);
            }
            if ((ignoreWarnings = config.getIgnoreWarnings()) != null) {
                this.flags.setIgnoreWarnings(ignoreWarnings);
            }
            if ((warningsAsErrors = config.getWarningsAsErrors()) != null) {
                this.flags.setWarningsAsErrors(warningsAsErrors);
            }
            if ((fatalOnly = config.getFatalOnly()) != null) {
                this.flags.setFatalOnly(fatalOnly);
            }
            if ((checkTestSources = config.getCheckTestSources()) != null) {
                this.flags.setCheckTestSources(checkTestSources);
            }
            if ((ignoreTestSources = config.getIgnoreTestSources()) != null) {
                this.flags.setIgnoreTestSources(ignoreTestSources);
            }
            if ((checkGeneratedSources = config.getCheckGeneratedSources()) != null) {
                this.flags.setCheckGeneratedSources(checkGeneratedSources);
            }
            if ((checkDependencies = config.getCheckDependencies()) != null) {
                this.flags.setCheckDependencies(checkDependencies);
            }
            if ((explainIssues = config.getExplainIssues()) != null) {
                this.flags.setExplainIssues(explainIssues);
            }
            if ((removeFixedBaselineIssues = config.getRemoveFixedBaselineIssues()) != null) {
                this.flags.setRemovedFixedBaselineIssues(removeFixedBaselineIssues);
            }
            if ((abortOnError = config.getAbortOnError()) != null) {
                this.flags.setSetExitCode(abortOnError);
            }
            if ((baselineFile = config.getBaselineFile()) != null) {
                this.flags.setBaselineFile(baselineFile.getPath().equals("none") ? null : baselineFile);
            }
            if ((applySuggestions = config.getApplySuggestions()) != null && applySuggestions.booleanValue()) {
                this.flags.setAutoFix(true);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getClientRevision() {
        NullLogger empty;
        LoggerProgressIndicatorWrapper progress;
        LocalPackage pkg;
        AndroidSdkHandler sdk = this.getSdk();
        if (sdk != null && (pkg = sdk.getLocalPackage("tools", (ProgressIndicator)(progress = new LoggerProgressIndicatorWrapper((ILogger)(empty = new NullLogger()))))) != null) {
            return pkg.getVersion().toShortString();
        }
        File file = this.findResource("tools" + File.separator + "source.properties");
        if (file == null) return "unknown";
        if (!file.exists()) return "unknown";
        try (FileInputStream input = new FileInputStream(file);){
            Properties properties = new Properties();
            properties.load(input);
            String revision = properties.getProperty("Pkg.Revision");
            if (revision == null) return "unknown";
            if (revision.isEmpty()) return "unknown";
            String string = revision;
            return string;
        }
        catch (Throwable throwable7) {
            // empty catch block
        }
        return "unknown";
    }

    public LintCliFlags getFlags() {
        return this.flags;
    }

    public boolean haveErrors() {
        return this.errorCount > 0;
    }

    public void reset() {
        this.warnings.clear();
        this.errorCount = 0;
        this.warningCount = 0;
        this.getProjectDirs().clear();
        this.getDirToProject().clear();
    }

    public ClassLoader createUrlClassLoader(URL[] urls, ClassLoader parent) {
        return UrlClassLoader.build().parent(parent).urls(urls).get();
    }

    public Document getMergedManifest(Project project) {
        ArrayList manifests = Lists.newArrayList();
        for (Project dependency : project.getAllLibraries()) {
            manifests.addAll(dependency.getManifestFiles());
        }
        final File injectedFile = new File("injected-from-gradle");
        final StringBuilder injectedXml = new StringBuilder();
        if (project.getGradleProjectModel() != null && project.getCurrentVariant() != null) {
            ProductFlavor mergedFlavor = project.getCurrentVariant().getMergedFlavor();
            ApiVersion targetSdkVersion = mergedFlavor.getTargetSdkVersion();
            ApiVersion minSdkVersion = mergedFlavor.getMinSdkVersion();
            if (targetSdkVersion != null || minSdkVersion != null) {
                injectedXml.append("<manifest xmlns:android=\"http://schemas.android.com/apk/res/android\"\n    package=\"${packageName}\">\n    <uses-sdk");
                if (minSdkVersion != null) {
                    injectedXml.append(" android:minSdkVersion=\"").append(minSdkVersion.getApiString()).append("\"");
                }
                if (targetSdkVersion != null) {
                    injectedXml.append(" android:targetSdkVersion=\"").append(targetSdkVersion.getApiString()).append("\"");
                }
                injectedXml.append(" />\n</manifest>\n");
                manifests.add(injectedFile);
            }
        }
        File mainManifest = null;
        if (project.getGradleProjectModel() != null && project.getCurrentVariant() != null) {
            for (SourceProvider provider : Lint.getSourceProviders((AndroidProject)project.getGradleProjectModel(), (Variant)project.getCurrentVariant())) {
                File manifestFile = provider.getManifestFile();
                if (!manifestFile.exists()) continue;
                if (mainManifest == null) {
                    mainManifest = manifestFile;
                    continue;
                }
                manifests.add(manifestFile);
            }
            if (mainManifest == null) {
                return null;
            }
        } else {
            List projectManifests = project.getManifestFiles();
            if (projectManifests.isEmpty()) {
                return null;
            }
            mainManifest = (File)projectManifests.get(0);
            for (int i = 1; i < projectManifests.size(); ++i) {
                manifests.add(projectManifests.get(i));
            }
        }
        if (manifests.isEmpty()) {
            try {
                Document document = this.getXmlParser().parseXml(mainManifest);
                if (document != null) {
                    this.resolveMergeManifestSources(document, mainManifest);
                }
                return document;
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                this.log(Severity.WARNING, e, "Could not parse %1$s", mainManifest);
                return null;
            }
        }
        try {
            StdLogger logger = new StdLogger(StdLogger.Level.INFO);
            ManifestMerger2.MergeType type = project.isLibrary() ? ManifestMerger2.MergeType.LIBRARY : ManifestMerger2.MergeType.APPLICATION;
            MergingReport mergeReport = ManifestMerger2.newMerger((File)mainManifest, (ILogger)logger, (ManifestMerger2.MergeType)type).withFeatures(new ManifestMerger2.Invoker.Feature[]{ManifestMerger2.Invoker.Feature.SKIP_BLAME, ManifestMerger2.Invoker.Feature.SKIP_XML_STRING, ManifestMerger2.Invoker.Feature.NO_PLACEHOLDER_REPLACEMENT}).addLibraryManifests(manifests.toArray(new File[manifests.size()])).withFileStreamProvider(new ManifestMerger2.FileStreamProvider(){

                protected InputStream getInputStream(File file) throws FileNotFoundException {
                    if (injectedFile.equals(file)) {
                        return CharSequences.getInputStream((CharSequence)injectedXml.toString());
                    }
                    CharSequence text = LintCliClient.this.readFile(file);
                    return CharSequences.getInputStream((CharSequence)text);
                }
            }).merge();
            XmlDocument xmlDocument = mergeReport.getMergedXmlDocument(MergingReport.MergedManifestKind.MERGED);
            if (xmlDocument != null) {
                Document document = xmlDocument.getXml();
                if (document != null) {
                    this.resolveMergeManifestSources(document, mergeReport.getActions());
                    return document;
                }
            } else {
                this.log(Severity.WARNING, null, mergeReport.getReportString(), new Object[0]);
            }
        }
        catch (ManifestMerger2.MergeFailureException e) {
            this.log(Severity.ERROR, e, "Couldn't parse merged manifest", new Object[0]);
        }
        return super.getMergedManifest(project);
    }

    protected class LintCliUastParser
    extends DefaultUastParser {
        private final Project project;

        public LintCliUastParser(Project project) {
            super(project, LintCliClient.this.ideaProject);
            this.project = project;
        }

        protected DefaultJavaEvaluator createEvaluator(Project project, com.intellij.openapi.project.Project p) {
            assert (project != null);
            return new DefaultJavaEvaluator(p, project){

                public Map<UExpression, PsiParameter> computeArgumentMapping(UCallExpression call, PsiMethod method) {
                    if (method.getParameterList().getParametersCount() == 0) {
                        return Collections.emptyMap();
                    }
                    Map kotlinMap = LintKotlinUtils.computeKotlinArgumentMapping((UCallExpression)call, (PsiMethod)method);
                    if (kotlinMap != null) {
                        return kotlinMap;
                    }
                    return super.computeArgumentMapping(call, method);
                }
            };
        }

        public boolean prepare(List<? extends JavaContext> contexts, List<? extends JavaContext> testContexts) {
            MockProject mockProject;
            String path;
            ArrayList<File> kotlinFiles = new ArrayList<File>();
            for (JavaContext javaContext : contexts) {
                path = javaContext.file.getPath();
                if (!path.endsWith(".kt") && !path.endsWith(".kts")) continue;
                kotlinFiles.add(javaContext.file);
            }
            for (JavaContext javaContext : testContexts) {
                path = javaContext.file.getPath();
                if (!path.endsWith(".kt") && !path.endsWith(".kts")) continue;
                kotlinFiles.add(javaContext.file);
            }
            Project first = this.findProject(contexts, testContexts);
            if (first != null) {
                for (Project dependency : first.getAllLibraries()) {
                    this.addKotlinFiles(kotlinFiles, dependency.getJavaSourceFolders());
                    this.addKotlinFiles(kotlinFiles, dependency.getTestSourceFolders());
                }
            }
            if ((mockProject = (MockProject)LintCliClient.this.ideaProject) != null && LintCliClient.this.projectEnvironment != null) {
                List<File> paths = LintCliClient.this.projectEnvironment.getPaths();
                new KotlinLintAnalyzerFacade().analyze(kotlinFiles, paths, mockProject);
            }
            boolean ok = super.prepare(contexts, testContexts);
            if (mockProject == null || contexts.isEmpty() && testContexts.isEmpty()) {
                return ok;
            }
            if (LintCliClient.this.ideaProject != null) {
                LintExternalAnnotationsManager annotationsManager = (LintExternalAnnotationsManager)ExternalAnnotationsManager.getInstance((com.intellij.openapi.project.Project)LintCliClient.this.ideaProject);
                annotationsManager.updateAnnotationRoots(LintCliClient.this);
            }
            return ok;
        }

        private void addKotlinFiles(List<File> kotlinFiles, List<File> sourceFolders) {
            for (File dir : sourceFolders) {
                this.addKotlinFiles(kotlinFiles, dir);
            }
        }

        private void addKotlinFiles(List<File> kotlinFiles, File file) {
            File[] files;
            String path = file.getPath();
            if (path.endsWith(".kt")) {
                kotlinFiles.add(file);
            } else if (!path.endsWith(".java") && file.isDirectory() && (files = file.listFiles()) != null) {
                for (File sub : files) {
                    this.addKotlinFiles(kotlinFiles, sub);
                }
            }
        }

        private Project findProject(List<? extends JavaContext> contexts, List<? extends JavaContext> testContexts) {
            if (!contexts.isEmpty()) {
                return contexts.get(0).getProject();
            }
            if (!testContexts.isEmpty()) {
                return testContexts.get(0).getProject();
            }
            return null;
        }
    }

    private static class ProgressPrinter
    implements LintListener {
        private ProgressPrinter() {
        }

        public void update(LintDriver lint, LintListener.EventType type, Project project, Context context) {
            switch (type) {
                case SCANNING_PROJECT: {
                    String name;
                    String string = name = context != null ? context.getProject().getName() : "?";
                    if (lint.getPhase() > 1) {
                        System.out.print(String.format("\nScanning %1$s (Phase %2$d): ", name, lint.getPhase()));
                        break;
                    }
                    System.out.print(String.format("\nScanning %1$s: ", name));
                    break;
                }
                case SCANNING_LIBRARY_PROJECT: {
                    String name = context != null ? context.getProject().getName() : "?";
                    System.out.print(String.format("\n         - %1$s: ", name));
                    break;
                }
                case SCANNING_FILE: {
                    System.out.print('.');
                    break;
                }
                case NEW_PHASE: {
                    break;
                }
                case CANCELED: 
                case COMPLETED: {
                    System.out.println();
                    break;
                }
            }
        }
    }

    protected class CliConfiguration
    extends DefaultConfiguration {
        private final boolean mFatalOnly;

        protected CliConfiguration(Configuration parent, Project project, boolean fatalOnly) {
            super((LintClient)LintCliClient.this, project, parent);
            this.mFatalOnly = fatalOnly;
        }

        protected CliConfiguration(File lintFile, boolean fatalOnly) {
            super((LintClient)LintCliClient.this, null, null, lintFile);
            this.mFatalOnly = fatalOnly;
        }

        protected CliConfiguration(File lintFile, Configuration parent, Project project, boolean fatalOnly) {
            super((LintClient)LintCliClient.this, project, parent, lintFile);
            this.mFatalOnly = fatalOnly;
        }

        public Severity getSeverity(Issue issue) {
            Severity severity = this.computeSeverity(issue);
            if (this.mFatalOnly && severity != Severity.FATAL) {
                return Severity.IGNORE;
            }
            if (LintCliClient.this.flags.isWarningsAsErrors() && severity == Severity.WARNING) {
                if (issue == IssueRegistry.BASELINE) {
                    return severity;
                }
                severity = Severity.ERROR;
            }
            if (LintCliClient.this.flags.isIgnoreWarnings() && severity == Severity.WARNING) {
                severity = Severity.IGNORE;
            }
            return severity;
        }

        protected Severity getDefaultSeverity(Issue issue) {
            if (LintCliClient.this.flags.isCheckAllWarnings()) {
                return issue.getDefaultSeverity();
            }
            return super.getDefaultSeverity(issue);
        }

        private Severity computeSeverity(Issue issue) {
            Category category;
            Severity severity = super.getSeverity(issue);
            String id = issue.getId();
            Set<String> suppress = LintCliClient.this.flags.getSuppressedIds();
            if (suppress.contains(id)) {
                return Severity.IGNORE;
            }
            Set<Category> disabledCategories = LintCliClient.this.flags.getDisabledCategories();
            if (disabledCategories != null && (disabledCategories.contains(category = issue.getCategory()) || category.getParent() != null && disabledCategories.contains(category.getParent()))) {
                return Severity.IGNORE;
            }
            Severity manual = LintCliClient.this.flags.getSeverityOverrides().get(id);
            if (manual != null) {
                if (this.severity != null && (this.severity.containsKey(id) || this.severity.containsKey("all"))) {
                    return Severity.min((Severity)severity, (Severity)manual);
                }
                return manual;
            }
            Set<String> enabled = LintCliClient.this.flags.getEnabledIds();
            Set<String> exact = LintCliClient.this.flags.getExactCheckedIds();
            Set<Category> enabledCategories = LintCliClient.this.flags.getEnabledCategories();
            Set<Category> exactCategories = LintCliClient.this.flags.getExactCategories();
            Category category2 = issue.getCategory();
            if (exact != null) {
                if (exact.contains(id)) {
                    return this.getVisibleSeverity(issue, severity);
                }
                if (category2 != Category.LINT) {
                    return Severity.IGNORE;
                }
            }
            if (exactCategories != null) {
                if (exactCategories.contains(category2) || category2.getParent() != null && exactCategories.contains(category2.getParent())) {
                    return this.getVisibleSeverity(issue, severity);
                }
                if (category2 != Category.LINT || LintCliClient.this.flags.getDisabledCategories() != null && LintCliClient.this.flags.getDisabledCategories().contains(Category.LINT)) {
                    return Severity.IGNORE;
                }
            }
            if (enabled.contains(id) || enabledCategories != null && (enabledCategories.contains(category2) || category2.getParent() != null && enabledCategories.contains(category2.getParent()))) {
                return this.getVisibleSeverity(issue, severity);
            }
            return severity;
        }

        private Severity getVisibleSeverity(Issue issue, Severity severity) {
            if (severity == Severity.IGNORE && (severity = issue.getDefaultSeverity()) == Severity.IGNORE) {
                severity = Severity.WARNING;
            }
            return severity;
        }
    }
}

