/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.tools.lint.LintExternalAnnotationsManager;
import com.android.tools.lint.LintInferredAnnotationsManager;
import com.intellij.codeInsight.ContainerProvider;
import com.intellij.codeInsight.CustomExceptionHandler;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.InferredAnnotationsManager;
import com.intellij.codeInsight.runner.JavaMainMethodProvider;
import com.intellij.core.CoreApplicationEnvironment;
import com.intellij.core.JavaCoreApplicationEnvironment;
import com.intellij.core.JavaCoreProjectEnvironment;
import com.intellij.lang.MetaLanguage;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.java.JavaParserDefinition;
import com.intellij.mock.MockProject;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeExtensionPoint;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.impl.ZipHandler;
import com.intellij.psi.FileContextProvider;
import com.intellij.psi.JavaModuleSystem;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.augment.TypeAnnotationModifier;
import com.intellij.psi.compiled.ClassFileDecompilers;
import com.intellij.psi.impl.JavaClassSupersImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessor;
import com.intellij.psi.impl.compiled.ClsCustomNavigationPolicy;
import com.intellij.psi.meta.MetaDataContributor;
import com.intellij.psi.util.JavaClassSupers;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.resolve.diagnostics.DiagnosticSuppressor;
import org.jetbrains.uast.UastContext;
import org.jetbrains.uast.UastLanguagePlugin;
import org.jetbrains.uast.evaluation.UEvaluatorExtension;
import org.jetbrains.uast.java.JavaUastLanguagePlugin;
import org.jetbrains.uast.kotlin.KotlinUastLanguagePlugin;

public class LintCoreApplicationEnvironment
extends JavaCoreApplicationEnvironment {
    private static final Object APPLICATION_LOCK = new Object();
    private static LintCoreApplicationEnvironment ourApplicationEnvironment;
    private static int ourProjectCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LintCoreApplicationEnvironment get() {
        Object object = APPLICATION_LOCK;
        synchronized (object) {
            if (ourApplicationEnvironment != null) {
                return ourApplicationEnvironment;
            }
            Disposable parentDisposable = Disposer.newDisposable();
            boolean unitTestMode = false;
            ourApplicationEnvironment = LintCoreApplicationEnvironment.createApplicationEnvironment(parentDisposable, unitTestMode);
            ourProjectCount = 0;
            Disposer.register((Disposable)parentDisposable, () -> {
                Object object = APPLICATION_LOCK;
                synchronized (object) {
                    ourApplicationEnvironment = null;
                }
            });
            return ourApplicationEnvironment;
        }
    }

    public LintCoreApplicationEnvironment(Disposable parentDisposable, boolean unitTestMode) {
        super(parentDisposable, unitTestMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LintCoreApplicationEnvironment createApplicationEnvironment(Disposable parentDisposable, boolean unitTestMode) {
        System.setProperty("idea.use.native.fs.for.win", "false");
        Extensions.cleanRootArea((Disposable)parentDisposable);
        LintCoreApplicationEnvironment.registerAppExtensionPoints();
        LintCoreApplicationEnvironment applicationEnvironment = new LintCoreApplicationEnvironment(parentDisposable, unitTestMode);
        LintCoreApplicationEnvironment.registerApplicationServicesForCLI(applicationEnvironment);
        LintCoreApplicationEnvironment.registerApplicationServices(applicationEnvironment);
        KotlinCoreEnvironment.registerApplicationServices((JavaCoreApplicationEnvironment)applicationEnvironment);
        Object object = APPLICATION_LOCK;
        synchronized (object) {
            ++ourProjectCount;
        }
        return applicationEnvironment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearAccessorCache() {
        Object object = APPLICATION_LOCK;
        synchronized (object) {
            ZipHandler.clearFileAccessorCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disposeApplicationEnvironment() {
        Object object = APPLICATION_LOCK;
        synchronized (object) {
            LintCoreApplicationEnvironment environment = ourApplicationEnvironment;
            if (environment == null) {
                return;
            }
            ourApplicationEnvironment = null;
            Disposer.dispose((Disposable)environment.getParentDisposable());
            ZipHandler.clearFileAccessorCache();
        }
    }

    private static void registerAppExtensionPoints() {
        ExtensionsArea rootArea = Extensions.getRootArea();
        CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)rootArea, (String)"com.intellij.filetype.stubBuilder", FileTypeExtensionPoint.class);
        CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)rootArea, (ExtensionPointName)FileContextProvider.EP_NAME, FileContextProvider.class);
        CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)rootArea, (ExtensionPointName)MetaDataContributor.EP_NAME, MetaDataContributor.class);
        CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)rootArea, (ExtensionPointName)PsiAugmentProvider.EP_NAME, PsiAugmentProvider.class);
        CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)rootArea, (ExtensionPointName)JavaMainMethodProvider.EP_NAME, JavaMainMethodProvider.class);
        CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)rootArea, (ExtensionPointName)ContainerProvider.EP_NAME, ContainerProvider.class);
        CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)rootArea, (ExtensionPointName)ClsCustomNavigationPolicy.EP_NAME, ClsCustomNavigationPolicy.class);
        CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)rootArea, (ExtensionPointName)ClassFileDecompilers.EP_NAME, ClassFileDecompilers.Decompiler.class);
        CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)rootArea, (ExtensionPointName)TypeAnnotationModifier.EP_NAME, TypeAnnotationModifier.class);
        CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)rootArea, (ExtensionPointName)MetaLanguage.EP_NAME, MetaLanguage.class);
        CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)rootArea, (ExtensionPointName)UastLanguagePlugin.Companion.getExtensionPointName(), UastLanguagePlugin.class);
        CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)rootArea, (ExtensionPointName)CustomExceptionHandler.KEY, CustomExceptionHandler.class);
        CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)rootArea, (ExtensionPointName)JavaModuleSystem.EP_NAME, JavaModuleSystem.class);
        CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)rootArea, (ExtensionPointName)DiagnosticSuppressor.Companion.getEP_NAME(), DiagnosticSuppressor.class);
        rootArea.getExtensionPoint(UastLanguagePlugin.Companion.getExtensionPointName()).registerExtension((Object)new JavaUastLanguagePlugin());
        KotlinUastLanguagePlugin plugin = new KotlinUastLanguagePlugin();
        rootArea.getExtensionPoint(UastLanguagePlugin.Companion.getExtensionPointName()).registerExtension((Object)plugin);
    }

    private static void registerApplicationServicesForCLI(JavaCoreApplicationEnvironment applicationEnvironment) {
        applicationEnvironment.registerFileType((FileType)PlainTextFileType.INSTANCE, "xml");
        applicationEnvironment.registerParserDefinition((ParserDefinition)new JavaParserDefinition());
    }

    private static void registerApplicationServices(JavaCoreApplicationEnvironment applicationEnvironment) {
        applicationEnvironment.getApplication().registerService(JavaClassSupers.class, JavaClassSupersImpl.class);
        applicationEnvironment.getApplication().registerService(TransactionGuard.class, TransactionGuardImpl.class);
    }

    static void registerProjectExtensionPoints(ExtensionsArea area) {
        CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)area, (ExtensionPointName)PsiTreeChangePreprocessor.EP_NAME, PsiTreeChangePreprocessor.class);
        CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)area, (ExtensionPointName)PsiElementFinder.EP_NAME, PsiElementFinder.class);
        CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)area, (ExtensionPointName)UastLanguagePlugin.Companion.getExtensionPointName(), UastLanguagePlugin.class);
        CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)area, (ExtensionPointName)UEvaluatorExtension.Companion.getEXTENSION_POINT_NAME(), UEvaluatorExtension.class);
    }

    public static void registerProjectServices(JavaCoreProjectEnvironment projectEnvironment) {
        MockProject project = projectEnvironment.getProject();
        project.registerService(UastContext.class, (Object)new UastContext((Project)project));
        project.registerService(ExternalAnnotationsManager.class, LintExternalAnnotationsManager.class);
        project.registerService(InferredAnnotationsManager.class, LintInferredAnnotationsManager.class);
    }
}

