/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.ide.common.blame.SourcePosition;
import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.Warning;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Severity;
import com.android.utils.PositionXmlParser;
import com.android.utils.XmlUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0016\u0018\u0000 82\u00020\u0001:\u000389:B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\"\u0010\u0010\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\rH\u0002J\"\u0010\u0014\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0013\u001a\u0004\u0018\u00010\rH\u0002J\u0016\u0010\u0017\u001a\u00020\u00052\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0019H\u0002J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0019H\u0002J \u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020 H\u0002J\u0016\u0010$\u001a\u00020\u00052\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u0019H\u0002J&\u0010'\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020(2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00192\b\b\u0002\u0010)\u001a\u00020 J\u0014\u0010'\u001a\u00020\u00052\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0019J$\u0010*\u001a\u00020\u000b2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\u000b0,2\u0006\u0010-\u001a\u00020\u001cH\u0002J\u0010\u0010.\u001a\u00020\r2\u0006\u0010-\u001a\u00020\u001cH\u0002J4\u0010\u0004\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u001e0,2\u0006\u00103\u001a\u00020\u001e2\u0006\u00104\u001a\u00020\u001eH\u0014J,\u00105\u001a\u00020/2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\u000b0,2\u0006\u0010-\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u00106\u001a\u00020/2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u00107\u001a\u00020 H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/android/tools/lint/LintFixPerformer;", "", "client", "Lcom/android/tools/lint/LintCliClient;", "printStatistics", "", "(Lcom/android/tools/lint/LintCliClient;Z)V", "getClient", "()Lcom/android/tools/lint/LintCliClient;", "addEdits", "file", "Lcom/android/tools/lint/LintFixPerformer$PendingEditFile;", "location", "Lcom/android/tools/lint/detector/api/Location;", "lintFix", "Lcom/android/tools/lint/detector/api/LintFix;", "addReplaceString", "replaceFix", "Lcom/android/tools/lint/detector/api/LintFix$ReplaceString;", "fixLocation", "addSetAttribute", "setFix", "Lcom/android/tools/lint/detector/api/LintFix$SetAttribute;", "applyEdits", "files", "", "findApplicableFixes", "warnings", "Lcom/android/tools/lint/Warning;", "findAttributeInsertionOffset", "", "xml", "", "element", "Lorg/w3c/dom/Element;", "attributeName", "findConflicts", "fixes", "Lcom/android/tools/lint/LintFixPerformer$PendingEdit;", "fix", "Ljava/io/File;", "text", "getFileData", "fileMap", "", "warning", "getLocation", "", "writer", "Ljava/io/PrintWriter;", "editMap", "appliedEditCount", "editedFileCount", "registerFix", "writeFile", "contents", "Companion", "PendingEdit", "PendingEditFile", "lint"})
public class LintFixPerformer {
    @NotNull
    private final LintCliClient client;
    private final boolean printStatistics;
    public static final Companion Companion = new Companion(null);

    private final PendingEditFile getFileData(Map<File, PendingEditFile> fileMap, Warning warning) {
        Location location = this.getLocation(warning);
        File file = location.getFile();
        PendingEditFile pendingEditFile = fileMap.get(file);
        if (pendingEditFile == null) {
            LintFixPerformer lintFixPerformer;
            LintFixPerformer $receiver = lintFixPerformer = this;
            PendingEditFile fileData = new PendingEditFile($receiver.client, file, ((Object)warning.fileContents).toString());
            Map<File, PendingEditFile> map = fileMap;
            File file2 = file;
            PendingEditFile pendingEditFile2 = fileData;
            map.put(file2, pendingEditFile2);
            pendingEditFile = fileData;
        }
        return pendingEditFile;
    }

    private final Location getLocation(Warning warning) {
        Location range;
        LintFix fix = warning.quickfixData;
        if (fix instanceof LintFix.ReplaceString) {
            Location range2 = ((LintFix.ReplaceString)fix).range;
            if (range2 != null) {
                return range2;
            }
        } else if (fix instanceof LintFix.SetAttribute && (range = ((LintFix.SetAttribute)fix).range) != null) {
            return range;
        }
        Location location = warning.location;
        Intrinsics.checkExpressionValueIsNotNull((Object)location, (String)"warning.location");
        return location;
    }

    private final void registerFix(Map<File, PendingEditFile> fileMap, Warning warning, LintFix lintFix) {
        PendingEditFile fileData = this.getFileData(fileMap, warning);
        if (this.addEdits(fileData, warning.location, lintFix)) {
            warning.wasAutoFixed = true;
        }
    }

    public final boolean fix(@NotNull List<? extends Warning> warnings) {
        Intrinsics.checkParameterIsNotNull(warnings, (String)"warnings");
        List<PendingEditFile> files = this.findApplicableFixes(warnings);
        return this.applyEdits(files);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean fix(@NotNull File file, @NotNull List<? extends LintFix> fixes, @NotNull String text) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull(fixes, (String)"fixes");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        PendingEditFile pendingEditFile = new PendingEditFile(this.client, file, text);
        Iterable $receiver$iv = fixes;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            LintFix it = (LintFix)element$iv$iv;
            if (!Companion.canAutoFix(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            LintFix it = (LintFix)element$iv;
            this.addEdits(pendingEditFile, null, it);
        }
        return this.applyEdits(CollectionsKt.listOf((Object)pendingEditFile));
    }

    public static /* bridge */ /* synthetic */ boolean fix$default(LintFixPerformer lintFixPerformer, File file, List list, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: fix");
        }
        if ((n & 4) != 0) {
            string = FilesKt.readText((File)file, (Charset)Charsets.UTF_8);
        }
        return lintFixPerformer.fix(file, list, string);
    }

    private final boolean applyEdits(List<PendingEditFile> files) {
        int appliedEditCount = 0;
        int editedFileCount = 0;
        Map editMap = new LinkedHashMap();
        for (PendingEditFile fileData : files) {
            List edits;
            if (fileData.getEdits().isEmpty() || this.findConflicts(edits = SequencesKt.toList((Sequence)SequencesKt.distinct((Sequence)SequencesKt.sorted((Sequence)CollectionsKt.asSequence((Iterable)fileData.getEdits())))))) continue;
            String fileContents = fileData.getInitialText();
            for (PendingEdit edit : edits) {
                ++appliedEditCount;
                String key = edit.fixName();
                Integer n = (Integer)editMap.get(key);
                int count = n != null ? n : 0;
                Map map = editMap;
                Integer n2 = count + 1;
                map.put(key, n2);
                fileContents = edit.apply(fileContents);
            }
            this.writeFile(fileData, fileContents);
            ++editedFileCount;
        }
        if (this.printStatistics && editedFileCount > 0) {
            this.printStatistics(new PrintWriter(System.out), editMap, appliedEditCount, editedFileCount);
        }
        return editedFileCount > 0;
    }

    protected void printStatistics(@NotNull PrintWriter writer, @NotNull Map<String, Integer> editMap, int appliedEditCount, int editedFileCount) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        Intrinsics.checkParameterIsNotNull(editMap, (String)"editMap");
        if (editMap.keySet().size() == 1) {
            writer.println("Applied " + appliedEditCount + " edits across " + editedFileCount + " files for this fix: " + (String)CollectionsKt.first((Iterable)editMap.keySet()));
        } else {
            writer.println("Applied " + appliedEditCount + " edits across " + editedFileCount + " files");
            editMap.forEach(new BiConsumer<String, Integer>(writer){
                final /* synthetic */ PrintWriter $writer;

                public final void accept(@NotNull String name, @NotNull Integer count) {
                    Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                    Intrinsics.checkParameterIsNotNull((Object)count, (String)"count");
                    this.$writer.println("" + count + ": " + name);
                }
                {
                    this.$writer = printWriter;
                }
            });
        }
    }

    protected void writeFile(@NotNull PendingEditFile file, @NotNull String contents) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)contents, (String)"contents");
        FilesKt.writeText((File)file.getFile(), (String)contents, (Charset)Charsets.UTF_8);
    }

    private final List<PendingEditFile> findApplicableFixes(List<? extends Warning> warnings) {
        Map fileMap = new LinkedHashMap();
        for (Warning warning : warnings) {
            LintFix data;
            if (warning.quickfixData == null) {
                continue;
            }
            if (data instanceof LintFix.LintFixGroup) {
                LintFix sub;
                if (!Intrinsics.areEqual((Object)((LintFix.LintFixGroup)data).type, (Object)LintFix.GroupType.COMPOSITE)) continue;
                boolean all = true;
                Iterator iterator = ((LintFix.LintFixGroup)data).fixes.iterator();
                while (iterator.hasNext()) {
                    LintFix lintFix = sub = (LintFix)iterator.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)lintFix, (String)"sub");
                    if (Companion.canAutoFix(lintFix)) continue;
                    all = false;
                    break;
                }
                if (!all) continue;
                iterator = ((LintFix.LintFixGroup)data).fixes.iterator();
                while (iterator.hasNext()) {
                    LintFix lintFix = sub = (LintFix)iterator.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)lintFix, (String)"sub");
                    this.registerFix(fileMap, warning, lintFix);
                }
                continue;
            }
            if (!Companion.canAutoFix(data)) continue;
            this.registerFix(fileMap, warning, data);
        }
        return CollectionsKt.toList((Iterable)fileMap.values());
    }

    /*
     * WARNING - void declaration
     */
    private final boolean findConflicts(List<PendingEdit> fixes) {
        PendingEdit prev = fixes.get(fixes.size() - 1);
        int n = fixes.size() - 2;
        boolean bl = false;
        if (n >= 0) {
            while (true) {
                void index;
                PendingEdit fix;
                if ((fix = fixes.get((int)index)).getStartOffset() < prev.getEndOffset()) {
                    this.client.log(Severity.WARNING, null, "Overlapping edits in quickfixes; skipping. " + "Involved fixes: " + prev.getFix().getDisplayName() + " in [" + "" + prev.getStartOffset() + '-' + prev.getEndOffset() + "] and " + fix.getFix().getDisplayName() + " in [" + fix.getStartOffset() + '-' + fix.getEndOffset() + ']', new Object[0]);
                    return true;
                }
                prev = fix;
                if (index == false) break;
                --index;
            }
        }
        return false;
    }

    private final boolean addEdits(PendingEditFile file, Location location, LintFix lintFix) {
        boolean bl;
        if (lintFix instanceof LintFix.ReplaceString) {
            bl = this.addReplaceString(file, (LintFix.ReplaceString)lintFix, location);
        } else if (lintFix instanceof LintFix.SetAttribute) {
            bl = this.addSetAttribute(file, (LintFix.SetAttribute)lintFix, location);
        } else if (lintFix instanceof LintFix.LintFixGroup && Intrinsics.areEqual((Object)((LintFix.LintFixGroup)lintFix).type, (Object)LintFix.GroupType.COMPOSITE)) {
            boolean all = true;
            Iterator iterator = ((LintFix.LintFixGroup)lintFix).fixes.iterator();
            while (iterator.hasNext()) {
                LintFix nested;
                LintFix lintFix2 = nested = (LintFix)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)lintFix2, (String)"nested");
                if (this.addEdits(file, location, lintFix2)) continue;
                all = false;
            }
            bl = all;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean addSetAttribute(PendingEditFile file, LintFix.SetAttribute setFix, Location fixLocation) {
        String contents = file.getInitialText();
        Location location = setFix.range;
        if (location == null) {
            location = fixLocation;
        }
        if (location == null) {
            return false;
        }
        Location location2 = location;
        Position position = location2.getStart();
        if (position == null) {
            return false;
        }
        Position start = position;
        Document document = file.getXmlDocument();
        if (document == null) {
            return false;
        }
        Document document2 = document;
        Node node = PositionXmlParser.findNodeAtOffset((Document)document2, (int)start.getOffset());
        if (node == null) {
            String string = "No node found at offset " + start.getOffset();
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Node node2 = node;
        if (node2.getNodeType() == 2) {
            Node node3 = node2;
            if (node3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.w3c.dom.Attr");
            }
            Element element = ((Attr)node3).getOwnerElement();
            Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"(node as Attr).ownerElement");
            node2 = element;
        } else if (node2.getNodeType() != 1) {
            Node node4 = node2.getParentNode();
            Intrinsics.checkExpressionValueIsNotNull((Object)node4, (String)"node.parentNode");
            node2 = node4;
        }
        if (node2 == null || node2.getNodeType() != 1) {
            throw (Throwable)new IllegalArgumentException("Didn't find element at offset " + start.getOffset() + " (line " + start.getLine() + 1 + ", column " + start.getColumn() + 1 + ") in " + file.getFile().getPath() + ":\n" + contents);
        }
        Element element = (Element)node2;
        String value = setFix.value;
        String namespace = setFix.namespace;
        if (value == null) {
            Attr attr;
            Attr attr2 = attr = namespace != null ? element.getAttributeNodeNS(namespace, setFix.attribute) : element.getAttributeNode(setFix.attribute);
            if (attr != null) {
                SourcePosition position2;
                SourcePosition sourcePosition = position2 = PositionXmlParser.getPosition((Node)attr);
                Intrinsics.checkExpressionValueIsNotNull((Object)sourcePosition, (String)"position");
                int startOffset = sourcePosition.getStartOffset();
                int endOffset = position2.getEndOffset();
                int padding = 0;
                file.getEdits().add(new PendingEdit((LintFix)setFix, contents, startOffset, endOffset + padding, ""));
                return true;
            }
            return false;
        }
        String attributeName = setFix.attribute;
        String string = file.getInitialText();
        String string2 = attributeName;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"attributeName");
        int insertOffset = this.findAttributeInsertionOffset(string, element, string2);
        if (namespace != null) {
            String prefix = document2.lookupPrefix(namespace);
            if (prefix == null) {
                String base = "ns";
                if (Intrinsics.areEqual((Object)"http://schemas.android.com/apk/res/android", (Object)namespace)) {
                    base = "android";
                } else if (Intrinsics.areEqual((Object)"http://schemas.android.com/tools", (Object)namespace)) {
                    base = "tools";
                } else if (Intrinsics.areEqual((Object)"http://schemas.android.com/apk/res-auto", (Object)namespace)) {
                    base = "app";
                }
                Element root = document2.getDocumentElement();
                int index = 1;
                while (true) {
                    prefix = base + (index == 1 ? "" : Integer.toString(index));
                    if (!root.hasAttribute("xmlns:" + prefix)) break;
                    ++index;
                }
                String namespaceAttribute = "xmlns:" + prefix;
                String string3 = file.getInitialText();
                Element element2 = document2.getDocumentElement();
                Intrinsics.checkExpressionValueIsNotNull((Object)element2, (String)"document.documentElement");
                int rootInsertOffset = this.findAttributeInsertionOffset(string3, element2, namespaceAttribute);
                String padLeft = !CharsKt.isWhitespace((char)contents.charAt(rootInsertOffset - 1)) ? " " : "";
                String padRight = contents.charAt(rootInsertOffset) != '/' && contents.charAt(rootInsertOffset) != '>' ? " " : "";
                file.getEdits().add(new PendingEdit((LintFix)setFix, contents, rootInsertOffset, rootInsertOffset, "" + padLeft + "" + namespaceAttribute + "=\"" + namespace + '\"' + padRight));
            }
            attributeName = "" + prefix + ':' + attributeName;
        }
        String padLeft = !CharsKt.isWhitespace((char)contents.charAt(insertOffset - 1)) ? " " : "";
        String padRight = contents.charAt(insertOffset) != '/' && contents.charAt(insertOffset) != '>' ? " " : "";
        file.getEdits().add(new PendingEdit((LintFix)setFix, contents, insertOffset, insertOffset, "" + padLeft + "" + attributeName + "=\"" + XmlUtils.toXmlAttributeValue((String)value) + '\"' + padRight));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final int findAttributeInsertionOffset(String xml, Element element, String attributeName) {
        int tagEnd;
        SourcePosition position;
        NamedNodeMap attributes = element.getAttributes();
        int n = 0;
        NamedNodeMap namedNodeMap = attributes;
        Intrinsics.checkExpressionValueIsNotNull((Object)namedNodeMap, (String)"attributes");
        int n2 = namedNodeMap.getLength();
        while (n < n2) {
            void i;
            Node attribute;
            Node node = attribute = attributes.item((int)i);
            Intrinsics.checkExpressionValueIsNotNull((Object)node, (String)"attribute");
            String string = node.getLocalName();
            if (string == null) {
                String string2 = attribute.getNodeName();
                string = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"attribute.nodeName");
            }
            int delta = Companion.compareAttributeNames(attributeName, string);
            if (delta < 0) {
                SourcePosition sourcePosition = PositionXmlParser.getPosition((Node)attribute);
                Intrinsics.checkExpressionValueIsNotNull((Object)sourcePosition, (String)"PositionXmlParser.getPosition(attribute)");
                return sourcePosition.getStartOffset();
            }
            ++i;
        }
        if (attributes.getLength() > 0) {
            SourcePosition sourcePosition = PositionXmlParser.getPosition((Node)attributes.item(attributes.getLength() - 1));
            Intrinsics.checkExpressionValueIsNotNull((Object)sourcePosition, (String)"PositionXmlParser.getPos\u2026m(attributes.length - 1))");
            return sourcePosition.getEndOffset();
        }
        SourcePosition sourcePosition = position = PositionXmlParser.getPosition((Node)element);
        Intrinsics.checkExpressionValueIsNotNull((Object)sourcePosition, (String)"position");
        int startOffset = sourcePosition.getStartOffset();
        for (int offset = tagEnd = startOffset + element.getTagName().length(); offset < xml.length(); ++offset) {
            char c = xml.charAt(offset);
            if (!Character.isWhitespace(c) && c != '>' && c != '/') continue;
            return c == ' ' ? offset + 1 : offset;
        }
        return xml.length();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean addReplaceString(PendingEditFile file, LintFix.ReplaceString replaceFix, Location fixLocation) {
        int endOffset;
        int startOffset;
        String contents = file.getInitialText();
        String oldPattern = replaceFix.oldPattern;
        String oldString = replaceFix.oldString;
        Location location = replaceFix.range;
        if (location == null) {
            location = fixLocation;
        }
        if (location == null) {
            return false;
        }
        Location location2 = location;
        Position position = location2.getStart();
        if (position == null) {
            return false;
        }
        Position start = position;
        Position position2 = location2.getEnd();
        if (position2 == null) {
            return false;
        }
        Position end = position2;
        String string = contents;
        int n = start.getOffset();
        int n2 = end.getOffset();
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String locationRange = string3;
        String replacement = replaceFix.replacement;
        if (oldString == null && oldPattern == null) {
            char c;
            startOffset = start.getOffset();
            endOffset = end.getOffset();
            boolean allSpace = true;
            int n3 = 0;
            int n4 = replacement.length();
            while (n3 < n4) {
                void offset;
                c = contents.charAt((int)offset);
                if (!Character.isWhitespace(c)) {
                    allSpace = false;
                    break;
                }
                ++offset;
            }
            if (allSpace) {
                int lineEnd;
                char c2;
                int lineBegin;
                for (lineBegin = startOffset; lineBegin > 0 && (c2 = contents.charAt(lineBegin - 1)) != '\n'; --lineBegin) {
                    if (Character.isWhitespace(c2)) continue;
                    allSpace = false;
                    break;
                }
                for (lineEnd = endOffset; lineEnd < contents.length(); ++lineEnd) {
                    c = contents.charAt(lineEnd);
                    if (c != '\n') continue;
                    break;
                }
                if (allSpace) {
                    startOffset = lineBegin;
                    endOffset = lineEnd;
                }
            }
        } else if (oldString != null) {
            int index = StringsKt.indexOf$default((CharSequence)locationRange, (String)oldString, (int)0, (boolean)false, (int)6, null);
            if (index != -1) {
                startOffset = start.getOffset() + index;
                endOffset = start.getOffset() + index + oldString.length();
            } else if (Intrinsics.areEqual((Object)oldString, (Object)"_lint_insert_begin_")) {
                endOffset = startOffset = start.getOffset();
            } else {
                if (!Intrinsics.areEqual((Object)oldString, (Object)"_lint_insert_end_")) throw (Throwable)new IllegalArgumentException("Did not find \"" + oldString + "\" in \"" + locationRange + "\" as suggested in the quickfix. Consider calling " + "ReplaceStringBuilder#range() to set a larger range to " + "search than the default highlight range.");
                endOffset = startOffset = end.getOffset();
            }
        } else {
            Pattern pattern;
            Matcher matcher;
            boolean index;
            boolean bl = index = oldPattern != null;
            if (_Assertions.ENABLED && !index) {
                String lineBegin = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)lineBegin));
            }
            String string4 = oldPattern;
            if (string4 == null) {
                Intrinsics.throwNpe();
            }
            if (!(matcher = (pattern = Pattern.compile(string4)).matcher(locationRange)).find()) {
                throw (Throwable)new IllegalArgumentException("Did not match pattern \"" + oldPattern + "\" in \"" + locationRange + "\" as suggested in the quickfix");
            }
            endOffset = startOffset = start.getOffset();
            if (matcher.groupCount() > 0) {
                if (StringsKt.contains$default((CharSequence)oldPattern, (CharSequence)"target", (boolean)false, (int)2, null)) {
                    try {
                        startOffset += matcher.start("target");
                        endOffset += matcher.end("target");
                    }
                    catch (IllegalArgumentException ignore) {
                        startOffset += matcher.start(1);
                        endOffset += matcher.end(1);
                    }
                } else {
                    startOffset += matcher.start(1);
                    endOffset += matcher.end(1);
                }
            } else {
                startOffset += matcher.start();
                endOffset += matcher.end();
            }
            replacement = replaceFix.expandBackReferences(matcher);
        }
        LintFix lintFix = (LintFix)replaceFix;
        String string5 = replacement;
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"replacement");
        PendingEdit edit = new PendingEdit(lintFix, contents, startOffset, endOffset, string5);
        file.getEdits().add(edit);
        return true;
    }

    @NotNull
    public final LintCliClient getClient() {
        return this.client;
    }

    public LintFixPerformer(@NotNull LintCliClient client, boolean printStatistics2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)client), (String)"client");
        this.client = client;
        this.printStatistics = printStatistics2;
    }

    public /* synthetic */ LintFixPerformer(LintCliClient lintCliClient, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(lintCliClient, bl);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0016\u001a\u0004\u0018\u00010\fJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/lint/LintFixPerformer$PendingEditFile;", "", "client", "Lcom/android/tools/lint/LintCliClient;", "file", "Ljava/io/File;", "initialText", "", "(Lcom/android/tools/lint/LintCliClient;Ljava/io/File;Ljava/lang/String;)V", "getClient", "()Lcom/android/tools/lint/LintCliClient;", "document", "Lorg/w3c/dom/Document;", "edits", "", "Lcom/android/tools/lint/LintFixPerformer$PendingEdit;", "getEdits", "()Ljava/util/List;", "getFile", "()Ljava/io/File;", "getInitialText", "()Ljava/lang/String;", "getXmlDocument", "handleXmlError", "", "e", "", "lint"})
    public static final class PendingEditFile {
        @NotNull
        private final List<PendingEdit> edits;
        private Document document;
        @NotNull
        private final LintCliClient client;
        @NotNull
        private final File file;
        @NotNull
        private final String initialText;

        @NotNull
        public final List<PendingEdit> getEdits() {
            return this.edits;
        }

        @Nullable
        public final Document getXmlDocument() {
            if (this.document == null) {
                try {
                    this.document = PositionXmlParser.parse((String)this.initialText);
                }
                catch (ParserConfigurationException e) {
                    this.handleXmlError(e);
                }
                catch (SAXException e) {
                    this.handleXmlError(e);
                }
                catch (IOException e) {
                    this.handleXmlError(e);
                }
            }
            return this.document;
        }

        private final void handleXmlError(Throwable e) {
            this.client.log(Severity.WARNING, null, "Ignoring " + this.file + ": Failed to parse XML: " + e, new Object[0]);
        }

        @NotNull
        public final LintCliClient getClient() {
            return this.client;
        }

        @NotNull
        public final File getFile() {
            return this.file;
        }

        @NotNull
        public final String getInitialText() {
            return this.initialText;
        }

        public PendingEditFile(@NotNull LintCliClient client, @NotNull File file, @NotNull String initialText) {
            List list;
            Intrinsics.checkParameterIsNotNull((Object)((Object)client), (String)"client");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)initialText, (String)"initialText");
            this.client = client;
            this.file = file;
            this.initialText = initialText;
            PendingEditFile pendingEditFile = this;
            pendingEditFile.edits = list = (List)new ArrayList();
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005J\u0011\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0015\u001a\u0004\u0018\u00010\u0018H\u0096\u0002J\u0006\u0010\u0019\u001a\u00020\u0005J\b\u0010\u001a\u001a\u00020\u0007H\u0016J\b\u0010\u001b\u001a\u00020\u0017H\u0002J\b\u0010\u001c\u001a\u00020\u0005H\u0016R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\f\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/lint/LintFixPerformer$PendingEdit;", "", "fix", "Lcom/android/tools/lint/detector/api/LintFix;", "source", "", "startOffset", "", "endOffset", "replacement", "(Lcom/android/tools/lint/detector/api/LintFix;Ljava/lang/String;IILjava/lang/String;)V", "getEndOffset", "()I", "getFix", "()Lcom/android/tools/lint/detector/api/LintFix;", "getSource", "()Ljava/lang/String;", "getStartOffset", "apply", "contents", "compareTo", "other", "equals", "", "", "fixName", "hashCode", "isDelete", "toString", "lint"})
    public static final class PendingEdit
    implements Comparable<PendingEdit> {
        @NotNull
        private final LintFix fix;
        @NotNull
        private final String source;
        private final int startOffset;
        private final int endOffset;
        private final String replacement;

        @Override
        public int compareTo(@NotNull PendingEdit other) {
            int d2;
            Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
            int delta = other.startOffset - this.startOffset;
            if (delta != 0) {
                return delta;
            }
            int d1 = this.isDelete() ? 0 : 1;
            int deleteDelta = d1 - (d2 = other.isDelete() ? 0 : 1);
            if (deleteDelta != 0) {
                return deleteDelta;
            }
            return other.endOffset - this.endOffset;
        }

        @NotNull
        public final String apply(@NotNull String contents) {
            Intrinsics.checkParameterIsNotNull((Object)contents, (String)"contents");
            String string = contents;
            int n = 0;
            int n2 = this.startOffset;
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = string.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String string3 = string2;
            string = contents;
            n = this.endOffset;
            stringBuilder = stringBuilder.append(string3).append(this.replacement);
            String string4 = string.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            string3 = string4;
            return stringBuilder.append(string3).toString();
        }

        private final boolean isDelete() {
            return this.endOffset > this.startOffset;
        }

        @NotNull
        public final String fixName() {
            String string = this.fix.getFamilyName();
            if (string == null) {
                String string2 = this.fix.getDisplayName();
                if (string2 == null) {
                    String string3 = this.fix.getClass().getSimpleName();
                    string2 = string3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"fix.javaClass.simpleName");
                }
                return string2;
            }
            return string;
        }

        @NotNull
        public String toString() {
            String string;
            CharSequence charSequence = this.replacement;
            if (charSequence.length() == 0) {
                charSequence = this.source;
                int n = this.startOffset;
                int n2 = this.endOffset;
                StringBuilder stringBuilder = new StringBuilder().append("At ").append(this.startOffset).append(", delete \"");
                CharSequence charSequence2 = charSequence;
                if (charSequence2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string2 = ((String)charSequence2).substring(n, n2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String string3 = string2;
                string = stringBuilder.append(string3).append('\"').toString();
            } else if (this.startOffset == this.endOffset) {
                string = "At " + this.startOffset + ", insert \"" + this.replacement + '\"';
            } else {
                charSequence = this.source;
                int n = this.startOffset;
                int n3 = this.endOffset;
                StringBuilder stringBuilder = new StringBuilder().append("At ").append(this.startOffset).append(", change \"");
                CharSequence charSequence3 = charSequence;
                if (charSequence3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = ((String)charSequence3).substring(n, n3);
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String string5 = string4;
                string = stringBuilder.append(string5).append("\" to \"").append(this.replacement).append('\"').toString();
            }
            return string;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
                return false;
            }
            Object object2 = other;
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.android.tools.lint.LintFixPerformer.PendingEdit");
            }
            PendingEdit cfr_ignored_0 = (PendingEdit)object2;
            if (this.startOffset != ((PendingEdit)other).startOffset) {
                return false;
            }
            if (this.endOffset != ((PendingEdit)other).endOffset) {
                return false;
            }
            return !(Intrinsics.areEqual((Object)this.replacement, (Object)((PendingEdit)other).replacement) ^ true);
        }

        public int hashCode() {
            int result = this.startOffset;
            result = 31 * result + this.endOffset;
            result = 31 * result + this.replacement.hashCode();
            return result;
        }

        @NotNull
        public final LintFix getFix() {
            return this.fix;
        }

        @NotNull
        public final String getSource() {
            return this.source;
        }

        public final int getStartOffset() {
            return this.startOffset;
        }

        public final int getEndOffset() {
            return this.endOffset;
        }

        public PendingEdit(@NotNull LintFix fix, @NotNull String source, int startOffset, int endOffset, @NotNull String replacement) {
            Intrinsics.checkParameterIsNotNull((Object)fix, (String)"fix");
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            Intrinsics.checkParameterIsNotNull((Object)replacement, (String)"replacement");
            this.fix = fix;
            this.source = source;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.replacement = replacement;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\nH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/lint/LintFixPerformer$Companion;", "", "()V", "canAutoFix", "", "lintFix", "Lcom/android/tools/lint/detector/api/LintFix;", "compareAttributeNames", "", "n1", "", "n2", "rankAttributeNames", "name", "lint"})
    public static final class Companion {
        public final boolean canAutoFix(@NotNull LintFix lintFix) {
            Intrinsics.checkParameterIsNotNull((Object)lintFix, (String)"lintFix");
            if (lintFix instanceof LintFix.LintFixGroup) {
                if (Intrinsics.areEqual((Object)((LintFix.LintFixGroup)lintFix).type, (Object)LintFix.GroupType.ALTERNATIVES)) {
                    return false;
                }
                if (Intrinsics.areEqual((Object)((LintFix.LintFixGroup)lintFix).type, (Object)LintFix.GroupType.COMPOSITE)) {
                    Iterator iterator = ((LintFix.LintFixGroup)lintFix).fixes.iterator();
                    while (iterator.hasNext()) {
                        LintFix nested;
                        LintFix lintFix2 = nested = (LintFix)iterator.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)lintFix2, (String)"nested");
                        if (this.canAutoFix(lintFix2)) continue;
                        return false;
                    }
                    return true;
                }
            }
            if (!lintFix.robot) {
                return false;
            }
            return lintFix.independent;
        }

        public final int compareAttributeNames(@NotNull String n1, @NotNull String n2) {
            Intrinsics.checkParameterIsNotNull((Object)n1, (String)"n1");
            Intrinsics.checkParameterIsNotNull((Object)n2, (String)"n2");
            int rank1 = this.rankAttributeNames(n1);
            int rank2 = this.rankAttributeNames(n2);
            int delta = rank1 - rank2;
            if (delta != 0) {
                return delta;
            }
            return n1.compareTo(n2);
        }

        private final int rankAttributeNames(String name) {
            return Intrinsics.areEqual((Object)name, (Object)"id") || Intrinsics.areEqual((Object)name, (Object)"name") ? 0 : (Intrinsics.areEqual((Object)name, (Object)"style") ? 10 : (Intrinsics.areEqual((Object)name, (Object)"layout") ? 20 : (Intrinsics.areEqual((Object)name, (Object)"layout_width") ? 30 : (Intrinsics.areEqual((Object)name, (Object)"layout_height") ? 40 : (StringsKt.startsWith$default((String)name, (String)"layout_", (boolean)false, (int)2, null) ? 50 : 60)))));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

