/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.SdkConstants;
import com.android.ide.common.repository.ResourceVisibilityLookup;
import com.android.tools.lint.ManualProject;
import com.android.tools.lint.ProjectInitializerKt;
import com.android.tools.lint.ProjectMetadata;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.utils.XmlUtils;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.io.ByteStreams;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010 \u001a\u00020!J\b\u0010\"\u001a\u00020#H\u0002J\u001c\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00050\u00152\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00050\u0018H\u0002J2\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00050\u00182\u0006\u0010'\u001a\u00020\u00112\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00050\u00152\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00050\u0015H\u0002J\u0012\u0010*\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0012\u0010+\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J \u0010\u0012\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\u00112\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0005H\u0002J.\u0010\u0012\u001a\u00020\u00052\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u00052\n\b\u0002\u00100\u001a\u0004\u0018\u00010\u00112\b\b\u0002\u00101\u001a\u000202H\u0002J\u001a\u00103\u001a\u0004\u0018\u00010\u00112\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0005H\u0002J\u001a\u00104\u001a\u0004\u0018\u00010\u00112\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0005H\u0002J\u0010\u00105\u001a\u00020#2\u0006\u00106\u001a\u00020.H\u0002J\u0010\u00107\u001a\u00020!2\u0006\u00108\u001a\u00020.H\u0002J\u001c\u00109\u001a\u00020#2\u0006\u0010:\u001a\u00020\u00112\n\b\u0002\u0010;\u001a\u0004\u0018\u00010<H\u0002J\u0018\u0010=\u001a\u00020#2\u0006\u0010>\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\u0005H\u0007R\u001c\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00110\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00180\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00100\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0013\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u001f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/android/tools/lint/ProjectInitializer;", "", "client", "Lcom/android/tools/lint/client/api/LintClient;", "file", "Ljava/io/File;", "root", "(Lcom/android/tools/lint/client/api/LintClient;Ljava/io/File;Ljava/io/File;)V", "baselines", "", "Lcom/android/tools/lint/detector/api/Project;", "cache", "getClient", "()Lcom/android/tools/lint/client/api/LintClient;", "dependencies", "Lcom/google/common/collect/Multimap;", "Lcom/android/tools/lint/ManualProject;", "", "getFile", "()Ljava/io/File;", "globalClasspath", "", "jarAarMap", "lintChecks", "", "mergedManifests", "modules", "getRoot", "setRoot", "(Ljava/io/File;)V", "visibility", "Lcom/android/ide/common/repository/ResourceVisibilityLookup;", "computeMetadata", "Lcom/android/tools/lint/ProjectMetadata;", "computeResourceVisibility", "", "computeSourceRoots", "sources", "computeUniqueSourceRoots", "type", "typeSources", "sourceRoots", "findPackage", "findRoot", "path", "element", "Lorg/w3c/dom/Element;", "dir", "attribute", "required", "", "parseAar", "parseJar", "parseModule", "moduleElement", "parseModules", "projectElement", "reportError", "message", "node", "Lorg/w3c/dom/Node;", "unpackZipFile", "zip", "lint"})
final class ProjectInitializer {
    private final Map<String, ManualProject> modules;
    private final List<File> globalClasspath;
    private final Multimap<ManualProject, String> dependencies;
    private final Map<Project, File> mergedManifests;
    private final Map<Project, List<File>> lintChecks;
    private final Map<Project, File> baselines;
    private final Map<File, String> jarAarMap;
    private final Map<String, ResourceVisibilityLookup> visibility;
    private File cache;
    @NotNull
    private final LintClient client;
    @NotNull
    private final File file;
    @NotNull
    private File root;

    @NotNull
    public final ProjectMetadata computeMetadata() {
        boolean bl = this.file.isFile();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Document document = this.client.getXmlParser().parseXml(this.file);
        if (document == null || document.getDocumentElement() == null) {
            ProjectInitializer.reportError$default(this, "Failed to parse project descriptor " + this.file, null, 2, null);
            return new ProjectMetadata(null, null, null, null, null, null, null, null, null, false, 1023, null);
        }
        Element element = document.getDocumentElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"document.documentElement");
        return this.parseModules(element);
    }

    private final void reportError(String message, Node node) {
        Location location = node != null ? this.client.getXmlParser().getLocation(this.file, node) : Location.Companion.create(this.file);
        File file = this.file;
        LintDriver lintDriver = null;
        Project project = null;
        Project project2 = null;
        Context context = null;
        Severity severity = null;
        Configuration configuration = null;
        LintFix lintFix = null;
        TextFormat textFormat = null;
        Location location2 = location;
        LintClient.Companion.report$default((LintClient.Companion)LintClient.Companion, (LintClient)this.client, (Issue)IssueRegistry.LINT_ERROR, (String)message, (File)file, textFormat, lintFix, configuration, severity, context, project2, project, lintDriver, (Location)location2, (int)4080, null);
    }

    static /* bridge */ /* synthetic */ void reportError$default(ProjectInitializer projectInitializer, String string, Node node, int n, Object object) {
        if ((n & 2) != 0) {
            node = null;
        }
        projectInitializer.reportError(string, node);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final ProjectMetadata parseModules(Element projectElement) {
        if (Intrinsics.areEqual((Object)projectElement.getTagName(), (Object)"project") ^ true) {
            this.reportError("Expected <project> as the root tag", projectElement);
            return new ProjectMetadata(null, null, null, null, null, null, null, null, null, false, 1023, null);
        }
        incomplete = Intrinsics.areEqual((Object)projectElement.getAttribute("incomplete"), (Object)"true");
        globalLintChecks = new ArrayList<E>();
        child = XmlUtils.getFirstSubTag((Node)projectElement);
        sdk = null;
        baseline = null;
        jdkBootClasspath = new ArrayList<E>();
        while (child != null) {
            block32: {
                block24: {
                    block28: {
                        block25: {
                            block30: {
                                block27: {
                                    block29: {
                                        block31: {
                                            block26: {
                                                tag = child.getTagName();
                                                v0 = var9_9 = tag;
                                                if (v0 == null) break block24;
                                                switch (v0.hashCode()) {
                                                    case 94416770: {
                                                        if (!var9_9.equals("cache")) ** break;
                                                        break block25;
                                                    }
                                                    case -8875619: {
                                                        if (!var9_9.equals("classpath")) ** break;
                                                        break block26;
                                                    }
                                                    case -1710494882: {
                                                        if (!var9_9.equals("jdk-boot-classpath")) ** break;
                                                        break block27;
                                                    }
                                                    case -1068784020: {
                                                        if (!var9_9.equals("module")) ** break;
                                                        break;
                                                    }
                                                    case 3506402: {
                                                        if (!var9_9.equals("root")) ** break;
                                                        break block28;
                                                    }
                                                    case 113722: {
                                                        if (!var9_9.equals("sdk")) ** break;
                                                        break block29;
                                                    }
                                                    case -1720785339: {
                                                        if (!var9_9.equals("baseline")) ** break;
                                                        break block30;
                                                    }
                                                    case -983827083: {
                                                        if (!var9_9.equals("lint-checks")) ** break;
                                                        break block31;
                                                    }
                                                }
                                                this.parseModule(child);
                                                break block32;
                                            }
                                            this.globalClasspath.add(ProjectInitializer.getFile$default(this, child, this.root, null, false, 12, null));
                                            break block32;
                                        }
                                        globalLintChecks.add(ProjectInitializer.getFile$default(this, child, this.root, null, false, 12, null));
                                        break block32;
                                    }
                                    sdk = ProjectInitializer.getFile$default(this, child, this.root, null, false, 12, null);
                                    break block32;
                                }
                                v1 = path = child.getAttribute("path");
                                Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"path");
                                var11_11 = v1;
                                if (var11_11.length() > 0) {
                                    for (Object s : StringsKt.split$default((CharSequence)path, (char[])new char[]{File.pathSeparatorChar}, (boolean)false, (int)0, (int)6, null)) {
                                        var13_17 = jdkBootClasspath;
                                        var14_18 = this.getFile((String)s, child, this.root);
                                        var13_17.add(var14_18);
                                    }
                                } else {
                                    s = jdkBootClasspath;
                                    var12_15 = ProjectInitializer.getFile$default(this, child, this.root, null, false, 12, null);
                                    s.add(var12_15);
                                }
                                break block32;
                            }
                            baseline = ProjectInitializer.getFile$default(this, child, this.root, null, false, 12, null);
                            break block32;
                        }
                        this.cache = ProjectInitializer.getFile$default(this, child, this.root, null, false, 12, null);
                        break block32;
                    }
                    dir = new File(child.getAttribute("dir"));
                    if (dir.isDirectory()) {
                        this.root = dir;
                    } else {
                        this.reportError("" + dir + " does not exist", child);
                    }
                    break block32;
                }
                this.reportError("Unexpected top level tag " + (String)tag + " in " + this.file, child);
            }
            child = XmlUtils.getNextTag((Node)child);
        }
        var9_9 = this.dependencies.entries().iterator();
        while (var9_9.hasNext()) {
            var12_15 = tag = (Map.Entry)var9_9.next();
            module = (ManualProject)var12_15.getKey();
            var12_15 = tag;
            dependencyName = (String)var12_15.getValue();
            to /* !! */  = this.modules.get(dependencyName);
            if (to /* !! */  != null) {
                module.addDirectDependency(to /* !! */ );
                continue;
            }
            v2 = new StringBuilder().append("No module ").append(dependencyName).append(" found (depended on by ");
            v3 = module;
            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"module");
            ProjectInitializer.reportError$default(this, v2.append(v3.getName()).toString(), null, 2, null);
        }
        allModules = this.modules.values();
        roots = new HashSet<ManualProject>(allModules);
        for (ManualProject project : allModules) {
            to /* !! */  = roots;
            v4 = project.getAllLibraries();
            Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"project.allLibraries");
            var13_17 = v4;
            TypeIntrinsics.asMutableCollection((Object)to /* !! */ ).removeAll((Collection<?>)var13_17);
        }
        sortedModules = CollectionsKt.toMutableList((Collection)roots);
        $receiver$iv = sortedModules;
        if ($receiver$iv.size() > 1) {
            CollectionsKt.sortWith((List)$receiver$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    ManualProject it;
                    ManualProject manualProject = it = (ManualProject)((Object)a);
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)manualProject), (String)"it");
                    it = (ManualProject)((Object)b);
                    Comparable comparable = (Comparable)((Object)manualProject.getName());
                    ManualProject manualProject2 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)manualProject2), (String)"it");
                    String string = manualProject2.getName();
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string)));
                }
            });
        }
        if (!this.globalClasspath.isEmpty()) {
            useForAnalysis = true;
            for (ManualProject module : sortedModules) {
                if (module.getJavaLibraries(true).isEmpty()) {
                    module.setClasspath(this.globalClasspath, false);
                }
                v5 = module;
                Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"module");
                if (!v5.getJavaClassFolders().isEmpty()) continue;
                module.setClasspath(this.globalClasspath, useForAnalysis);
                useForAnalysis = false;
            }
        }
        this.computeResourceVisibility();
        var11_14 = jdkBootClasspath;
        var12_16 = incomplete;
        var13_17 = this.mergedManifests;
        var14_18 = this.baselines;
        var15_19 = this.cache;
        var16_20 = this.lintChecks;
        var17_21 = globalLintChecks;
        var18_22 = baseline;
        var19_23 = sdk;
        return new ProjectMetadata(sortedModules, var18_22, var19_23, var15_19, var13_17, (Map<Project, ? extends File>)var14_18, var17_21, var16_20, var11_14, var12_16);
    }

    private final void computeResourceVisibility() {
        for (ManualProject module : this.modules.values()) {
            List aarDeps = new ArrayList();
            for (String dependencyName : this.dependencies.get((Object)module)) {
                ResourceVisibilityLookup visibility;
                if (this.visibility.get(dependencyName) == null) {
                    continue;
                }
                aarDeps.add(visibility);
            }
            if (aarDeps.isEmpty()) continue;
            ResourceVisibilityLookup visibilityLookup = aarDeps.size() == 1 ? (ResourceVisibilityLookup)aarDeps.get(0) : ResourceVisibilityLookup.create((List)aarDeps);
            module.setResourceVisibility(visibilityLookup);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void parseModule(Element moduleElement) {
        v0 = moduleElement.getAttribute("name");
        Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"moduleElement.getAttribute(ATTR_NAME)");
        name = v0;
        library = Intrinsics.areEqual((Object)moduleElement.getAttribute("library"), (Object)"true");
        android = Intrinsics.areEqual((Object)moduleElement.getAttribute("android"), (Object)"false") ^ true;
        v1 = moduleElement.getAttribute("compile-sdk-version");
        Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"moduleElement.getAttribu\u2026ATTR_COMPILE_SDK_VERSION)");
        buildApi = v1;
        StringsKt.indexOf$default((CharSequence)name, (char)':', (int)StringsKt.lastIndexOf$default((CharSequence)name, (char)File.separatorChar, (int)0, (boolean)false, (int)6, null), (boolean)false, (int)4, null);
        v2 = name;
        v3 = File.separator;
        Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"File.separator");
        if (!StringsKt.contains$default((CharSequence)v2, (CharSequence)v3, (boolean)false, (int)2, null)) ** GOTO lbl-1000
        v4 = name;
        v5 = name;
        v6 = File.separator;
        Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"File.separator");
        if (StringsKt.indexOf$default((CharSequence)v4, (char)':', (int)StringsKt.lastIndexOf$default((CharSequence)v5, (String)v6, (int)0, (boolean)false, (int)6, null), (boolean)false, (int)4, null) != -1) {
            var7_6 = name;
            var8_7 = 0;
            v7 = name;
            v8 = name;
            v9 = File.separator;
            Intrinsics.checkExpressionValueIsNotNull((Object)v9, (String)"File.separator");
            var9_9 = StringsKt.indexOf$default((CharSequence)v7, (char)':', (int)StringsKt.lastIndexOf$default((CharSequence)v8, (String)v9, (int)0, (boolean)false, (int)6, null), (boolean)false, (int)4, null);
            var28_11 = v10;
            var27_12 = v10;
            v11 = var7_6;
            if (v11 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            v12 = v11.substring(var8_7, var9_9);
            Intrinsics.checkExpressionValueIsNotNull((Object)v12, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            var29_13 = v12;
            v13 = var27_12;
            var28_11(var29_13);
        } else lbl-1000:
        // 2 sources

        {
            v13 = this.root;
        }
        dir = v13;
        module = new ManualProject(this.client, dir, name, library, android);
        var8_8 = this.modules;
        var9_10 = module;
        var8_8.put(name, var9_10);
        sources = new ArrayList<E>();
        generatedSources = new ArrayList<E>();
        testSources = new ArrayList<E>();
        resources = new ArrayList<E>();
        manifests = new ArrayList<E>();
        classes = new ArrayList<E>();
        classpath = new ArrayList<E>();
        lintChecks = new ArrayList<E>();
        baseline = null;
        mergedManifest = null;
        child = XmlUtils.getFirstSubTag((Node)moduleElement);
        while (child != null) {
            block41: {
                block32: {
                    block40: {
                        block39: {
                            block38: {
                                block43: {
                                    block42: {
                                        block35: {
                                            block36: {
                                                block34: {
                                                    block33: {
                                                        block37: {
                                                            v14 = var19_24 = child.getTagName();
                                                            if (v14 == null) break block32;
                                                            switch (v14.hashCode()) {
                                                                case 114148: {
                                                                    if (!var19_24.equals("src")) ** break;
                                                                    break block33;
                                                                }
                                                                case -341064690: {
                                                                    if (!var19_24.equals("resource")) ** break;
                                                                    break block34;
                                                                }
                                                                case -8875619: {
                                                                    if (!var19_24.equals("classpath")) ** break;
                                                                    break block35;
                                                                }
                                                                case 130625071: {
                                                                    if (!var19_24.equals("manifest")) ** break;
                                                                    break;
                                                                }
                                                                case 853620774: {
                                                                    if (!var19_24.equals("classes")) ** break;
                                                                    break block36;
                                                                }
                                                                case -260399184: {
                                                                    if (!var19_24.equals("merged-manifest")) ** break;
                                                                    break block37;
                                                                }
                                                                case -1720785339: {
                                                                    if (!var19_24.equals("baseline")) ** break;
                                                                    break block38;
                                                                }
                                                                case -983827083: {
                                                                    if (!var19_24.equals("lint-checks")) ** break;
                                                                    break block39;
                                                                }
                                                                case 99343: {
                                                                    if (!var19_24.equals("dep")) ** break;
                                                                    break block40;
                                                                }
                                                                case -1000992744: {
                                                                    if (!var19_24.equals("proguard")) ** break;
                                                                    break block41;
                                                                }
                                                                case 96338: {
                                                                    if (!var19_24.equals("aar")) ** break;
                                                                    break block42;
                                                                }
                                                                case 104987: {
                                                                    if (!var19_24.equals("jar")) ** break;
                                                                    break block43;
                                                                }
                                                                case 2993840: {
                                                                    if (!var19_24.equals("aidl")) ** break;
                                                                    break block41;
                                                                }
                                                            }
                                                            manifests.add(ProjectInitializer.getFile$default(this, child, dir, null, false, 12, null));
                                                            break block41;
                                                        }
                                                        mergedManifest = ProjectInitializer.getFile$default(this, child, dir, null, false, 12, null);
                                                        break block41;
                                                    }
                                                    file = ProjectInitializer.getFile$default(this, child, dir, null, false, 12, null);
                                                    var21_26 = Intrinsics.areEqual((Object)child.getAttribute("generated"), (Object)"true");
                                                    if (var21_26) {
                                                        generatedSources.add(file);
                                                    } else if (!var21_26) {
                                                        var22_31 = Intrinsics.areEqual((Object)child.getAttribute("test"), (Object)"true");
                                                        if (!var22_31) {
                                                            sources.add(file);
                                                        } else if (var22_31) {
                                                            testSources.add(file);
                                                        }
                                                    }
                                                    break block41;
                                                }
                                                resources.add(ProjectInitializer.getFile$default(this, child, dir, null, false, 12, null));
                                                break block41;
                                            }
                                            classes.add(ProjectInitializer.getFile$default(this, child, dir, null, false, 12, null));
                                            break block41;
                                        }
                                        classpath.add(ProjectInitializer.getFile$default(this, child, dir, null, false, 12, null));
                                        break block41;
                                    }
                                    aar = this.parseAar(child, dir);
                                    if (aar != null) {
                                        it = var21_27;
                                        this.dependencies.put((Object)module, (Object)aar);
                                    }
                                    break block41;
                                }
                                jar = this.parseJar(child, dir);
                                if (jar != null) {
                                    it = var21_28;
                                    this.dependencies.put((Object)module, (Object)jar);
                                }
                                break block41;
                            }
                            baseline = ProjectInitializer.getFile$default(this, child, dir, null, false, 12, null);
                            break block41;
                        }
                        lintChecks.add(ProjectInitializer.getFile$default(this, child, dir, null, false, 12, null));
                        break block41;
                    }
                    v15 = target = child.getAttribute("module");
                    Intrinsics.checkExpressionValueIsNotNull((Object)v15, (String)"target");
                    var21_29 = v15;
                    if (var21_29.length() == 0) {
                        this.reportError("Invalid module dependency in " + module.getName(), child);
                    }
                    this.dependencies.put((Object)module, (Object)target);
                    break block41;
                }
                this.reportError("Unexpected tag " + child.getTagName(), child);
                return;
            }
            child = XmlUtils.getNextTag((Node)child);
        }
        sourceRoots = this.computeSourceRoots(sources);
        testSourceRoots = this.computeUniqueSourceRoots("test", testSources, sourceRoots);
        generatedSourceRoots = this.computeUniqueSourceRoots("generated", generatedSources, sourceRoots);
        resourceRoots = new ArrayList<E>();
        if (!resources.isEmpty()) {
            for (File file : resources) {
                if (file.getParentFile() == null) {
                    continue;
                }
                if (typeFolder.getParentFile() == null) {
                    continue;
                }
                if (resourceRoots.contains(res)) continue;
                resourceRoots.add(res);
            }
        }
        module.setManifests(manifests);
        module.setResources(resourceRoots, resources);
        module.setTestSources(testSourceRoots, testSources);
        module.setGeneratedSources(generatedSourceRoots, generatedSources);
        module.setSources(sourceRoots, sources);
        module.setClasspath(classes, true);
        module.setClasspath(classpath, false);
        module.setCompileSdkVersion(buildApi);
        var23_36 = this.lintChecks;
        var24_35 = lintChecks;
        var23_36.put(module, (List<File>)var24_35);
        var23_36 = this.mergedManifests;
        var24_35 = mergedManifest;
        var23_36.put(module, (List<File>)var24_35);
        var23_36 = this.baselines;
        var24_35 = baseline;
        var23_36.put(module, var24_35);
        v16 = module.getDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)v16, (String)"module.dir");
        this.client.registerProject(v16, (Project)module);
    }

    /*
     * WARNING - void declaration
     */
    private final String parseAar(Element element, File dir) {
        File classesJar;
        String string;
        String $receiver$iv;
        Object object;
        Object it;
        File resources;
        File file;
        ProjectInitializer projectInitializer;
        File aarFile = ProjectInitializer.getFile$default(this, element, dir, null, false, 12, null);
        String moduleName = this.jarAarMap.get(aarFile);
        if (moduleName != null) {
            return moduleName;
        }
        String name = aarFile.getName();
        ProjectInitializer $receiver = projectInitializer = this;
        File expanded = $receiver.getFile(element, dir, "extracted", false);
        String string2 = expanded.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"expanded.path");
        CharSequence charSequence = string2;
        if (charSequence.length() == 0) {
            File cacheDir = $receiver.cache != null ? new File($receiver.cache, "aars") : $receiver.client.getCacheDir("aars", true);
            File target = new File(cacheDir, name);
            if (!target.isDirectory()) {
                $receiver.unpackZipFile(aarFile, target);
            }
            file = target;
        } else {
            if (!expanded.isDirectory()) {
                ProjectInitializer.reportError$default($receiver, "Expanded AAR path " + expanded + " is not a directory", null, 2, null);
            }
            file = expanded;
        }
        File expanded2 = file;
        String string3 = name;
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"name");
        ManualProject project = new ManualProject(this.client, expanded2, string3, true, true);
        project.setReportIssues(false);
        File manifest = new File(expanded2, "AndroidManifest.xml");
        if (manifest.isFile()) {
            project.setManifests(CollectionsKt.listOf((Object)manifest));
        }
        if ((resources = new File(expanded2, "res")).isDirectory()) {
            project.setResources(CollectionsKt.listOf((Object)resources), CollectionsKt.emptyList());
        }
        List jarList = new ArrayList();
        File jarsDir = new File(expanded2, "jars");
        if (jarsDir.isDirectory()) {
            File[] fileArray = jarsDir.listFiles();
            if (fileArray != null) {
                void $receiver$iv$iv;
                File[] $i$a$1$run = fileArray;
                it = $i$a$1$run;
                Object[] objectArray = (Object[])it;
                object = jarList;
                string = $receiver$iv;
                Collection destination$iv$iv = new ArrayList();
                for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
                    File name2;
                    void element$iv$iv = $receiver$iv$iv[i];
                    File file2 = name2 = (File)element$iv$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"name");
                    if (!FilesKt.endsWith((File)file2, (String)".jar")) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List list = (List)destination$iv$iv;
                object.addAll(CollectionsKt.toList((Iterable)list));
            }
        }
        if ((classesJar = new File(expanded2, "classes.jar")).isFile()) {
            jarList.add(classesJar);
        }
        if (!(it = (Collection)jarList).isEmpty()) {
            project.setClasspath(jarList, false);
        }
        it = this.jarAarMap;
        $receiver$iv = name;
        it.put(aarFile, $receiver$iv);
        it = this.modules;
        $receiver$iv = name;
        object = project;
        it.put($receiver$iv, object);
        File publicResources = new File(expanded2, "public.txt");
        File allResources = new File(expanded2, "R.txt");
        object = this.visibility;
        string = name;
        ResourceVisibilityLookup resourceVisibilityLookup = ResourceVisibilityLookup.create((File)publicResources, (File)allResources, (String)name);
        Intrinsics.checkExpressionValueIsNotNull((Object)resourceVisibilityLookup, (String)"ResourceVisibilityLookup\u2026rces, allResources, name)");
        ResourceVisibilityLookup resourceVisibilityLookup2 = resourceVisibilityLookup;
        object.put(string, resourceVisibilityLookup2);
        return name;
    }

    private final String parseJar(Element element, File dir) {
        String name;
        File jarFile = ProjectInitializer.getFile$default(this, element, dir, null, false, 12, null);
        String moduleName = this.jarAarMap.get(jarFile);
        if (moduleName != null) {
            return moduleName;
        }
        String string = name = jarFile.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
        ManualProject project = new ManualProject(this.client, jarFile, string, true, false);
        project.setReportIssues(false);
        project.setClasspath(CollectionsKt.listOf((Object)jarFile), false);
        Map<Object, Object> map = this.jarAarMap;
        String string2 = name;
        map.put(jarFile, string2);
        map = this.modules;
        string2 = name;
        ManualProject manualProject = project;
        map.put((File)((Object)string2), (String)((Object)manualProject));
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unpackZipFile(@NotNull File zip, @NotNull File dir) throws ZipException, IOException {
        Intrinsics.checkParameterIsNotNull((Object)zip, (String)"zip");
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        Closeable closeable = new ZipFile(zip);
        Throwable throwable = null;
        try {
            ZipFile zipFile = (ZipFile)closeable;
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry;
                ZipEntry zipEntry2 = zipEntry = entries.nextElement();
                Intrinsics.checkExpressionValueIsNotNull((Object)zipEntry2, (String)"zipEntry");
                if (zipEntry2.isDirectory()) continue;
                File targetFile = new File(dir, zipEntry.getName());
                Files.createParentDirs((File)targetFile);
                Closeable closeable2 = Files.asByteSink((File)targetFile, (FileWriteMode[])new FileWriteMode[0]).openBufferedStream();
                Throwable throwable2 = null;
                try {
                    OutputStream it = (OutputStream)closeable2;
                    long l = ByteStreams.copy((InputStream)zipFile.getInputStream(zipEntry), (OutputStream)it);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final List<File> computeUniqueSourceRoots(String type, List<File> typeSources, List<File> sourceRoots) {
        if (typeSources.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        List<File> typeSourceRoots = this.computeSourceRoots(typeSources);
        for (File root : typeSourceRoots) {
            if (!sourceRoots.contains(root)) continue;
            ProjectInitializer.reportError$default(this, "" + StringsKt.capitalize((String)type) + " sources cannot be in the same " + "source root as production files; " + "source root " + root + " is also a test root", null, 2, null);
            break;
        }
        typeSourceRoots.removeAll((Collection)sourceRoots);
        return typeSourceRoots;
    }

    private final List<File> computeSourceRoots(List<? extends File> sources) {
        List sourceRoots = new ArrayList();
        if (!sources.isEmpty()) {
            Map dirToRootCache = new LinkedHashMap();
            for (File file : sources) {
                String string;
                File file2;
                File parent;
                if (file.getParentFile() == null) {
                    continue;
                }
                File found = (File)dirToRootCache.get(parent.getPath());
                if (found != null) continue;
                File file3 = this.findRoot(file);
                if (file3 == null) {
                    file3 = file2 = file.getParentFile();
                }
                if (file3 == null) {
                    File file4 = file.getAbsoluteFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file4, (String)"file.absoluteFile");
                    file2 = file4.getParentFile();
                }
                if (file2 == null) {
                    continue;
                }
                File root = file2;
                Map map = dirToRootCache;
                Intrinsics.checkExpressionValueIsNotNull((Object)parent.getPath(), (String)"parent.path");
                File file5 = root;
                map.put(string, file5);
                if (sourceRoots.contains(root)) continue;
                sourceRoots.add(root);
            }
        }
        return sourceRoots;
    }

    private final File getFile(Element element, File dir, String attribute, boolean required) {
        CharSequence charSequence;
        String path;
        if (attribute != null) {
            String string = element.getAttribute(attribute);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"element.getAttribute(attribute)");
            path = string;
            charSequence = path;
            if (charSequence.length() == 0 && required) {
                this.reportError("Must specify " + attribute + "= attribute", element);
            }
        } else {
            String string = element.getAttribute("file");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"element.getAttribute(ATTR_FILE)");
            path = string;
            charSequence = path;
            if (charSequence.length() == 0) {
                String string2 = element.getAttribute("dir");
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"element.getAttribute(ATTR_DIR)");
                path = string2;
                charSequence = path;
                if (charSequence.length() == 0) {
                    String string3 = element.getAttribute("jar");
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"element.getAttribute(ATTR_JAR)");
                    path = string3;
                }
            }
        }
        charSequence = path;
        if (charSequence.length() == 0) {
            if (required) {
                ProjectInitializer.reportError$default(this, "Must specify file/dir/jar on <" + element.getTagName() + '>', null, 2, null);
            }
            return new File("");
        }
        return this.getFile(path, element, dir);
    }

    static /* bridge */ /* synthetic */ File getFile$default(ProjectInitializer projectInitializer, Element element, File file, String string, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return projectInitializer.getFile(element, file, string, bl);
    }

    private final File getFile(String path, Element element, File dir) {
        File source = new File(path);
        if (!source.isAbsolute()) {
            if (!source.exists()) {
                source = new File(dir, path);
                if (!source.exists()) {
                    source = new File(this.root, path);
                }
            } else {
                File file = source.getAbsoluteFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"source.absoluteFile");
                return file;
            }
        }
        if (!source.exists()) {
            String string;
            if (SdkConstants.currentPlatform() == 2) {
                String string2 = dir.getCanonicalPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"dir.canonicalPath");
                String string3 = File.separator;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"File.separator");
                string = StringsKt.replace$default((String)string2, (String)string3, (String)"\\\\", (boolean)false, (int)4, null);
            } else {
                string = dir.getCanonicalPath();
            }
            String relativePath = string;
            this.reportError("" + path + ' ' + (!new File(path).isAbsolute() ? "(relative to " + relativePath + ") " : "") + "does not exist", element);
        }
        return source;
    }

    private final File findRoot(File file) {
        String path;
        String string = path = file.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"path");
        if (StringsKt.endsWith$default((String)string, (String)".java", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)path, (String)".kt", (boolean)false, (int)2, null)) {
            File file2;
            String string2 = this.findPackage(file);
            if (string2 == null) {
                return null;
            }
            String pkg = string2;
            File file3 = file.getParentFile();
            if (file3 == null) {
                return null;
            }
            File parent = file3;
            String string3 = path;
            int n = 0;
            int n2 = parent.getPath().length() - pkg.length();
            File file4 = file2;
            File file5 = file2;
            String string4 = string3.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String string5 = string4;
            file4(string5);
            return file5;
        }
        return null;
    }

    private final String findPackage(File file) {
        String string;
        CharSequence source = this.client.readFile(file);
        Matcher matcher = ProjectInitializerKt.access$getPACKAGE_PATTERN$p().matcher(source);
        boolean foundPackage = matcher.find();
        if (foundPackage) {
            String string2 = matcher.group(1);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"matcher.group(1)");
            String $receiver$iv = string2;
            CharSequence $receiver$iv$iv = $receiver$iv;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $receiver$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $receiver$iv$iv.charAt(index$iv$iv);
                boolean bl = match$iv$iv = it <= ' ';
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            string = ((Object)$receiver$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        } else {
            string = null;
        }
        return string;
    }

    @NotNull
    public final LintClient getClient() {
        return this.client;
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    @NotNull
    public final File getRoot() {
        return this.root;
    }

    public final void setRoot(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"<set-?>");
        this.root = file;
    }

    public ProjectInitializer(@NotNull LintClient client, @NotNull File file, @NotNull File root) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        this.client = client;
        this.file = file;
        this.root = root;
        ProjectInitializer projectInitializer = this;
        Object object = new LinkedHashMap();
        projectInitializer.modules = object;
        projectInitializer = this;
        projectInitializer.globalClasspath = object = (List)new ArrayList();
        ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)arrayListMultimap, (String)"ArrayListMultimap.create()");
        this.dependencies = (Multimap)arrayListMultimap;
        projectInitializer = this;
        projectInitializer.mergedManifests = object = (Map)new LinkedHashMap();
        projectInitializer = this;
        projectInitializer.lintChecks = object = (Map)new LinkedHashMap();
        projectInitializer = this;
        projectInitializer.baselines = object = (Map)new LinkedHashMap();
        projectInitializer = this;
        projectInitializer.jarAarMap = object = (Map)new LinkedHashMap();
        projectInitializer = this;
        projectInitializer.visibility = object = (Map)new LinkedHashMap();
    }
}

