/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.SdkConstants;
import com.android.tools.lint.HtmlReporter;
import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.LintCliFlags;
import com.android.tools.lint.LintStats;
import com.android.tools.lint.MultiProjectHtmlReporter;
import com.android.tools.lint.TextReporter;
import com.android.tools.lint.Warning;
import com.android.tools.lint.XmlReporter;
import com.android.tools.lint.checks.AccessibilityDetector;
import com.android.tools.lint.checks.AlwaysShowActionDetector;
import com.android.tools.lint.checks.AndroidAutoDetector;
import com.android.tools.lint.checks.AndroidTvDetector;
import com.android.tools.lint.checks.AnnotationDetector;
import com.android.tools.lint.checks.ApiDetector;
import com.android.tools.lint.checks.AppCompatCallDetector;
import com.android.tools.lint.checks.AppCompatCustomViewDetector;
import com.android.tools.lint.checks.AppCompatResourceDetector;
import com.android.tools.lint.checks.AppIndexingApiDetector;
import com.android.tools.lint.checks.AppLinksValidDetector;
import com.android.tools.lint.checks.ByteOrderMarkDetector;
import com.android.tools.lint.checks.CheckResultDetector;
import com.android.tools.lint.checks.ChromeOsDetector;
import com.android.tools.lint.checks.CleanupDetector;
import com.android.tools.lint.checks.CommentDetector;
import com.android.tools.lint.checks.DetectMissingPrefix;
import com.android.tools.lint.checks.DuplicateResourceDetector;
import com.android.tools.lint.checks.EllipsizeMaxLinesDetector;
import com.android.tools.lint.checks.FontDetector;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.checks.GridLayoutDetector;
import com.android.tools.lint.checks.IconDetector;
import com.android.tools.lint.checks.IncludeDetector;
import com.android.tools.lint.checks.InefficientWeightDetector;
import com.android.tools.lint.checks.JavaPerformanceDetector;
import com.android.tools.lint.checks.KeyboardNavigationDetector;
import com.android.tools.lint.checks.LabelForDetector;
import com.android.tools.lint.checks.ManifestDetector;
import com.android.tools.lint.checks.MissingClassDetector;
import com.android.tools.lint.checks.MissingIdDetector;
import com.android.tools.lint.checks.NamespaceDetector;
import com.android.tools.lint.checks.NetworkSecurityConfigDetector;
import com.android.tools.lint.checks.ObjectAnimatorDetector;
import com.android.tools.lint.checks.ObsoleteLayoutParamsDetector;
import com.android.tools.lint.checks.ParcelDetector;
import com.android.tools.lint.checks.PermissionDetector;
import com.android.tools.lint.checks.PropertyFileDetector;
import com.android.tools.lint.checks.PxUsageDetector;
import com.android.tools.lint.checks.ReadParcelableDetector;
import com.android.tools.lint.checks.RtlDetector;
import com.android.tools.lint.checks.ScrollViewChildDetector;
import com.android.tools.lint.checks.SecurityDetector;
import com.android.tools.lint.checks.ServiceCastDetector;
import com.android.tools.lint.checks.SignatureOrSystemDetector;
import com.android.tools.lint.checks.TextFieldDetector;
import com.android.tools.lint.checks.TextViewDetector;
import com.android.tools.lint.checks.TitleDetector;
import com.android.tools.lint.checks.TypoDetector;
import com.android.tools.lint.checks.TypographyDetector;
import com.android.tools.lint.checks.UnpackedNativeCodeDetector;
import com.android.tools.lint.checks.UnsafeBroadcastReceiverDetector;
import com.android.tools.lint.checks.UnusedResourceDetector;
import com.android.tools.lint.checks.UselessViewDetector;
import com.android.tools.lint.checks.Utf8Detector;
import com.android.tools.lint.checks.VectorPathDetector;
import com.android.tools.lint.checks.ViewTypeDetector;
import com.android.tools.lint.checks.WakelockDetector;
import com.android.tools.lint.checks.WearStandaloneAppDetector;
import com.android.tools.lint.checks.WrongCallDetector;
import com.android.tools.lint.checks.WrongCaseDetector;
import com.android.tools.lint.detector.api.Issue;
import com.android.utils.SdkUtils;
import com.google.common.annotations.Beta;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

@Beta
public abstract class Reporter {
    public static final String STDOUT = "stdout";
    public static final String STDERR = "stderr";
    protected final LintCliClient client;
    protected final File output;
    protected String title = "Lint Report";
    protected Map<String, String> urlMap;
    protected boolean displayEmpty = true;
    private static Set<Issue> studioFixes;
    private String stripPrefix;

    public static Reporter createHtmlReporter(LintCliClient client, File output, LintCliFlags flags) throws IOException {
        return new HtmlReporter(client, output, flags);
    }

    public static TextReporter createTextReporter(LintCliClient client, LintCliFlags flags, File file, Writer writer, boolean close) {
        return new TextReporter(client, flags, file, writer, close);
    }

    public static XmlReporter createXmlReporter(LintCliClient client, File output, boolean intendedForBaseline) throws IOException {
        XmlReporter reporter = new XmlReporter(client, output);
        reporter.setIntendedForBaseline(intendedForBaseline);
        return reporter;
    }

    public abstract void write(LintStats var1, List<Warning> var2) throws IOException;

    public void writeProjectList(LintStats stats, List<MultiProjectHtmlReporter.ProjectEntry> projects) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected Reporter(LintCliClient client, File output) {
        this.client = client;
        this.output = output;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public File getOutput() {
        return this.output;
    }

    String getUrl(File file) {
        String relativePath;
        if (this.urlMap != null) {
            String path = file.getAbsolutePath();
            String pathUrl = Reporter.encodeUrl(path);
            for (Map.Entry<String, String> entry : this.urlMap.entrySet()) {
                String prefix = entry.getKey();
                String prefixUrl = Reporter.encodeUrl(prefix);
                if (!pathUrl.startsWith(prefixUrl)) continue;
                String relative = pathUrl.substring(prefixUrl.length());
                return entry.getValue() + relative;
            }
        }
        if (file.isAbsolute() && (relativePath = Reporter.getRelativePath(this.output.getParentFile(), file)) != null) {
            relativePath = relativePath.replace(File.separatorChar, '/');
            return Reporter.encodeUrl(relativePath);
        }
        try {
            return SdkUtils.fileToUrlString((File)file);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    static String encodeUrl(String url) {
        try {
            url = url.replace('\\', '/');
            return URLEncoder.encode(url, "UTF-8").replace("%2F", "/");
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("Invalid string " + e.getLocalizedMessage());
            return url;
        }
    }

    public void setUrlMap(Map<String, String> urlMap) {
        this.urlMap = urlMap;
    }

    static String getRelativePath(File base, File file) {
        int len;
        String filePathToCompare;
        if (base == null || file == null) {
            return null;
        }
        if (!base.isDirectory() && (base = base.getParentFile()) == null) {
            return null;
        }
        if (base.equals(file)) {
            return ".";
        }
        String filePath = file.getAbsolutePath();
        String basePath = base.getAbsolutePath();
        basePath = !basePath.isEmpty() && basePath.charAt(basePath.length() - 1) == File.separatorChar ? basePath : basePath + File.separatorChar;
        boolean caseSensitive = SdkConstants.CURRENT_PLATFORM == 1;
        Locale l = Locale.getDefault();
        String basePathToCompare = caseSensitive ? basePath : basePath.toLowerCase(l);
        if (basePathToCompare.equals(!(filePathToCompare = caseSensitive ? filePath : filePath.toLowerCase(l)).isEmpty() && filePathToCompare.charAt(filePathToCompare.length() - 1) == File.separatorChar ? filePathToCompare : filePathToCompare + File.separatorChar)) {
            return ".";
        }
        int lastSeparatorIndex = 0;
        for (len = 0; len < filePath.length() && len < basePath.length() && filePathToCompare.charAt(len) == basePathToCompare.charAt(len); ++len) {
            if (basePath.charAt(len) != File.separatorChar) continue;
            lastSeparatorIndex = len;
        }
        if (len == 0) {
            return null;
        }
        StringBuilder relativePath = new StringBuilder();
        for (int i = len; i < basePath.length(); ++i) {
            if (basePath.charAt(i) != File.separatorChar) continue;
            relativePath.append("..");
            relativePath.append(File.separatorChar);
        }
        relativePath.append(filePath.substring(lastSeparatorIndex + 1));
        return relativePath.toString();
    }

    public boolean isDisplayEmpty() {
        return this.displayEmpty;
    }

    public void setDisplayEmpty(boolean displayEmpty) {
        this.displayEmpty = displayEmpty;
    }

    public static boolean hasAutoFix(Issue issue) {
        if (studioFixes == null) {
            studioFixes = Sets.newHashSet((Object[])new Issue[]{AccessibilityDetector.ISSUE, AlwaysShowActionDetector.ISSUE, AndroidAutoDetector.INVALID_USES_TAG_ISSUE, AndroidTvDetector.MISSING_BANNER, AndroidTvDetector.MISSING_LEANBACK_SUPPORT, AndroidTvDetector.PERMISSION_IMPLIES_UNSUPPORTED_HARDWARE, AndroidTvDetector.UNSUPPORTED_TV_HARDWARE, AnnotationDetector.FLAG_STYLE, AnnotationDetector.SWITCH_TYPE_DEF, ApiDetector.INLINED, ApiDetector.OBSOLETE_SDK, ApiDetector.OVERRIDE, ApiDetector.UNSUPPORTED, ApiDetector.UNUSED, AppCompatCallDetector.ISSUE, AppCompatCustomViewDetector.ISSUE, AppCompatResourceDetector.ISSUE, AppIndexingApiDetector.ISSUE_APP_INDEXING, AppIndexingApiDetector.ISSUE_APP_INDEXING_API, AppLinksValidDetector.VALIDATION, ByteOrderMarkDetector.BOM, CheckResultDetector.CHECK_RESULT, ChromeOsDetector.PERMISSION_IMPLIES_UNSUPPORTED_HARDWARE, ChromeOsDetector.UNSUPPORTED_CHROME_OS_HARDWARE, CleanupDetector.APPLY_SHARED_PREF, CleanupDetector.SHARED_PREF, CommentDetector.STOP_SHIP, DetectMissingPrefix.MISSING_NAMESPACE, DuplicateResourceDetector.STRING_ESCAPING, DuplicateResourceDetector.TYPE_MISMATCH, EllipsizeMaxLinesDetector.ISSUE, FontDetector.FONT_VALIDATION_ERROR, FontDetector.FONT_VALIDATION_WARNING, GradleDetector.COMPATIBILITY, GradleDetector.DEPENDENCY, GradleDetector.DEPRECATED, GradleDetector.DUPLICATE_CLASSES, GradleDetector.MIN_SDK_TOO_LOW, GradleDetector.NOT_INTERPOLATED, GradleDetector.PLUS, GradleDetector.REMOTE_VERSION, GradleDetector.STRING_INTEGER, GridLayoutDetector.ISSUE, IconDetector.WEBP_ELIGIBLE, IconDetector.WEBP_UNSUPPORTED, IncludeDetector.ISSUE, InefficientWeightDetector.BASELINE_WEIGHTS, InefficientWeightDetector.INEFFICIENT_WEIGHT, InefficientWeightDetector.ORIENTATION, JavaPerformanceDetector.USE_VALUE_OF, KeyboardNavigationDetector.ISSUE, LabelForDetector.ISSUE, ManifestDetector.ALLOW_BACKUP, ManifestDetector.APPLICATION_ICON, ManifestDetector.MIPMAP, ManifestDetector.MOCK_LOCATION, ManifestDetector.SET_VERSION, ManifestDetector.TARGET_NEWER, MissingClassDetector.INNERCLASS, MissingIdDetector.ISSUE, NamespaceDetector.RES_AUTO, NetworkSecurityConfigDetector.ISSUE, ObjectAnimatorDetector.MISSING_KEEP, ObsoleteLayoutParamsDetector.ISSUE, ParcelDetector.ISSUE, PermissionDetector.CHECK_PERMISSION, PermissionDetector.MISSING_PERMISSION, PropertyFileDetector.ESCAPE, PropertyFileDetector.HTTP, PxUsageDetector.DP_ISSUE, PxUsageDetector.PX_ISSUE, ReadParcelableDetector.ISSUE, RtlDetector.COMPAT, RtlDetector.USE_START, ScrollViewChildDetector.ISSUE, SecurityDetector.EXPORTED_PROVIDER, SecurityDetector.EXPORTED_RECEIVER, SecurityDetector.EXPORTED_SERVICE, ServiceCastDetector.WIFI_MANAGER, ServiceCastDetector.WIFI_MANAGER_UNCERTAIN, SignatureOrSystemDetector.ISSUE, TextFieldDetector.ISSUE, TextViewDetector.SELECTABLE, TitleDetector.ISSUE, TypoDetector.ISSUE, TypographyDetector.DASHES, TypographyDetector.ELLIPSIS, TypographyDetector.FRACTIONS, TypographyDetector.OTHER, TypographyDetector.QUOTES, UnpackedNativeCodeDetector.ISSUE, UnsafeBroadcastReceiverDetector.BROADCAST_SMS, UnusedResourceDetector.ISSUE, UnusedResourceDetector.ISSUE_IDS, UselessViewDetector.USELESS_LEAF, Utf8Detector.ISSUE, VectorPathDetector.PATH_VALID, ViewTypeDetector.ADD_CAST, WakelockDetector.TIMEOUT, WearStandaloneAppDetector.WEAR_STANDALONE_APP_ISSUE, WrongCallDetector.ISSUE, WrongCaseDetector.WRONG_CASE});
        }
        return studioFixes.contains(issue);
    }

    protected String stripPath(String path) {
        if (this.stripPrefix != null && path.startsWith(this.stripPrefix) && path.length() > this.stripPrefix.length()) {
            int index = this.stripPrefix.length();
            if (path.charAt(index) == File.separatorChar) {
                ++index;
            }
            return path.substring(index);
        }
        return path;
    }

    public void setStripPrefix(String prefix) {
        this.stripPrefix = prefix;
    }
}

