/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.LintCliFlags;
import com.android.tools.lint.LintStats;
import com.android.tools.lint.Reporter;
import com.android.tools.lint.Warning;
import com.android.tools.lint.checks.BuiltinIssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.google.common.annotations.Beta;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0013H\u0003J\u0016\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\tJ\u0018\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\tJ\u001e\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0017J(\u0010 \u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\tH\u0003J\u0010\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u001fH\u0002J\u0016\u0010#\u001a\u00020\u00122\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002R\u001c\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/android/tools/lint/XmlReporter;", "Lcom/android/tools/lint/Reporter;", "client", "Lcom/android/tools/lint/LintCliClient;", "output", "Ljava/io/File;", "(Lcom/android/tools/lint/LintCliClient;Ljava/io/File;)V", "attributes", "", "", "isIntendedForBaseline", "", "()Z", "setIntendedForBaseline", "(Z)V", "writer", "Ljava/io/Writer;", "indent", "", "", "setAttribute", "name", "value", "setBaselineAttributes", "Lcom/android/tools/lint/client/api/LintClient;", "variant", "write", "stats", "Lcom/android/tools/lint/LintStats;", "issues", "", "Lcom/android/tools/lint/Warning;", "writeAttribute", "writeIssue", "warning", "writeIssues", "lint"})
@Beta
public final class XmlReporter
extends Reporter {
    private final Writer writer;
    private boolean isIntendedForBaseline;
    private Map<String, String> attributes;

    public final boolean isIntendedForBaseline() {
        return this.isIntendedForBaseline;
    }

    public final void setIntendedForBaseline(boolean bl) {
        this.isIntendedForBaseline = bl;
    }

    public final void setAttribute(@NotNull String name, @NotNull String value) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Map map = this.attributes;
        if (map == null) {
            Map newMap;
            object = this;
            XmlReporter $receiver = (XmlReporter)object;
            $receiver.attributes = newMap = (Map)new LinkedHashMap();
            map = newMap;
        }
        Map attributes = map;
        object = attributes;
        String string = value;
        object.put(name, string);
    }

    public final void setBaselineAttributes(@NotNull LintClient client, @Nullable String variant) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        this.setAttribute("client", LintClient.Companion.getClientName());
        String revision = client.getClientRevision();
        if (revision != null) {
            this.setAttribute("version", revision);
        }
        if (variant != null) {
            this.setAttribute("variant", variant);
        }
    }

    public void write(@NotNull LintStats stats, @NotNull List<? extends Warning> issues) throws IOException {
        Object object;
        String string;
        Object object2;
        Intrinsics.checkParameterIsNotNull((Object)stats, (String)"stats");
        Intrinsics.checkParameterIsNotNull(issues, (String)"issues");
        this.writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.writer.write("<issues format=\"4\"");
        String revision = this.client.getClientRevision();
        if (revision != null) {
            object2 = StringCompanionObject.INSTANCE;
            string = " by=\"lint %1$s\"";
            object = new Object[]{revision};
            Writer writer = this.writer;
            String string2 = String.format(string, Arrays.copyOf(object, ((Object[])object).length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            String string3 = string2;
            writer.write(string3);
        }
        Map<String, String> map = this.attributes;
        if (map != null) {
            Object it = object2 = map;
            Sequence $receiver$iv = MapsKt.asSequence((Map)it);
            $receiver$iv = SequencesKt.sortedWith((Sequence)$receiver$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    Map.Entry it = (Map.Entry)a;
                    Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                    it = (Map.Entry)b;
                    Comparable comparable2 = comparable;
                    String string = (String)it.getKey();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                }
            });
            for (Object element$iv : $receiver$iv) {
                Map.Entry it2 = (Map.Entry)element$iv;
                this.writer.write(' ' + (String)it2.getKey() + "=\"" + XmlUtils.toXmlAttributeValue((String)((String)it2.getValue())) + '\"');
            }
        }
        this.writer.write(">\n");
        if (!issues.isEmpty()) {
            this.writeIssues(issues);
        }
        this.writer.write("\n</issues>\n");
        this.writer.close();
        LintCliFlags lintCliFlags = this.client.getFlags();
        Intrinsics.checkExpressionValueIsNotNull((Object)lintCliFlags, (String)"client.getFlags()");
        if (!(lintCliFlags.isQuiet() || stats.getErrorCount() <= 0 && stats.getWarningCount() <= 0)) {
            File file = this.output;
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"output");
            String url = SdkUtils.fileToUrlString((File)file.getAbsoluteFile());
            string = StringCompanionObject.INSTANCE;
            object = "Wrote XML report to %1$s";
            Object[] objectArray = new Object[]{url};
            String string4 = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"java.lang.String.format(format, *args)");
            string = string4;
            System.out.println((Object)string);
        }
    }

    private final void writeIssues(List<? extends Warning> issues) {
        for (Warning warning : issues) {
            this.writeIssue(warning);
        }
    }

    private final void writeIssue(Warning warning) {
        Location location;
        boolean line2;
        Object moreInfo;
        this.writer.write(10);
        this.indent(this.writer, 1);
        this.writer.write("<issue");
        Issue issue = warning.issue;
        this.writeAttribute(this.writer, 2, "id", issue.getId());
        if (!this.isIntendedForBaseline) {
            this.writeAttribute(this.writer, 2, "severity", warning.severity.getDescription());
        }
        String string = warning.message;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"warning.message");
        this.writeAttribute(this.writer, 2, "message", string);
        if (!this.isIntendedForBaseline) {
            this.writeAttribute(this.writer, 2, "category", issue.getCategory().getFullName());
            String string2 = Integer.toString(issue.getPriority());
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Integer.toString(issue.priority)");
            this.writeAttribute(this.writer, 2, "priority", string2);
            this.writeAttribute(this.writer, 2, "summary", issue.getBriefDescription(TextFormat.RAW));
            this.writeAttribute(this.writer, 2, "explanation", issue.getExplanation(TextFormat.RAW));
            moreInfo = issue.getMoreInfo();
            if (!moreInfo.isEmpty()) {
                this.writeAttribute(this.writer, 2, "url", (String)moreInfo.get(0));
                String string3 = Joiner.on((char)',').join((Iterable)issue.getMoreInfo());
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"Joiner.on(',').join(issue.moreInfo)");
                this.writeAttribute(this.writer, 2, "urls", string3);
            }
        }
        if (warning.errorLine != null) {
            String string4 = warning.errorLine;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"warning.errorLine");
            moreInfo = string4;
            if (!(moreInfo.length() == 0)) {
                int index2;
                String line2;
                String string5 = line2 = warning.errorLine;
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"line");
                int index1 = StringsKt.indexOf$default((CharSequence)string5, (char)'\n', (int)0, (boolean)false, (int)6, null);
                if (index1 != -1 && (index2 = StringsKt.indexOf$default((CharSequence)line2, (char)'\n', (int)(index1 + 1), (boolean)false, (int)4, null)) != -1) {
                    String string6 = line2;
                    int n = 0;
                    String string7 = string6.substring(n, index1);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    String line1 = string7;
                    String string8 = line2;
                    int n2 = index1 + 1;
                    String string9 = string8.substring(n2, index2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    String line22 = string9;
                    this.writeAttribute(this.writer, 2, "errorLine1", line1);
                    this.writeAttribute(this.writer, 2, "errorLine2", line22);
                }
            }
        }
        if (warning.isVariantSpecific()) {
            String string10 = Joiner.on((char)',').join((Iterable)warning.getIncludedVariantNames());
            Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"Joiner.on(',').join(warning.includedVariantNames)");
            this.writeAttribute(this.writer, 2, "includedVariants", string10);
            String string11 = Joiner.on((char)',').join((Iterable)warning.getExcludedVariantNames());
            Intrinsics.checkExpressionValueIsNotNull((Object)string11, (String)"Joiner.on(',').join(warning.excludedVariantNames)");
            this.writeAttribute(this.writer, 2, "excludedVariants", string11);
        }
        if (!this.isIntendedForBaseline && this.client.getRegistry() instanceof BuiltinIssueRegistry && Reporter.hasAutoFix(issue)) {
            this.writeAttribute(this.writer, 2, "quickfix", "studio");
        }
        boolean bl = line2 = warning.file != null == (warning.location != null);
        if (_Assertions.ENABLED && !line2) {
            String index1 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)index1));
        }
        if (warning.file != null) {
            boolean bl2 = line2 = warning.location.getFile() == warning.file;
            if (_Assertions.ENABLED && !line2) {
                String index1 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)index1));
            }
        }
        if ((location = warning.location) != null) {
            this.writer.write(">\n");
            while (location != null) {
                String path;
                this.indent(this.writer, 2);
                this.writer.write("<location");
                Project project = warning.project;
                File file = location.getFile();
                LintCliFlags lintCliFlags = this.client.flags;
                Intrinsics.checkExpressionValueIsNotNull((Object)lintCliFlags, (String)"client.flags");
                String string12 = path = LintCliClient.getDisplayPath(project, file, lintCliFlags.isFullPath() && !this.isIntendedForBaseline);
                Intrinsics.checkExpressionValueIsNotNull((Object)string12, (String)"path");
                this.writeAttribute(this.writer, 3, "file", string12);
                Position start = location.getStart();
                if (start != null) {
                    int line3 = start.getLine();
                    int column = start.getColumn();
                    if (line3 >= 0) {
                        String string13 = Integer.toString(line3 + 1);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string13, (String)"Integer.toString(line + 1)");
                        this.writeAttribute(this.writer, 3, "line", string13);
                        if (column >= 0) {
                            String string14 = Integer.toString(column + 1);
                            Intrinsics.checkExpressionValueIsNotNull((Object)string14, (String)"Integer.toString(column + 1)");
                            this.writeAttribute(this.writer, 3, "column", string14);
                        }
                    }
                }
                this.writer.write("/>\n");
                location = location.getSecondary();
            }
            this.indent(this.writer, 1);
            this.writer.write("</issue>\n");
        } else {
            this.writer.write(10);
            this.indent(this.writer, 1);
            this.writer.write("/>\n");
        }
    }

    private final void writeAttribute(Writer writer, int indent, String name, String value) throws IOException {
        writer.write(10);
        this.indent(writer, indent);
        writer.write(name);
        writer.write(61);
        writer.write(34);
        writer.write(XmlUtils.toXmlAttributeValue((String)value));
        writer.write(34);
    }

    /*
     * WARNING - void declaration
     */
    private final void indent(Writer writer, int indent) throws IOException {
        int n = 0;
        int n2 = indent;
        while (n < n2) {
            void level;
            writer.write("    ");
            ++level;
        }
    }

    public XmlReporter(@NotNull LintCliClient client, @NotNull File output) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)((Object)client), (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        super(client, output);
        this.writer = new BufferedWriter(Files.newWriter((File)output, (Charset)Charsets.UTF_8));
    }
}

