/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.config;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.SmartList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.AnalysisFlag;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.config.SourceMapSourceEmbedding;
import org.jetbrains.kotlin.js.resolve.JsPlatform;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.CompilerDeserializationConfiguration;
import org.jetbrains.kotlin.serialization.js.JsModuleDescriptor;
import org.jetbrains.kotlin.serialization.js.KotlinJavaScriptLibraryParts;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializationUtil;
import org.jetbrains.kotlin.serialization.js.ModuleKind;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.utils.JsMetadataVersion;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadata;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadataUtils;
import org.jetbrains.kotlin.utils.PathUtil;

public class JsConfig {
    public static final List<String> JS_STDLIB = Collections.singletonList(PathUtil.getKotlinPathsForDistDirectory().getJsStdLibJarPath().getAbsolutePath());
    public static final List<String> JS_KOTLIN_TEST = Collections.singletonList(PathUtil.getKotlinPathsForDistDirectory().getJsKotlinTestJarPath().getAbsolutePath());
    public static final String UNKNOWN_EXTERNAL_MODULE_NAME = "<unknown>";
    private final Project project;
    private final CompilerConfiguration configuration;
    private final LockBasedStorageManager storageManager = new LockBasedStorageManager();
    private final List<KotlinJavascriptMetadata> metadata = new SmartList<KotlinJavascriptMetadata>();
    private final List<KotlinJavascriptMetadata> friends = new SmartList<KotlinJavascriptMetadata>();
    @Nullable
    private List<JsModuleDescriptor<ModuleDescriptorImpl>> moduleDescriptors = null;
    @Nullable
    private List<JsModuleDescriptor<ModuleDescriptorImpl>> friendModuleDescriptors = null;
    private boolean initialized = false;
    @Nullable
    private final List<JsModuleDescriptor<KotlinJavaScriptLibraryParts>> metadataCache;
    @Nullable
    private final Set<String> librariesToSkip;
    private final IdentityHashMap<KotlinJavascriptMetadata, JsModuleDescriptor<ModuleDescriptorImpl>> factoryMap = new IdentityHashMap();

    public JsConfig(@NotNull Project project, @NotNull CompilerConfiguration configuration) {
        this(project, configuration, null, null);
    }

    public JsConfig(@NotNull Project project, @NotNull CompilerConfiguration configuration, @Nullable List<JsModuleDescriptor<KotlinJavaScriptLibraryParts>> metadataCache, @Nullable Set<String> librariesToSkip) {
        this.project = project;
        this.configuration = configuration;
        this.metadataCache = metadataCache;
        this.librariesToSkip = librariesToSkip;
    }

    @NotNull
    public CompilerConfiguration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public Project getProject() {
        return this.project;
    }

    @NotNull
    public String getModuleId() {
        return this.configuration.getNotNull(CommonConfigurationKeys.MODULE_NAME);
    }

    @NotNull
    public ModuleKind getModuleKind() {
        return this.configuration.get(JSConfigurationKeys.MODULE_KIND, ModuleKind.PLAIN);
    }

    @NotNull
    public List<String> getLibraries() {
        return this.getConfiguration().getList(JSConfigurationKeys.LIBRARIES);
    }

    @NotNull
    public String getSourceMapPrefix() {
        return this.configuration.get(JSConfigurationKeys.SOURCE_MAP_PREFIX, "");
    }

    @NotNull
    public List<String> getSourceMapRoots() {
        return this.configuration.get(JSConfigurationKeys.SOURCE_MAP_SOURCE_ROOTS, Collections.emptyList());
    }

    public boolean shouldGenerateRelativePathsInSourceMap() {
        return this.getSourceMapPrefix().isEmpty() && this.getSourceMapRoots().isEmpty();
    }

    @NotNull
    public SourceMapSourceEmbedding getSourceMapContentEmbedding() {
        return this.configuration.get(JSConfigurationKeys.SOURCE_MAP_EMBED_SOURCES, SourceMapSourceEmbedding.INLINING);
    }

    @NotNull
    public List<String> getFriends() {
        if (this.getConfiguration().getBoolean(JSConfigurationKeys.FRIEND_PATHS_DISABLED)) {
            return Collections.emptyList();
        }
        return this.getConfiguration().getList(JSConfigurationKeys.FRIEND_PATHS);
    }

    public boolean isAtLeast(@NotNull LanguageVersion expected) {
        LanguageVersion actual = CommonConfigurationKeysKt.getLanguageVersionSettings(this.configuration).getLanguageVersion();
        return actual.getMajor() > expected.getMajor() || actual.getMajor() == expected.getMajor() && actual.getMinor() >= expected.getMinor();
    }

    public boolean checkLibFilesAndReportErrors(@NotNull Reporter report2) {
        return this.checkLibFilesAndReportErrors(this.getLibraries(), report2, null);
    }

    private boolean checkLibFilesAndReportErrors(@NotNull Collection<String> libraries, @NotNull Reporter report2, @Nullable Function1<List<KotlinJavascriptMetadata>, Unit> action) {
        if (libraries.isEmpty()) {
            return false;
        }
        VirtualFileSystem fileSystem = VirtualFileManager.getInstance().getFileSystem("file");
        VirtualFileSystem jarFileSystem = VirtualFileManager.getInstance().getFileSystem("jar");
        HashSet<String> modules = new HashSet<String>();
        boolean skipMetadataVersionCheck = CommonConfigurationKeysKt.getLanguageVersionSettings(this.configuration).getFlag(AnalysisFlag.getSkipMetadataVersionCheck());
        for (String path2 : libraries) {
            if (this.librariesToSkip != null && this.librariesToSkip.contains(path2)) continue;
            File filePath = new File(path2);
            if (!filePath.exists()) {
                report2.error("Path '" + path2 + "' does not exist");
                return true;
            }
            VirtualFile file2 = path2.endsWith(".jar") || path2.endsWith(".zip") ? jarFileSystem.findFileByPath(path2 + "!/") : fileSystem.findFileByPath(path2);
            if (file2 == null) {
                report2.error("File '" + path2 + "' does not exist or could not be read");
                return true;
            }
            List<KotlinJavascriptMetadata> metadataList = KotlinJavascriptMetadataUtils.loadMetadata(path2);
            if (metadataList.isEmpty()) {
                report2.warning("'" + path2 + "' is not a valid Kotlin Javascript library");
                continue;
            }
            for (KotlinJavascriptMetadata metadata2 : metadataList) {
                if (!metadata2.getVersion().isCompatible() && !skipMetadataVersionCheck) {
                    report2.error("File '" + path2 + "' was compiled with an incompatible version of Kotlin. The binary version of its metadata is " + metadata2.getVersion() + ", expected version is " + JsMetadataVersion.INSTANCE);
                    return true;
                }
                if (modules.add(metadata2.getModuleName())) continue;
                report2.warning("Module \"" + metadata2.getModuleName() + "\" is defined in more than one file");
            }
            if (action == null) continue;
            action.invoke(metadataList);
        }
        return false;
    }

    @NotNull
    public List<JsModuleDescriptor<ModuleDescriptorImpl>> getModuleDescriptors() {
        this.init();
        if (this.moduleDescriptors != null) {
            return this.moduleDescriptors;
        }
        this.moduleDescriptors = new SmartList<JsModuleDescriptor<ModuleDescriptorImpl>>();
        ArrayList<ModuleDescriptorImpl> kotlinModuleDescriptors = new ArrayList<ModuleDescriptorImpl>();
        for (KotlinJavascriptMetadata kotlinJavascriptMetadata : this.metadata) {
            JsModuleDescriptor<ModuleDescriptorImpl> jsModuleDescriptor = this.createModuleDescriptor(kotlinJavascriptMetadata);
            this.moduleDescriptors.add(jsModuleDescriptor);
            kotlinModuleDescriptors.add(jsModuleDescriptor.getData());
        }
        if (this.metadataCache != null) {
            LanguageVersionSettings languageVersionSettings = CommonConfigurationKeysKt.getLanguageVersionSettings(this.configuration);
            for (JsModuleDescriptor<KotlinJavaScriptLibraryParts> jsModuleDescriptor : this.metadataCache) {
                ModuleDescriptorImpl moduleDescriptor;
                JsModuleDescriptor<PackageFragmentProvider> rawDescriptor = KotlinJavascriptSerializationUtil.readModuleFromProto(jsModuleDescriptor, this.storageManager, moduleDescriptor = new ModuleDescriptorImpl(Name.special("<" + jsModuleDescriptor.getName() + ">"), this.storageManager, JsPlatform.INSTANCE.getBuiltIns()), new CompilerDeserializationConfiguration(languageVersionSettings), LookupTracker.DO_NOTHING.INSTANCE);
                PackageFragmentProvider provider = rawDescriptor.getData();
                moduleDescriptor.initialize(provider != null ? provider : PackageFragmentProvider.Empty.INSTANCE);
                JsModuleDescriptor<ModuleDescriptorImpl> jsModuleDescriptor2 = jsModuleDescriptor.copy(moduleDescriptor);
                this.moduleDescriptors.add(jsModuleDescriptor2);
                kotlinModuleDescriptors.add(jsModuleDescriptor2.getData());
            }
        }
        for (JsModuleDescriptor jsModuleDescriptor : this.moduleDescriptors) {
            JsConfig.setDependencies((ModuleDescriptorImpl)jsModuleDescriptor.getData(), kotlinModuleDescriptors);
        }
        this.moduleDescriptors = Collections.unmodifiableList(this.moduleDescriptors);
        return this.moduleDescriptors;
    }

    @NotNull
    public List<JsModuleDescriptor<ModuleDescriptorImpl>> getFriendModuleDescriptors() {
        this.init();
        if (this.friendModuleDescriptors != null) {
            return this.friendModuleDescriptors;
        }
        this.friendModuleDescriptors = new SmartList<JsModuleDescriptor<ModuleDescriptorImpl>>();
        for (KotlinJavascriptMetadata metadataEntry : this.friends) {
            JsModuleDescriptor<ModuleDescriptorImpl> descriptor2 = this.createModuleDescriptor(metadataEntry);
            this.friendModuleDescriptors.add(descriptor2);
        }
        this.friendModuleDescriptors = Collections.unmodifiableList(this.friendModuleDescriptors);
        return this.friendModuleDescriptors;
    }

    private void init() {
        if (this.initialized) {
            return;
        }
        if (!this.getLibraries().isEmpty()) {
            Reporter reporter = new Reporter(){

                @Override
                public void error(@NotNull String message) {
                    throw new IllegalStateException(message);
                }
            };
            boolean hasErrors = this.checkLibFilesAndReportErrors(this.getFriends(), reporter, (Function1<List<KotlinJavascriptMetadata>, Unit>)((Function1)metaList -> {
                this.metadata.addAll((Collection<KotlinJavascriptMetadata>)metaList);
                this.friends.addAll((Collection<KotlinJavascriptMetadata>)metaList);
                return Unit.INSTANCE;
            }));
            assert (!(hasErrors |= this.checkLibFilesAndReportErrors(CollectionsKt.subtract(this.getLibraries(), this.getFriends()), reporter, (Function1<List<KotlinJavascriptMetadata>, Unit>)((Function1)metaList -> {
                this.metadata.addAll((Collection<KotlinJavascriptMetadata>)metaList);
                return Unit.INSTANCE;
            })))) : "hasErrors should be false";
        }
        this.initialized = true;
    }

    private JsModuleDescriptor<ModuleDescriptorImpl> createModuleDescriptor(KotlinJavascriptMetadata metadata2) {
        return this.factoryMap.computeIfAbsent(metadata2, m -> {
            LanguageVersionSettings languageVersionSettings = CommonConfigurationKeysKt.getLanguageVersionSettings(this.configuration);
            assert (m.getVersion().isCompatible() || languageVersionSettings.getFlag(AnalysisFlag.getSkipMetadataVersionCheck()).booleanValue()) : "Expected JS metadata version " + JsMetadataVersion.INSTANCE + ", but actual metadata version is " + m.getVersion();
            ModuleDescriptorImpl moduleDescriptor = new ModuleDescriptorImpl(Name.special("<" + m.getModuleName() + ">"), this.storageManager, JsPlatform.INSTANCE.getBuiltIns());
            LookupTracker lookupTracker = this.configuration.get(CommonConfigurationKeys.LOOKUP_TRACKER, LookupTracker.DO_NOTHING.INSTANCE);
            JsModuleDescriptor<PackageFragmentProvider> rawDescriptor = KotlinJavascriptSerializationUtil.readModule(m.getBody(), this.storageManager, moduleDescriptor, new CompilerDeserializationConfiguration(languageVersionSettings), lookupTracker);
            PackageFragmentProvider provider = rawDescriptor.getData();
            moduleDescriptor.initialize(provider != null ? provider : PackageFragmentProvider.Empty.INSTANCE);
            return rawDescriptor.copy(moduleDescriptor);
        });
    }

    private static void setDependencies(ModuleDescriptorImpl module2, List<ModuleDescriptorImpl> modules) {
        module2.setDependencies(CollectionsKt.plus(modules, (Object)JsPlatform.INSTANCE.getBuiltIns().getBuiltInsModule()));
    }

    public static abstract class Reporter {
        public void error(@NotNull String message) {
        }

        public void warning(@NotNull String message) {
        }
    }
}

