/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.diagnostics;

import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.FilteringIterator;
import java.util.Collection;
import java.util.Iterator;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.diagnostics.BindingContextSuppressCache;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.resolve.diagnostics.DiagnosticsElementsCache;
import org.jetbrains.kotlin.resolve.diagnostics.KotlinSuppressCache;
import org.jetbrains.kotlin.resolve.diagnostics.SimpleDiagnostics;

public class DiagnosticsWithSuppression
implements Diagnostics {
    private final KotlinSuppressCache kotlinSuppressCache;
    private final Collection<Diagnostic> diagnostics;
    private final DiagnosticsElementsCache elementsCache;

    public DiagnosticsWithSuppression(@NotNull BindingContext context, @NotNull Collection<Diagnostic> diagnostics2) {
        this.diagnostics = diagnostics2;
        this.kotlinSuppressCache = new BindingContextSuppressCache(context);
        this.elementsCache = new DiagnosticsElementsCache(this, this.kotlinSuppressCache.getFilter());
    }

    @Override
    @NotNull
    public Diagnostics noSuppression() {
        return new SimpleDiagnostics(this.diagnostics);
    }

    @Override
    @NotNull
    public Iterator<Diagnostic> iterator() {
        return new FilteringIterator(this.diagnostics.iterator(), arg_0 -> this.kotlinSuppressCache.getFilter().invoke(arg_0));
    }

    @Override
    @NotNull
    public Collection<Diagnostic> all() {
        return CollectionsKt.filter(this.diagnostics, this.kotlinSuppressCache.getFilter());
    }

    @Override
    @NotNull
    public Collection<Diagnostic> forElement(@NotNull PsiElement psiElement) {
        return this.elementsCache.getDiagnostics(psiElement);
    }

    @Override
    public boolean isEmpty() {
        return this.all().isEmpty();
    }

    @Override
    @NotNull
    public ModificationTracker getModificationTracker() {
        throw new IllegalStateException("Trying to obtain modification tracker for readonly DiagnosticsWithSuppression.");
    }

    @NotNull
    public Collection<Diagnostic> getDiagnostics() {
        return this.diagnostics;
    }
}

