/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.js;

import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.SourceFile;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.source.PsiSourceFile;
import org.jetbrains.kotlin.serialization.KotlinSerializerExtensionBase;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.js.DynamicTypeDeserializer;
import org.jetbrains.kotlin.serialization.js.JavaScriptStringTable;
import org.jetbrains.kotlin.serialization.js.JsProtoBuf;
import org.jetbrains.kotlin.serialization.js.JsSerializerProtocol;
import org.jetbrains.kotlin.serialization.js.KotlinDeserializedFileMetadata;
import org.jetbrains.kotlin.serialization.js.KotlinFileRegistry;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptPackageFragment;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializationUtilKt;
import org.jetbrains.kotlin.serialization.js.KotlinPsiFileMetadata;
import org.jetbrains.kotlin.types.FlexibleType;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0017\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0016J\u0018\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u001eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/serialization/js/KotlinJavascriptSerializerExtension;", "Lorg/jetbrains/kotlin/serialization/KotlinSerializerExtensionBase;", "fileRegistry", "Lorg/jetbrains/kotlin/serialization/js/KotlinFileRegistry;", "(Lorg/jetbrains/kotlin/serialization/js/KotlinFileRegistry;)V", "stringTable", "Lorg/jetbrains/kotlin/serialization/js/JavaScriptStringTable;", "getStringTable", "()Lorg/jetbrains/kotlin/serialization/js/JavaScriptStringTable;", "getFileId", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Ljava/lang/Integer;", "serializeClass", "", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "proto", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Class$Builder;", "serializeFlexibleType", "flexibleType", "Lorg/jetbrains/kotlin/types/FlexibleType;", "lowerProto", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Type$Builder;", "upperProto", "serializeFunction", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Function$Builder;", "serializeProperty", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Property$Builder;", "js.serializer"})
public final class KotlinJavascriptSerializerExtension
extends KotlinSerializerExtensionBase {
    @NotNull
    private final JavaScriptStringTable stringTable;
    private final KotlinFileRegistry fileRegistry;

    @Override
    @NotNull
    public JavaScriptStringTable getStringTable() {
        return this.stringTable;
    }

    @Override
    public void serializeFlexibleType(@NotNull FlexibleType flexibleType, @NotNull ProtoBuf.Type.Builder lowerProto, @NotNull ProtoBuf.Type.Builder upperProto) {
        Intrinsics.checkParameterIsNotNull((Object)flexibleType, (String)"flexibleType");
        Intrinsics.checkParameterIsNotNull((Object)lowerProto, (String)"lowerProto");
        Intrinsics.checkParameterIsNotNull((Object)upperProto, (String)"upperProto");
        lowerProto.setFlexibleTypeCapabilitiesId(this.getStringTable().getStringIndex(DynamicTypeDeserializer.INSTANCE.getId()));
    }

    @Override
    public void serializeClass(@NotNull ClassDescriptor descriptor2, @NotNull ProtoBuf.Class.Builder proto) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)proto, (String)"proto");
        Integer id = this.getFileId(descriptor2);
        if (id != null) {
            proto.setExtension(JsProtoBuf.classContainingFileId, id);
        }
        super.serializeClass(descriptor2, proto);
    }

    @Override
    public void serializeProperty(@NotNull PropertyDescriptor descriptor2, @NotNull ProtoBuf.Property.Builder proto) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)proto, (String)"proto");
        Integer id = this.getFileId(descriptor2);
        if (id != null) {
            proto.setExtension(JsProtoBuf.propertyContainingFileId, id);
        }
        super.serializeProperty(descriptor2, proto);
    }

    @Override
    public void serializeFunction(@NotNull FunctionDescriptor descriptor2, @NotNull ProtoBuf.Function.Builder proto) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)proto, (String)"proto");
        Integer id = this.getFileId(descriptor2);
        if (id != null) {
            proto.setExtension(JsProtoBuf.functionContainingFileId, id);
        }
        super.serializeFunction(descriptor2, proto);
    }

    private final Integer getFileId(DeclarationDescriptor descriptor2) {
        Integer n;
        if (!DescriptorUtils.isTopLevelDeclaration(descriptor2) || !(descriptor2 instanceof DeclarationDescriptorWithSource)) {
            return null;
        }
        Integer fileId = KotlinJavascriptSerializationUtilKt.extractFileId(descriptor2);
        if (fileId != null) {
            DeclarationDescriptor declarationDescriptor = ((DeclarationDescriptorWithSource)descriptor2).getContainingDeclaration();
            if (!(declarationDescriptor instanceof KotlinJavascriptPackageFragment)) {
                declarationDescriptor = null;
            }
            KotlinJavascriptPackageFragment kotlinJavascriptPackageFragment = (KotlinJavascriptPackageFragment)declarationDescriptor;
            if (kotlinJavascriptPackageFragment != null) {
                KotlinJavascriptPackageFragment kotlinJavascriptPackageFragment2;
                KotlinJavascriptPackageFragment packageFragment = kotlinJavascriptPackageFragment2 = kotlinJavascriptPackageFragment;
                return this.fileRegistry.lookup(new KotlinDeserializedFileMetadata(packageFragment, fileId));
            }
        }
        SourceElement sourceElement = ((DeclarationDescriptorWithSource)descriptor2).getSource();
        Intrinsics.checkExpressionValueIsNotNull((Object)sourceElement, (String)"descriptor.source");
        SourceFile sourceFile = sourceElement.getContainingFile();
        if (!(sourceFile instanceof PsiSourceFile)) {
            sourceFile = null;
        }
        PsiSourceFile psiSourceFile = (PsiSourceFile)sourceFile;
        if (psiSourceFile == null) {
            return null;
        }
        PsiSourceFile file2 = psiSourceFile;
        PsiFile psiFile = file2.getPsiFile();
        PsiFile psiFile2 = psiFile;
        if (!(psiFile2 instanceof KtFile)) {
            psiFile2 = null;
        }
        KtFile ktFile = (KtFile)psiFile2;
        if (ktFile != null) {
            KtFile ktFile2;
            KtFile it = ktFile2 = ktFile;
            n = this.fileRegistry.lookup(new KotlinPsiFileMetadata(it));
        } else {
            n = null;
        }
        return n;
    }

    public KotlinJavascriptSerializerExtension(@NotNull KotlinFileRegistry fileRegistry) {
        Intrinsics.checkParameterIsNotNull((Object)fileRegistry, (String)"fileRegistry");
        super(JsSerializerProtocol.INSTANCE);
        this.fileRegistry = fileRegistry;
        this.stringTable = new JavaScriptStringTable();
    }
}

