/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.mergers;

import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.targeting.TargetingUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;

final class MergingUtils {
    public static <T> Optional<T> getSameValueOrNonNull(@Nullable T nullableValue, T otherValue) {
        Preconditions.checkNotNull(otherValue);
        if (nullableValue == null || nullableValue.equals(otherValue)) {
            return Optional.of(otherValue);
        }
        return Optional.empty();
    }

    public static Targeting.ApkTargeting mergeShardTargetings(Targeting.ApkTargeting targeting1, Targeting.ApkTargeting targeting2) {
        MergingUtils.checkHasOnlyAbiAndDensityTargeting(targeting1);
        MergingUtils.checkHasOnlyAbiAndDensityTargeting(targeting2);
        Targeting.ApkTargeting.Builder merged = Targeting.ApkTargeting.newBuilder();
        if (targeting1.hasAbiTargeting() || targeting2.hasAbiTargeting()) {
            merged.setAbiTargeting(MergingUtils.mergeAbiTargetingsOf(targeting1, targeting2));
        }
        if (targeting1.hasScreenDensityTargeting() || targeting2.hasScreenDensityTargeting()) {
            merged.setScreenDensityTargeting(MergingUtils.mergeDensityTargetingsOf(targeting1, targeting2));
        }
        return merged.build();
    }

    private static void checkHasOnlyAbiAndDensityTargeting(Targeting.ApkTargeting targeting) {
        Targeting.ApkTargeting targetingWithoutAbiAndDensity = targeting.toBuilder().clearAbiTargeting().clearScreenDensityTargeting().build();
        if (!targetingWithoutAbiAndDensity.equals(Targeting.ApkTargeting.getDefaultInstance())) {
            throw CommandExecutionException.builder().withMessage("Expecting only ABI and screen density targeting, got '%s'.", targeting).build();
        }
    }

    private static Targeting.AbiTargeting mergeAbiTargetingsOf(Targeting.ApkTargeting targeting1, Targeting.ApkTargeting targeting2) {
        Sets.SetView universe = Sets.union(TargetingUtils.abiUniverse(targeting1), TargetingUtils.abiUniverse(targeting2));
        Sets.SetView values = Sets.union(TargetingUtils.abiValues(targeting1), TargetingUtils.abiValues(targeting2));
        return Targeting.AbiTargeting.newBuilder().addAllValue((Iterable<? extends Targeting.Abi>)values).addAllAlternatives((Iterable<? extends Targeting.Abi>)Sets.difference((Set)universe, (Set)values)).build();
    }

    private static Targeting.ScreenDensityTargeting mergeDensityTargetingsOf(Targeting.ApkTargeting targeting1, Targeting.ApkTargeting targeting2) {
        Sets.SetView universe = Sets.union(TargetingUtils.densityUniverse(targeting1), TargetingUtils.densityUniverse(targeting2));
        Sets.SetView values = Sets.union(TargetingUtils.densityValues(targeting1), TargetingUtils.densityValues(targeting2));
        return Targeting.ScreenDensityTargeting.newBuilder().addAllValue((Iterable<? extends Targeting.ScreenDensity>)values).addAllAlternatives((Iterable<? extends Targeting.ScreenDensity>)Sets.difference((Set)universe, (Set)values)).build();
    }

    private MergingUtils() {
    }
}

