/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.ddmlib;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import shadow.bundletool.com.android.ddmlib.IDevice;
import shadow.bundletool.com.android.ddmlib.Log;
import shadow.bundletool.com.android.ddmlib.MultiLineReceiver;

public class IotInstallChecker {
    private static final String TAG = IotInstallChecker.class.getSimpleName();
    private static final String DUMP_PACKAGES_CMD = "dumpsys package -f r";

    public Set<String> getInstalledIotLauncherApps(IDevice device) {
        return this.getInstalledIotLauncherApps(device, 1L, TimeUnit.MINUTES);
    }

    public Set<String> getInstalledIotLauncherApps(IDevice device, long timeout, TimeUnit unit) {
        if (!device.supportsFeature(IDevice.HardwareFeature.EMBEDDED)) {
            return Collections.emptySet();
        }
        IntentListReceiver listreceiver = new IntentListReceiver();
        try {
            device.executeShellCommand(DUMP_PACKAGES_CMD, listreceiver, timeout, unit);
        }
        catch (Exception e) {
            Log.e(TAG, e);
        }
        return listreceiver.getPackagesWithIotLauncher();
    }

    static class IntentListReceiver
    extends MultiLineReceiver {
        private static final Pattern ParagraphRegex = Pattern.compile("^([\\w\\.]+):$");
        private static final String MainPart = "android.intent.action.MAIN";
        private static final Pattern PackageRegex = Pattern.compile("^\\w+ ([\\w\\.]+)/\\.\\w+ filter \\w+$");
        private static final String IotLauncher = "android.intent.category.IOT_LAUNCHER";
        private final Set<String> packagesWithIotLauncher = new HashSet<String>();
        private String currentPackage;
        private boolean mainPart = false;
        private boolean isCancelled = false;

        IntentListReceiver() {
        }

        @Override
        public void processNewLines(String[] lines) {
            for (String l : lines) {
                this.processNewLine(l);
            }
        }

        private void processNewLine(String line) {
            Matcher matcher = ParagraphRegex.matcher(line);
            if (matcher.matches()) {
                if (matcher.group(1).equals(MainPart)) {
                    this.mainPart = true;
                } else if (this.mainPart) {
                    this.isCancelled = true;
                }
                return;
            }
            if (this.mainPart) {
                matcher = PackageRegex.matcher(line);
                if (matcher.matches()) {
                    this.currentPackage = matcher.group(1);
                    return;
                }
                if (!this.packagesWithIotLauncher.contains(this.currentPackage) && line.contains(IotLauncher)) {
                    this.packagesWithIotLauncher.add(this.currentPackage);
                }
            }
        }

        @Override
        public boolean isCancelled() {
            return this.isCancelled;
        }

        public Set<String> getPackagesWithIotLauncher() {
            return this.packagesWithIotLauncher;
        }
    }
}

