/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import shadow.bundletool.com.android.tools.r8.BaseCommand;
import shadow.bundletool.com.android.tools.r8.CompilationFailedException;
import shadow.bundletool.com.android.tools.r8.StringResource;
import shadow.bundletool.com.android.tools.r8.dex.ApplicationReader;
import shadow.bundletool.com.android.tools.r8.graph.AssemblyWriter;
import shadow.bundletool.com.android.tools.r8.graph.DexApplication;
import shadow.bundletool.com.android.tools.r8.graph.DexByteCodeWriter;
import shadow.bundletool.com.android.tools.r8.graph.SmaliWriter;
import shadow.bundletool.com.android.tools.r8.origin.CommandLineOrigin;
import shadow.bundletool.com.android.tools.r8.utils.AndroidApp;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;
import shadow.bundletool.com.android.tools.r8.utils.StringDiagnostic;
import shadow.bundletool.com.android.tools.r8.utils.ThreadUtils;
import shadow.bundletool.com.android.tools.r8.utils.Timing;

public class Disassemble {
    public static void main(String[] args) throws IOException, ExecutionException, CompilationFailedException {
        DisassembleCommand.Builder builder = DisassembleCommand.parse(args);
        DisassembleCommand command = (DisassembleCommand)builder.build();
        if (command.isPrintHelp()) {
            System.out.println(DisassembleCommand.USAGE_MESSAGE);
            return;
        }
        if (command.isPrintVersion()) {
            System.out.println("Disassemble (R8) v1.0.25");
            return;
        }
        Disassemble.disassemble(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disassemble(DisassembleCommand command) throws IOException, ExecutionException {
        AndroidApp app = command.getInputApp();
        InternalOptions options = command.getInternalOptions();
        ExecutorService executor = ThreadUtils.getExecutorService(options);
        Timing timing = new Timing("disassemble");
        try {
            DexByteCodeWriter writer;
            DexApplication application = new ApplicationReader(app, options, timing).read(command.proguardMap, executor);
            DexByteCodeWriter dexByteCodeWriter = writer = command.useSmali() ? new SmaliWriter(application, options) : new AssemblyWriter(application, options);
            if (command.getOutputPath() != null) {
                writer.write(command.getOutputPath());
            } else {
                writer.write(System.out);
            }
        }
        finally {
            executor.shutdown();
        }
    }

    public static class DisassembleCommand
    extends BaseCommand {
        private final Path outputPath;
        private final StringResource proguardMap;
        static final String USAGE_MESSAGE = String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)ImmutableList.of((Object)"Usage: disasm [options] <input-files>", (Object)" where <input-files> are dex files", (Object)" and options are:", (Object)"  --smali                 # Disassemble using smali syntax.", (Object)"  --pg-map <file>         # Proguard map <file> for mapping names.", (Object)"  --output                # Specify a file or directory to write to.", (Object)"  --version               # Print the version of r8.", (Object)"  --help                  # Print this message."));
        private final boolean useSmali;

        public static Builder builder() {
            return new Builder();
        }

        public static Builder parse(String[] args) {
            Builder builder = DisassembleCommand.builder();
            DisassembleCommand.parse(args, builder);
            return builder;
        }

        private static void parse(String[] args, Builder builder) {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i].trim();
                if (arg.length() == 0) continue;
                if (arg.equals("--help")) {
                    builder.setPrintHelp(true);
                    continue;
                }
                if (arg.equals("--version")) {
                    builder.setPrintVersion(true);
                    continue;
                }
                if (arg.equals("--smali")) {
                    builder.setUseSmali(true);
                    continue;
                }
                if (arg.equals("--pg-map")) {
                    builder.setProguardMapFile(Paths.get(args[++i], new String[0]));
                    continue;
                }
                if (arg.equals("--output")) {
                    String outputPath = args[++i];
                    builder.setOutputPath(Paths.get(outputPath, new String[0]));
                    continue;
                }
                if (arg.startsWith("--")) {
                    builder.getReporter().error(new StringDiagnostic("Unknown option: " + arg, CommandLineOrigin.INSTANCE));
                }
                builder.addProgramFiles(Paths.get(arg, new String[0]));
            }
        }

        private DisassembleCommand(AndroidApp inputApp, Path outputPath, StringResource proguardMap, boolean useSmali) {
            super(inputApp);
            this.outputPath = outputPath;
            this.proguardMap = proguardMap;
            this.useSmali = useSmali;
        }

        private DisassembleCommand(boolean printHelp, boolean printVersion) {
            super(printHelp, printVersion);
            this.outputPath = null;
            this.proguardMap = null;
            this.useSmali = false;
        }

        public Path getOutputPath() {
            return this.outputPath;
        }

        public boolean useSmali() {
            return this.useSmali;
        }

        @Override
        InternalOptions getInternalOptions() {
            InternalOptions internal = new InternalOptions();
            internal.useSmaliSyntax = this.useSmali;
            return internal;
        }

        public static class Builder
        extends BaseCommand.Builder<DisassembleCommand, Builder> {
            private Path outputPath = null;
            private Path proguardMapFile = null;
            private boolean useSmali = false;

            @Override
            Builder self() {
                return this;
            }

            public Builder setProguardMapFile(Path path) {
                this.proguardMapFile = path;
                return this;
            }

            public Path getOutputPath() {
                return this.outputPath;
            }

            public Builder setOutputPath(Path outputPath) {
                this.outputPath = outputPath;
                return this;
            }

            public Builder setUseSmali(boolean useSmali) {
                this.useSmali = useSmali;
                return this;
            }

            @Override
            protected DisassembleCommand makeCommand() {
                if (this.isPrintHelp() || this.isPrintVersion()) {
                    return new DisassembleCommand(this.isPrintHelp(), this.isPrintVersion());
                }
                return new DisassembleCommand(this.getAppBuilder().build(), this.getOutputPath(), this.proguardMapFile == null ? null : StringResource.fromFile(this.proguardMapFile), this.useSmali);
            }
        }
    }
}

