/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.cf.code;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import shadow.bundletool.com.android.tools.r8.cf.CfPrinter;
import shadow.bundletool.com.android.tools.r8.cf.code.CfInstruction;
import shadow.bundletool.com.android.tools.r8.cf.code.CfLabel;

public class CfSwitch
extends CfInstruction {
    private final Kind kind = Kind.LOOKUP;
    private final CfLabel defaultTarget;
    private final int[] keys;
    private final List<CfLabel> targets;

    public CfSwitch(CfLabel defaultTarget, int[] keys, List<CfLabel> targets) {
        this.defaultTarget = defaultTarget;
        this.keys = keys;
        this.targets = targets;
    }

    public Kind getKind() {
        return this.kind;
    }

    public CfLabel getDefaultTarget() {
        return this.defaultTarget;
    }

    public IntList getKeys() {
        return new IntArrayList(this.keys);
    }

    public List<CfLabel> getTargets() {
        return this.targets;
    }

    @Override
    public void write(MethodVisitor visitor) {
        Label[] labels = new Label[this.targets.size()];
        for (int i = 0; i < this.targets.size(); ++i) {
            labels[i] = this.targets.get(i).getLabel();
        }
        visitor.visitLookupSwitchInsn(this.defaultTarget.getLabel(), this.keys, labels);
    }

    @Override
    public void print(CfPrinter printer) {
        printer.print(this);
    }

    public static enum Kind {
        LOOKUP,
        TABLE;

    }
}

