/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.code;

import java.util.List;
import java.util.function.Function;
import shadow.bundletool.com.android.tools.r8.cf.LoadStoreHelper;
import shadow.bundletool.com.android.tools.r8.cf.TypeVerificationHelper;
import shadow.bundletool.com.android.tools.r8.code.Base3Format;
import shadow.bundletool.com.android.tools.r8.code.FilledNewArray;
import shadow.bundletool.com.android.tools.r8.code.FilledNewArrayRange;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.AppInfoWithSubtyping;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.Invoke;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CfBuilder;
import shadow.bundletool.com.android.tools.r8.ir.conversion.DexBuilder;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.shaking.Enqueuer;

public class InvokeNewArray
extends Invoke {
    private final DexType type;

    public InvokeNewArray(DexType type, Value result, List<Value> arguments) {
        super(result, arguments);
        this.type = type;
    }

    @Override
    public DexType getReturnType() {
        return this.getArrayType();
    }

    public DexType getArrayType() {
        return this.type;
    }

    @Override
    public Invoke.Type getType() {
        return Invoke.Type.NEW_ARRAY;
    }

    @Override
    protected String getTypeString() {
        return "NewArray";
    }

    @Override
    public String toString() {
        return super.toString() + "; type: " + this.type.toSourceString();
    }

    @Override
    public DexEncodedMethod computeSingleTarget(Enqueuer.AppInfoWithLiveness appInfo) {
        return null;
    }

    @Override
    public void buildDex(DexBuilder builder) {
        Base3Format instruction;
        int argumentRegisters = this.requiredArgumentRegisters();
        builder.requestOutgoingRegisters(argumentRegisters);
        if (this.needsRangedInvoke(builder)) {
            assert (this.argumentsConsecutive(builder));
            int firstRegister = this.argumentRegisterValue(0, builder);
            instruction = new FilledNewArrayRange(firstRegister, argumentRegisters, this.type);
        } else {
            int[] individualArgumentRegisters = new int[5];
            int argumentRegistersCount = this.fillArgumentRegisters(builder, individualArgumentRegisters);
            instruction = new FilledNewArray(argumentRegistersCount, this.type, individualArgumentRegisters[0], individualArgumentRegisters[1], individualArgumentRegisters[2], individualArgumentRegisters[3], individualArgumentRegisters[4]);
        }
        this.addInvokeAndMoveResult(instruction, builder);
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        if (!other.isInvokeNewArray()) {
            return false;
        }
        return this.type == other.asInvokeNewArray().type;
    }

    @Override
    public int compareNonValueParts(Instruction other) {
        if (!other.isInvokeNewArray()) {
            return -1;
        }
        return this.type.slowCompareTo(other.asInvokeNewArray().type);
    }

    @Override
    public boolean isInvokeNewArray() {
        return true;
    }

    @Override
    public InvokeNewArray asInvokeNewArray() {
        return this;
    }

    @Override
    public Inliner.Constraint inliningConstraint(Enqueuer.AppInfoWithLiveness info, DexType invocationContext) {
        return Inliner.Constraint.classIsVisible(invocationContext, this.type, info);
    }

    @Override
    public TypeLatticeElement evaluate(AppInfoWithSubtyping appInfo, Function<Value, TypeLatticeElement> getLatticeElement) {
        return TypeLatticeElement.newArray(this.type, false);
    }

    @Override
    public boolean hasInvariantVerificationType() {
        throw InvokeNewArray.cfUnsupported();
    }

    @Override
    public DexType computeVerificationType(TypeVerificationHelper helper) {
        throw InvokeNewArray.cfUnsupported();
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        throw InvokeNewArray.cfUnsupported();
    }

    @Override
    public void buildCf(CfBuilder builder) {
        throw InvokeNewArray.cfUnsupported();
    }

    private static Unreachable cfUnsupported() {
        throw new Unreachable("InvokeNewArray (non-empty) not supported when compiling to classfiles.");
    }
}

