/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.naming;

import java.util.Map;
import java.util.Set;
import shadow.bundletool.com.android.tools.r8.code.ConstString;
import shadow.bundletool.com.android.tools.r8.code.ConstStringJumbo;
import shadow.bundletool.com.android.tools.r8.code.Instruction;
import shadow.bundletool.com.android.tools.r8.graph.Code;
import shadow.bundletool.com.android.tools.r8.graph.DexCode;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexItem;
import shadow.bundletool.com.android.tools.r8.graph.DexItemBasedString;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.DexValue;
import shadow.bundletool.com.android.tools.r8.naming.NamingLens;
import shadow.bundletool.com.android.tools.r8.shaking.Enqueuer;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardClassFilter;
import shadow.bundletool.com.android.tools.r8.utils.DescriptorUtils;

class IdentifierMinifier {
    private final Enqueuer.AppInfoWithLiveness appInfo;
    private final ProguardClassFilter adaptClassStrings;
    private final NamingLens lens;
    private final Set<DexItem> identifierNameStrings;

    IdentifierMinifier(Enqueuer.AppInfoWithLiveness appInfo, ProguardClassFilter adaptClassStrings, NamingLens lens) {
        this.appInfo = appInfo;
        this.adaptClassStrings = adaptClassStrings;
        this.lens = lens;
        this.identifierNameStrings = appInfo.identifierNameStrings;
    }

    void run() {
        if (!this.adaptClassStrings.isEmpty()) {
            this.adaptClassStrings();
        }
        if (!this.identifierNameStrings.isEmpty()) {
            this.replaceIdentifierNameString();
        }
    }

    private void adaptClassStrings() {
        for (DexProgramClass clazz : this.appInfo.classes()) {
            if (!this.adaptClassStrings.matches(clazz.type)) continue;
            clazz.forEachField(this::adaptClassStringsInField);
            clazz.forEachMethod(this::adaptClassStringsInMethod);
        }
    }

    private void adaptClassStringsInField(DexEncodedField encodedField) {
        if (!(encodedField.staticValue instanceof DexValue.DexValueString)) {
            return;
        }
        DexString original = ((DexValue.DexValueString)encodedField.staticValue).getValue();
        DexString renamed = this.getRenamedStringLiteral(original);
        if (renamed != original) {
            encodedField.staticValue = new DexValue.DexValueString(renamed);
        }
    }

    private void adaptClassStringsInMethod(DexEncodedMethod encodedMethod) {
        if (encodedMethod.accessFlags.isAbstract()) {
            return;
        }
        Code code = encodedMethod.getCode();
        if (code == null) {
            return;
        }
        assert (code.isDexCode());
        DexCode dexCode = code.asDexCode();
        for (Instruction instr : dexCode.instructions) {
            DexString dexString;
            Instruction cnst;
            if (instr instanceof ConstString) {
                cnst = (ConstString)instr;
                dexString = ((ConstString)cnst).getString();
                ((ConstString)cnst).BBBB = this.getRenamedStringLiteral(dexString);
                continue;
            }
            if (!(instr instanceof ConstStringJumbo)) continue;
            cnst = (ConstStringJumbo)instr;
            dexString = ((ConstStringJumbo)cnst).getString();
            ((ConstStringJumbo)cnst).BBBBBBBB = this.getRenamedStringLiteral(dexString);
        }
    }

    private DexString getRenamedStringLiteral(DexString originalLiteral) {
        DexString renamed;
        String originalString = originalLiteral.toString();
        Map<String, DexType> renamedYetMatchedTypes = this.lens.getRenamedItems(DexType.class, type -> type.toSourceString().equals(originalString), DexType::toSourceString);
        DexType type2 = renamedYetMatchedTypes.get(originalString);
        if (type2 != null && (renamed = this.lens.lookupDescriptor(type2)) != originalLiteral) {
            return this.appInfo.dexItemFactory.createString(DescriptorUtils.descriptorToJavaType(renamed.toString()));
        }
        return originalLiteral;
    }

    private void replaceIdentifierNameString() {
        for (DexProgramClass clazz : this.appInfo.classes()) {
            clazz.forEachField(this::replaceIdentifierNameStringInField);
            clazz.forEachMethod(this::replaceIdentifierNameStringInMethod);
        }
    }

    private void replaceIdentifierNameStringInField(DexEncodedField encodedField) {
        if (!(encodedField.staticValue instanceof DexValue.DexValueString)) {
            return;
        }
        DexString original = ((DexValue.DexValueString)encodedField.staticValue).getValue();
        if (original instanceof DexItemBasedString) {
            encodedField.staticValue = new DexValue.DexValueString(this.materialize((DexItemBasedString)original));
        }
    }

    private void replaceIdentifierNameStringInMethod(DexEncodedMethod encodedMethod) {
        if (!encodedMethod.getOptimizationInfo().useIdentifierNameString()) {
            return;
        }
        if (encodedMethod.accessFlags.isAbstract()) {
            return;
        }
        Code code = encodedMethod.getCode();
        if (code == null) {
            return;
        }
        assert (code.isDexCode());
        DexCode dexCode = code.asDexCode();
        for (Instruction instr : dexCode.instructions) {
            DexItemBasedString itemBasedString;
            Instruction cnst;
            if (instr instanceof ConstString && ((ConstString)instr).getString() instanceof DexItemBasedString) {
                cnst = (ConstString)instr;
                itemBasedString = (DexItemBasedString)((ConstString)cnst).getString();
                ((ConstString)cnst).BBBB = this.materialize(itemBasedString);
                continue;
            }
            if (!(instr instanceof ConstStringJumbo) || !(((ConstStringJumbo)instr).getString() instanceof DexItemBasedString)) continue;
            cnst = (ConstStringJumbo)instr;
            itemBasedString = (DexItemBasedString)((ConstStringJumbo)cnst).getString();
            ((ConstStringJumbo)cnst).BBBBBBBB = this.materialize(itemBasedString);
        }
    }

    private DexString materialize(DexItemBasedString itemBasedString) {
        if (itemBasedString.basedOn instanceof DexType) {
            DexString renamed = this.lens.lookupDescriptor((DexType)itemBasedString.basedOn);
            if (!renamed.toString().equals(itemBasedString.toString())) {
                return this.appInfo.dexItemFactory.createString(DescriptorUtils.descriptorToJavaType(renamed.toString()));
            }
            return renamed;
        }
        if (itemBasedString.basedOn instanceof DexMethod) {
            return this.lens.lookupName((DexMethod)itemBasedString.basedOn);
        }
        assert (itemBasedString.basedOn instanceof DexField);
        return this.lens.lookupName((DexField)itemBasedString.basedOn);
    }
}

