/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.shaking.protolite;

import com.google.common.base.Equivalence;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import shadow.bundletool.com.android.tools.r8.graph.AppInfoWithSubtyping;
import shadow.bundletool.com.android.tools.r8.graph.DelegatingUseRegistry;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.UseRegistry;
import shadow.bundletool.com.android.tools.r8.shaking.protolite.ProtoLiteBase;
import shadow.bundletool.com.android.tools.r8.utils.MethodJavaSignatureEquivalence;

public class ProtoLiteExtension
extends ProtoLiteBase {
    private final Equivalence<DexMethod> equivalence = MethodJavaSignatureEquivalence.get();
    private final Set<Equivalence.Wrapper<DexMethod>> methodsOnMessageType;
    private final DexString caseGetterSuffix;
    private final DexString caseFieldSuffix;

    public ProtoLiteExtension(AppInfoWithSubtyping appInfo) {
        super(appInfo);
        DexItemFactory factory = appInfo.dexItemFactory;
        this.methodsOnMessageType = this.computeMethodsOnMessageType();
        this.caseGetterSuffix = factory.createString("Case");
        this.caseFieldSuffix = factory.createString("Case_");
    }

    private Set<Equivalence.Wrapper<DexMethod>> computeMethodsOnMessageType() {
        DexClass messageClass = this.appInfo.definitionFor(this.messageType);
        if (messageClass == null) {
            return Collections.emptySet();
        }
        HashSet<Equivalence.Wrapper<DexMethod>> superMethods = new HashSet<Equivalence.Wrapper<DexMethod>>();
        messageClass.forEachMethod(method -> superMethods.add(this.equivalence.wrap((Object)method.method)));
        return superMethods;
    }

    @Override
    boolean isSetterThatNeedsProcessing(DexEncodedMethod method) {
        return method.accessFlags.isPrivate() && method.method.name.beginsWith(this.setterNamePrefix) && !this.methodsOnMessageType.contains(this.equivalence.wrap((Object)method.method));
    }

    private boolean isGetter(DexMethod method, DexType instanceType) {
        return method.holder == instanceType && (method.proto.parameters.isEmpty() || this.hasSingleIntArgument(method)) && method.name.beginsWith(this.getterNamePrefix) && !method.name.endsWith(this.caseGetterSuffix) && !this.methodsOnMessageType.contains(this.equivalence.wrap((Object)method));
    }

    private boolean isProtoField(DexField field, DexType instanceType) {
        if (field.getHolder() != instanceType) {
            return false;
        }
        DexString name = field.name;
        return name.endsWith(this.underscore) && !name.beginsWith(this.bitFieldPrefix) && !name.endsWith(this.caseFieldSuffix);
    }

    public void processMethod(DexEncodedMethod method, UseRegistry registry, Set<DexField> protoLiteFields) {
        assert (protoLiteFields != null);
        if (this.isSetterThatNeedsProcessing(method)) {
            method.registerInstructionsReferences(new FieldWriteImpliesReadUseRegistry(registry, method.method.holder));
        } else {
            method.registerInstructionsReferences(new FilteringUseRegistry(registry, method.method.holder, protoLiteFields));
        }
    }

    private class FilteringUseRegistry
    extends DelegatingUseRegistry {
        private final DexType instanceType;
        private final Set<DexField> registerField;

        private FilteringUseRegistry(UseRegistry delegate, DexType instanceType, Set<DexField> registerField) {
            super(delegate);
            this.instanceType = instanceType;
            this.registerField = registerField;
        }

        @Override
        public boolean registerInstanceFieldWrite(DexField field) {
            if (ProtoLiteExtension.this.isProtoField(field, this.instanceType)) {
                this.registerField.add(field);
                return false;
            }
            return super.registerInstanceFieldWrite(field);
        }

        @Override
        public boolean registerInstanceFieldRead(DexField field) {
            if (ProtoLiteExtension.this.isProtoField(field, this.instanceType)) {
                this.registerField.add(field);
                return false;
            }
            return super.registerInstanceFieldRead(field);
        }

        @Override
        public boolean registerInvokeVirtual(DexMethod method) {
            if (ProtoLiteExtension.this.isGetter(method, this.instanceType)) {
                DexField field = ProtoLiteExtension.this.getterToField(method);
                if (ProtoLiteExtension.this.isProtoField(field, this.instanceType)) {
                    this.registerField.add(field);
                    return false;
                }
                field = ProtoLiteExtension.this.getterToField(method, 5);
                if (ProtoLiteExtension.this.isProtoField(field, this.instanceType)) {
                    this.registerField.add(field);
                    return false;
                }
            }
            return super.registerInvokeVirtual(method);
        }
    }

    private class FieldWriteImpliesReadUseRegistry
    extends DelegatingUseRegistry {
        private final DexType instanceType;

        FieldWriteImpliesReadUseRegistry(UseRegistry delegate, DexType instanceType) {
            super(delegate);
            this.instanceType = instanceType;
        }

        @Override
        public boolean registerInstanceFieldWrite(DexField field) {
            if (ProtoLiteExtension.this.isProtoField(field, this.instanceType)) {
                super.registerInstanceFieldRead(field);
            }
            return super.registerInstanceFieldWrite(field);
        }
    }
}

