/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.time;

import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import org.gradle.internal.time.CountdownTimer;
import org.gradle.internal.time.DefaultTimer;
import org.gradle.internal.time.TimeSource;

class DefaultCountdownTimer
extends DefaultTimer
implements CountdownTimer {
    private final long timeoutMillis;

    DefaultCountdownTimer(TimeSource timeSource, long timeout, TimeUnit unit) {
        super(timeSource);
        Preconditions.checkArgument((timeout > 0L ? 1 : 0) != 0);
        this.timeoutMillis = unit.toMillis(timeout);
    }

    public boolean hasExpired() {
        return this.getRemainingMillis() <= 0L;
    }

    public long getRemainingMillis() {
        return Math.max(this.timeoutMillis - this.getElapsedMillis(), 0L);
    }

    public long getTimeoutMillis() {
        return this.timeoutMillis;
    }
}

