/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.meta.impl;

import com.intellij.lang.Language;
import com.intellij.lang.documentation.AbstractDocumentationProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLLanguage;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeProvider;
import org.jetbrains.yaml.meta.model.Field;
import org.jetbrains.yaml.meta.model.TypeFieldPair;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLValue;

@ApiStatus.Experimental
public abstract class YamlDocumentationProviderBase
extends AbstractDocumentationProvider {
    @Nullable
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        return null;
    }

    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        if (!(element instanceof DocumentationElement)) {
            return null;
        }
        return ((DocumentationElement)element).getDocumentation();
    }

    @Nullable
    public PsiElement getCustomDocumentationElement(@NotNull Editor editor, @NotNull PsiFile file, @Nullable PsiElement contextElement) {
        if (editor == null) {
            YamlDocumentationProviderBase.$$$reportNull$$$0(0);
        }
        if (file == null) {
            YamlDocumentationProviderBase.$$$reportNull$$$0(1);
        }
        if (contextElement == null || !this.isRelevant(contextElement)) {
            return null;
        }
        return this.createFromPsiElement(contextElement);
    }

    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement contextElement) {
        if (object instanceof YamlMetaType.ForcedCompletionPath) {
            return this.createFromCompletionPath((YamlMetaType.ForcedCompletionPath)object, contextElement);
        }
        if (object instanceof TypeFieldPair) {
            return this.createFromField((TypeFieldPair)object, contextElement);
        }
        if (object instanceof String) {
            return this.createFromString((String)object, contextElement);
        }
        return null;
    }

    protected abstract boolean isRelevant(@NotNull PsiElement var1);

    @Nullable
    protected abstract String getDocumentation(@NotNull Project var1, @NotNull YamlMetaType var2, @Nullable Field var3);

    @Nullable
    protected abstract YamlMetaTypeProvider getMetaTypeProvider(@NotNull PsiElement var1);

    @Nullable
    private static <T extends PsiElement> T getTypedAncestorOrSelf(@NotNull PsiElement psi, @NotNull Class<? extends T> clazz) {
        if (psi == null) {
            YamlDocumentationProviderBase.$$$reportNull$$$0(2);
        }
        if (clazz == null) {
            YamlDocumentationProviderBase.$$$reportNull$$$0(3);
        }
        return (T)(clazz.isInstance(psi) ? (PsiElement)clazz.cast(psi) : PsiTreeUtil.getParentOfType((PsiElement)psi, clazz));
    }

    @Nullable
    private DocumentationElement createFromPsiElement(@Nullable PsiElement contextElement) {
        YamlMetaTypeProvider.MetaTypeProxy objectMetatype;
        YamlMetaTypeProvider.MetaTypeProxy fieldMetatype;
        if (contextElement == null) {
            return null;
        }
        YamlMetaTypeProvider modelProvider = this.getMetaTypeProvider(contextElement);
        if (modelProvider == null) {
            return null;
        }
        YAMLPsiElement yamlElement = YamlDocumentationProviderBase.getTypedAncestorOrSelf(contextElement, YAMLPsiElement.class);
        if (yamlElement == null) {
            return null;
        }
        if (yamlElement instanceof YAMLValue) {
            fieldMetatype = modelProvider.getMetaTypeProxy((PsiElement)yamlElement);
            YAMLMapping mapping = YamlDocumentationProviderBase.getTypedAncestorOrSelf((PsiElement)yamlElement, YAMLMapping.class);
            YamlMetaTypeProvider.MetaTypeProxy metaTypeProxy = objectMetatype = mapping != null ? modelProvider.getMetaTypeProxy((PsiElement)mapping) : null;
            if (mapping != null && fieldMetatype != null && fieldMetatype.getField().getName().equals("kind") && mapping.getKeyValues().stream().anyMatch(kv -> "apiVersion".equals(kv.getKeyText().trim()))) {
                fieldMetatype = null;
            }
        } else if (yamlElement instanceof YAMLKeyValue) {
            objectMetatype = modelProvider.getMetaTypeProxy((PsiElement)yamlElement);
            fieldMetatype = modelProvider.getKeyValueMetaType((YAMLKeyValue)yamlElement);
        } else {
            objectMetatype = modelProvider.getMetaTypeProxy((PsiElement)yamlElement);
            fieldMetatype = null;
        }
        if (objectMetatype == null) {
            return null;
        }
        return new DocumentationElement(contextElement.getManager(), objectMetatype.getMetaType(), fieldMetatype != null ? fieldMetatype.getField() : null);
    }

    @Nullable
    private DocumentationElement createFromCompletionPath(@NotNull YamlMetaType.ForcedCompletionPath path, @NotNull PsiElement contextElement) {
        YamlMetaTypeProvider typeProvider;
        if (path == null) {
            YamlDocumentationProviderBase.$$$reportNull$$$0(4);
        }
        if (contextElement == null) {
            YamlDocumentationProviderBase.$$$reportNull$$$0(5);
        }
        if ((typeProvider = this.getMetaTypeProvider(contextElement)) == null) {
            return null;
        }
        Field field = path.getFinalizingField();
        if (field == null) {
            return null;
        }
        YamlMetaType type = path.getFinalizingType();
        if (type == null) {
            YamlMetaTypeProvider.MetaTypeProxy proxy = typeProvider.getMetaTypeProxy(contextElement);
            if (proxy == null) {
                return null;
            }
            type = proxy.getMetaType();
        }
        return new DocumentationElement(contextElement.getManager(), type, field);
    }

    @Nullable
    private DocumentationElement createFromString(@NotNull String fieldName, @NotNull PsiElement contextElement) {
        YamlMetaTypeProvider typeProvider;
        if (fieldName == null) {
            YamlDocumentationProviderBase.$$$reportNull$$$0(6);
        }
        if (contextElement == null) {
            YamlDocumentationProviderBase.$$$reportNull$$$0(7);
        }
        if ((typeProvider = this.getMetaTypeProvider(contextElement)) == null) {
            return null;
        }
        YamlMetaTypeProvider.MetaTypeProxy proxy = typeProvider.getMetaTypeProxy(contextElement);
        if (proxy == null) {
            return null;
        }
        Field field = proxy.getMetaType().findFeatureByName(fieldName);
        if (field == null) {
            return null;
        }
        return new DocumentationElement(contextElement.getManager(), proxy.getMetaType(), field);
    }

    @NotNull
    private DocumentationElement createFromField(@NotNull TypeFieldPair field, @NotNull PsiElement contextElement) {
        if (field == null) {
            YamlDocumentationProviderBase.$$$reportNull$$$0(8);
        }
        if (contextElement == null) {
            YamlDocumentationProviderBase.$$$reportNull$$$0(9);
        }
        DocumentationElement documentationElement = new DocumentationElement(contextElement.getManager(), field.getMetaType(), field.getField());
        if (documentationElement == null) {
            YamlDocumentationProviderBase.$$$reportNull$$$0(10);
        }
        return documentationElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/meta/impl/YamlDocumentationProviderBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/meta/impl/YamlDocumentationProviderBase";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createFromField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCustomDocumentationElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTypedAncestorOrSelf";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createFromCompletionPath";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createFromString";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createFromField";
                break;
            }
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class DocumentationElement
    extends LightElement {
        @NotNull
        private final Project myProject;
        @NotNull
        private final YamlMetaType myType;
        @Nullable
        private final Field myField;

        public DocumentationElement(@NotNull PsiManager manager, @Nullable YamlMetaType type, Field field) {
            if (manager == null) {
                DocumentationElement.$$$reportNull$$$0(0);
            }
            if (type == null) {
                DocumentationElement.$$$reportNull$$$0(1);
            }
            super(manager, (Language)YAMLLanguage.INSTANCE);
            this.myProject = manager.getProject();
            this.myType = type;
            this.myField = field;
        }

        public String toString() {
            return "DocumentationElement: " + this.myType + "#" + this.myField;
        }

        public String getText() {
            return this.myField != null ? this.myField.getName() + " : " + this.myField.getDefaultType().getDisplayName() : this.myType.getDisplayName();
        }

        @Nullable
        public String getDocumentation() {
            return YamlDocumentationProviderBase.this.getDocumentation(this.myProject, this.myType, this.myField);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "manager";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/yaml/meta/impl/YamlDocumentationProviderBase$DocumentationElement";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

