/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.meta.impl;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;

@ApiStatus.Experimental
public abstract class YamlDuplicatedKeysInspectionBase
extends LocalInspectionTool {
    @NotNull
    public final PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            YamlDuplicatedKeysInspectionBase.$$$reportNull$$$0(0);
        }
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                ProgressIndicatorProvider.checkCanceled();
                if (!(element instanceof YAMLMapping)) {
                    return;
                }
                MultiMap occurrences = new MultiMap();
                for (YAMLKeyValue keyValue : ((YAMLMapping)element).getKeyValues()) {
                    String keyName = keyValue.getKeyText().trim();
                    if (keyName.isEmpty()) continue;
                    occurrences.putValue((Object)keyName, (Object)keyValue);
                }
                for (Map.Entry entry : occurrences.entrySet()) {
                    if (((Collection)entry.getValue()).size() <= 1) continue;
                    ((Collection)entry.getValue()).forEach(duplicatedKey -> {
                        if (holder == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        assert (duplicatedKey.getKey() != null);
                        holder.registerProblem(duplicatedKey.getKey(), YAMLBundle.message("YamlDuplicatedKeysInspectionBase.duplicated.key", entry.getKey()), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new RemoveDuplicatedKeyQuickFix((YAMLKeyValue)duplicatedKey)});
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/yaml/meta/impl/YamlDuplicatedKeysInspectionBase$1", "lambda$visitElement$0"));
            }
        };
        if (psiElementVisitor == null) {
            YamlDuplicatedKeysInspectionBase.$$$reportNull$$$0(1);
        }
        return psiElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/meta/impl/YamlDuplicatedKeysInspectionBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/meta/impl/YamlDuplicatedKeysInspectionBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RemoveDuplicatedKeyQuickFix
    implements LocalQuickFix {
        private final SmartPsiElementPointer<YAMLKeyValue> myKeyValueHolder;

        public RemoveDuplicatedKeyQuickFix(@NotNull YAMLKeyValue keyValue) {
            if (keyValue == null) {
                RemoveDuplicatedKeyQuickFix.$$$reportNull$$$0(0);
            }
            this.myKeyValueHolder = SmartPointerManager.getInstance((Project)keyValue.getProject()).createSmartPsiElementPointer((PsiElement)keyValue);
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = YAMLBundle.message("YamlDuplicatedKeysInspectionBase.remove.key.quickfix.name");
            if (string == null) {
                RemoveDuplicatedKeyQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            YAMLKeyValue keyVal;
            if (project == null) {
                RemoveDuplicatedKeyQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                RemoveDuplicatedKeyQuickFix.$$$reportNull$$$0(3);
            }
            if ((keyVal = (YAMLKeyValue)this.myKeyValueHolder.getElement()) == null) {
                return;
            }
            keyVal.getParentMapping().deleteKeyValue(keyVal);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keyValue";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/yaml/meta/impl/YamlDuplicatedKeysInspectionBase$RemoveDuplicatedKeyQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/yaml/meta/impl/YamlDuplicatedKeysInspectionBase$RemoveDuplicatedKeyQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

