/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.client;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.gradle.api.internal.specs.ExplainingSpec;
import org.gradle.api.internal.specs.ExplainingSpecs;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.specs.Spec;
import org.gradle.internal.Pair;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.remote.internal.ConnectException;
import org.gradle.internal.remote.internal.OutgoingConnector;
import org.gradle.internal.remote.internal.RemoteConnection;
import org.gradle.internal.serialize.Serializers;
import org.gradle.internal.time.CountdownTimer;
import org.gradle.internal.time.Time;
import org.gradle.launcher.daemon.client.DaemonClientConnection;
import org.gradle.launcher.daemon.client.DaemonConnectionException;
import org.gradle.launcher.daemon.client.DaemonConnector;
import org.gradle.launcher.daemon.client.DaemonStartListener;
import org.gradle.launcher.daemon.client.DaemonStarter;
import org.gradle.launcher.daemon.client.DaemonStartupMessage;
import org.gradle.launcher.daemon.context.DaemonConnectDetails;
import org.gradle.launcher.daemon.context.DaemonContext;
import org.gradle.launcher.daemon.diagnostics.DaemonStartupInfo;
import org.gradle.launcher.daemon.protocol.DaemonMessageSerializer;
import org.gradle.launcher.daemon.protocol.Message;
import org.gradle.launcher.daemon.registry.DaemonInfo;
import org.gradle.launcher.daemon.registry.DaemonRegistry;
import org.gradle.launcher.daemon.registry.DaemonStopEvent;
import org.gradle.launcher.daemon.registry.DaemonStopEvents;
import org.gradle.launcher.daemon.server.api.DaemonStateControl;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDaemonConnector
implements DaemonConnector {
    private static final Logger LOGGER = Logging.getLogger(DefaultDaemonConnector.class);
    public static final int DEFAULT_CONNECT_TIMEOUT = 30000;
    public static final int CANCELED_WAIT_TIMEOUT = 3000;
    private final DaemonRegistry daemonRegistry;
    protected final OutgoingConnector connector;
    private final DaemonStarter daemonStarter;
    private final DaemonStartListener startListener;
    private final ProgressLoggerFactory progressLoggerFactory;
    private long connectTimeout = 30000L;

    public DefaultDaemonConnector(DaemonRegistry daemonRegistry, OutgoingConnector connector, DaemonStarter daemonStarter, DaemonStartListener startListener, ProgressLoggerFactory progressLoggerFactory) {
        Preconditions.checkNotNull((Object)daemonRegistry);
        Preconditions.checkNotNull((Object)connector);
        Preconditions.checkNotNull((Object)daemonStarter);
        Preconditions.checkNotNull((Object)startListener);
        Preconditions.checkNotNull((Object)progressLoggerFactory);
        this.daemonRegistry = daemonRegistry;
        this.connector = connector;
        this.daemonStarter = daemonStarter;
        this.startListener = startListener;
        this.progressLoggerFactory = progressLoggerFactory;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public DaemonRegistry getDaemonRegistry() {
        return this.daemonRegistry;
    }

    @Override
    public DaemonClientConnection maybeConnect(ExplainingSpec<DaemonContext> constraint) {
        return this.findConnection(this.getCompatibleDaemons(this.daemonRegistry.getAll(), constraint));
    }

    @Override
    public DaemonClientConnection maybeConnect(DaemonConnectDetails daemon) {
        try {
            return this.connectToDaemon(daemon, new CleanupOnStaleAddress(daemon, true));
        }
        catch (ConnectException e) {
            LOGGER.debug("Cannot connect to daemon {} due to {}. Ignoring.", (Object)daemon, (Object)e);
            return null;
        }
    }

    @Override
    public DaemonClientConnection connect(ExplainingSpec<DaemonContext> constraint) {
        Pair<Collection<DaemonInfo>, Collection<DaemonInfo>> idleBusy = this.partitionByState(this.daemonRegistry.getAll(), DaemonStateControl.State.Idle);
        Collection idleDaemons = (Collection)idleBusy.getLeft();
        Collection busyDaemons = (Collection)idleBusy.getRight();
        DaemonClientConnection connection = this.connectToIdleDaemon(idleDaemons, constraint);
        if (connection != null) {
            return connection;
        }
        connection = this.connectToCanceledDaemon(busyDaemons, constraint);
        if (connection != null) {
            return connection;
        }
        this.handleStopEvents(idleDaemons, busyDaemons);
        return this.startDaemon(constraint);
    }

    private void handleStopEvents(Collection<DaemonInfo> idleDaemons, Collection<DaemonInfo> busyDaemons) {
        List<DaemonStopEvent> stopEvents = this.daemonRegistry.getStopEvents();
        this.daemonRegistry.removeStopEvents(DaemonStopEvents.oldStopEvents(stopEvents));
        List<DaemonStopEvent> recentStopEvents = DaemonStopEvents.uniqueRecentDaemonStopEvents(stopEvents);
        for (DaemonStopEvent stopEvent : recentStopEvents) {
            Long pid = stopEvent.getPid();
            LOGGER.info("Previous Daemon (" + (pid == null ? "PID unknown" : pid) + ") stopped at " + stopEvent.getTimestamp() + " " + stopEvent.getReason());
        }
        LOGGER.lifecycle(DaemonStartupMessage.generate(busyDaemons.size(), idleDaemons.size(), recentStopEvents.size()));
    }

    private DaemonClientConnection connectToIdleDaemon(Collection<DaemonInfo> idleDaemons, ExplainingSpec<DaemonContext> constraint) {
        List<DaemonInfo> compatibleIdleDaemons = this.getCompatibleDaemons(idleDaemons, constraint);
        return this.findConnection(compatibleIdleDaemons);
    }

    private DaemonClientConnection connectToCanceledDaemon(Collection<DaemonInfo> busyDaemons, ExplainingSpec<DaemonContext> constraint) {
        DaemonClientConnection connection = null;
        Pair<Collection<DaemonInfo>, Collection<DaemonInfo>> canceledBusy = this.partitionByState(busyDaemons, DaemonStateControl.State.Canceled);
        List<DaemonInfo> compatibleCanceledDaemons = this.getCompatibleDaemons((Iterable)canceledBusy.getLeft(), constraint);
        if (!compatibleCanceledDaemons.isEmpty()) {
            LOGGER.info("Waiting for daemons with canceled builds to become available");
            CountdownTimer timer = Time.startCountdownTimer((long)3000L);
            while (connection == null && !timer.hasExpired()) {
                try {
                    Thread.sleep(200L);
                    connection = this.connectToIdleDaemon(this.daemonRegistry.getIdle(), constraint);
                }
                catch (InterruptedException e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            }
        }
        return connection;
    }

    private Pair<Collection<DaemonInfo>, Collection<DaemonInfo>> partitionByState(Collection<DaemonInfo> daemons, final DaemonStateControl.State state) {
        return CollectionUtils.partition(daemons, (Spec)new Spec<DaemonInfo>(){

            public boolean isSatisfiedBy(DaemonInfo daemonInfo) {
                return daemonInfo.getState() == state;
            }
        });
    }

    private List<DaemonInfo> getCompatibleDaemons(Iterable<DaemonInfo> daemons, ExplainingSpec<DaemonContext> constraint) {
        LinkedList<DaemonInfo> compatibleDaemons = new LinkedList<DaemonInfo>();
        for (DaemonInfo daemon : daemons) {
            if (constraint.isSatisfiedBy((Object)daemon.getContext())) {
                compatibleDaemons.add(daemon);
                continue;
            }
            LOGGER.info("Found daemon {} however its context does not match the desired criteria.\n" + constraint.whyUnsatisfied((Object)daemon.getContext()) + "\n" + "  Looking for a different daemon...", (Object)daemon);
        }
        return compatibleDaemons;
    }

    private DaemonClientConnection findConnection(List<DaemonInfo> compatibleDaemons) {
        for (DaemonInfo daemon : compatibleDaemons) {
            try {
                return this.connectToDaemon(daemon, new CleanupOnStaleAddress(daemon, true));
            }
            catch (ConnectException e) {
                LOGGER.debug("Cannot connect to daemon {} due to {}. Trying a different daemon...", (Object)daemon, (Object)e);
            }
        }
        return null;
    }

    @Override
    public DaemonClientConnection startDaemon(ExplainingSpec<DaemonContext> constraint) {
        return this.doStartDaemon(constraint, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DaemonClientConnection doStartDaemon(ExplainingSpec<DaemonContext> constraint, boolean singleRun) {
        ProgressLogger progressLogger = this.progressLoggerFactory.newOperation(DefaultDaemonConnector.class).start("Starting Gradle Daemon", "Starting Daemon");
        DaemonStartupInfo startupInfo = this.daemonStarter.startDaemon(singleRun);
        LOGGER.debug("Started Gradle daemon {}", (Object)startupInfo);
        CountdownTimer timer = Time.startCountdownTimer((long)this.connectTimeout);
        try {
            do {
                DaemonClientConnection daemonConnection;
                if ((daemonConnection = this.connectToDaemonWithId(startupInfo, constraint)) != null) {
                    this.startListener.daemonStarted(daemonConnection.getDaemon());
                    DaemonClientConnection daemonClientConnection = daemonConnection;
                    return daemonClientConnection;
                }
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            } while (!timer.hasExpired());
        }
        finally {
            progressLogger.completed();
        }
        throw new DaemonConnectionException("Timeout waiting to connect to the Gradle daemon.\n" + startupInfo.describe());
    }

    @Override
    public DaemonClientConnection startSingleUseDaemon() {
        return this.doStartDaemon((ExplainingSpec<DaemonContext>)ExplainingSpecs.satisfyAll(), true);
    }

    private DaemonClientConnection connectToDaemonWithId(DaemonStartupInfo daemon, ExplainingSpec<DaemonContext> constraint) throws ConnectException {
        for (DaemonInfo daemonInfo : this.daemonRegistry.getNotIdle()) {
            if (!daemonInfo.getUid().equals(daemon.getUid())) continue;
            try {
                if (!constraint.isSatisfiedBy((Object)daemonInfo.getContext())) {
                    throw new DaemonConnectionException("The newly created daemon process has a different context than expected.\nIt won't be possible to reconnect to this daemon. Context mismatch: \n" + constraint.whyUnsatisfied((Object)daemonInfo.getContext()));
                }
                return this.connectToDaemon(daemonInfo, new CleanupOnStaleAddress(daemonInfo, false));
            }
            catch (ConnectException e) {
                throw new DaemonConnectionException("Could not connect to the Gradle daemon.\n" + daemon.describe(), e);
            }
        }
        return null;
    }

    private DaemonClientConnection connectToDaemon(DaemonConnectDetails daemon, DaemonClientConnection.StaleAddressDetector staleAddressDetector) throws ConnectException {
        RemoteConnection connection;
        ProgressLogger progressLogger = this.progressLoggerFactory.newOperation(DefaultDaemonConnector.class).start("Connecting to Gradle Daemon", "Connecting to Daemon");
        try {
            connection = this.connector.connect(daemon.getAddress()).create(Serializers.stateful(DaemonMessageSerializer.create()));
        }
        catch (ConnectException e) {
            staleAddressDetector.maybeStaleAddress((Exception)((Object)e));
            throw e;
        }
        finally {
            progressLogger.completed();
        }
        return new DaemonClientConnection((RemoteConnection<Message>)connection, daemon, staleAddressDetector);
    }

    private class CleanupOnStaleAddress
    implements DaemonClientConnection.StaleAddressDetector {
        private final DaemonConnectDetails daemon;
        private final boolean exposeAsStale;

        public CleanupOnStaleAddress(DaemonConnectDetails daemon, boolean exposeAsStale) {
            this.daemon = daemon;
            this.exposeAsStale = exposeAsStale;
        }

        public boolean maybeStaleAddress(Exception failure) {
            LOGGER.info("{}{}", (Object)"Removing daemon from the registry due to communication failure. Daemon information: ", (Object)this.daemon);
            Date timestamp = new Date(System.currentTimeMillis());
            DaemonStopEvent stopEvent = new DaemonStopEvent(timestamp, this.daemon.getPid(), null, "by user or operating system");
            DefaultDaemonConnector.this.daemonRegistry.storeStopEvent(stopEvent);
            DefaultDaemonConnector.this.daemonRegistry.remove(this.daemon.getAddress());
            return this.exposeAsStale;
        }
    }
}

