/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.rfb.protocol;

import com.glavsoft.drawing.Renderer;
import com.glavsoft.exceptions.CommonException;
import com.glavsoft.exceptions.ProtocolException;
import com.glavsoft.exceptions.TransportException;
import com.glavsoft.rfb.ClipboardController;
import com.glavsoft.rfb.IRepaintController;
import com.glavsoft.rfb.client.FramebufferUpdateRequestMessage;
import com.glavsoft.rfb.client.SetPixelFormatMessage;
import com.glavsoft.rfb.encoding.EncodingType;
import com.glavsoft.rfb.encoding.PixelFormat;
import com.glavsoft.rfb.encoding.decoder.Decoder;
import com.glavsoft.rfb.encoding.decoder.FramebufferUpdateRectangle;
import com.glavsoft.rfb.protocol.Protocol;
import com.glavsoft.transport.BaudrateMeter;
import com.glavsoft.transport.Transport;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Logger;

public class ReceiverTask
implements Runnable {
    private static final byte FRAMEBUFFER_UPDATE = 0;
    private static final byte SET_COLOR_MAP_ENTRIES = 1;
    private static final byte BELL = 2;
    private static final byte SERVER_CUT_TEXT = 3;
    private static Logger logger = Logger.getLogger("com.glavsoft.rfb.protocol.ReceiverTask");
    private final Transport transport;
    private volatile boolean isRunning = false;
    private Renderer renderer;
    private final IRepaintController repaintController;
    private final ClipboardController clipboardController;
    protected FramebufferUpdateRequestMessage fullscreenFbUpdateIncrementalRequest;
    private final Protocol protocol;
    private BaudrateMeter baudrateMeter;
    private PixelFormat pixelFormat;
    private boolean needSendPixelFormat;

    public ReceiverTask(Transport transport, IRepaintController repaintController, ClipboardController clipboardController, Protocol protocol, BaudrateMeter baudrateMeter) {
        this.transport = transport;
        this.repaintController = repaintController;
        this.clipboardController = clipboardController;
        this.protocol = protocol;
        this.baudrateMeter = baudrateMeter;
        this.renderer = repaintController.createRenderer(transport, protocol.getFbWidth(), protocol.getFbHeight(), protocol.getPixelFormat());
        this.fullscreenFbUpdateIncrementalRequest = new FramebufferUpdateRequestMessage(0, 0, protocol.getFbWidth(), protocol.getFbHeight(), true);
    }

    @Override
    public void run() {
        this.isRunning = true;
        block11: while (this.isRunning) {
            try {
                byte messageId = this.transport.readByte();
                switch (messageId) {
                    case 0: {
                        this.framebufferUpdateMessage();
                        continue block11;
                    }
                    case 1: {
                        logger.severe("Server message SetColorMapEntries is not implemented. Skip.");
                        this.setColorMapEntries();
                        continue block11;
                    }
                    case 2: {
                        logger.fine("Server message: Bell");
                        System.out.print("\u00007");
                        System.out.flush();
                        continue block11;
                    }
                    case 3: {
                        logger.fine("Server message: CutText (3)");
                        this.serverCutText();
                        continue block11;
                    }
                }
                logger.severe(new StringBuilder(37).append("Unsupported server message. Id = ").append(messageId).toString());
            }
            catch (TransportException e) {
                if (this.isRunning) {
                    String string = String.valueOf(e.getMessage());
                    logger.severe(string.length() != 0 ? "Close session: ".concat(string) : new String("Close session: "));
                    this.protocol.cleanUpSession("Connection closed.");
                }
                this.stopTask();
            }
            catch (ProtocolException e) {
                logger.severe(e.getMessage());
                if (this.isRunning) {
                    this.protocol.cleanUpSession(String.valueOf(e.getMessage()).concat("\nConnection closed."));
                }
                this.stopTask();
            }
            catch (CommonException e) {
                logger.severe(e.getMessage());
                if (this.isRunning) {
                    this.protocol.cleanUpSession("Connection closed..");
                }
                this.stopTask();
            }
            catch (Throwable te) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                te.printStackTrace(pw);
                if (this.isRunning) {
                    String string = String.valueOf(te.getMessage());
                    String string2 = String.valueOf(sw.toString());
                    this.protocol.cleanUpSession(new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("\n").append(string2).toString());
                }
                this.stopTask();
            }
        }
    }

    private void setColorMapEntries() throws TransportException {
        this.transport.readByte();
        this.transport.readUInt16();
        int length = this.transport.readUInt16();
        while (length-- > 0) {
            this.transport.readUInt16();
            this.transport.readUInt16();
            this.transport.readUInt16();
        }
    }

    private void serverCutText() throws TransportException {
        this.transport.readByte();
        this.transport.readInt16();
        long length = this.transport.readInt32();
        if (0L == length) {
            return;
        }
        if (length > Integer.MAX_VALUE) {
            this.clipboardController.updateSystemClipboard(this.transport.readBytes(Integer.MAX_VALUE));
            this.clipboardController.updateSystemClipboard(this.transport.readBytes((int)(length - Integer.MAX_VALUE)));
        } else {
            this.clipboardController.updateSystemClipboard(this.transport.readBytes((int)length));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void framebufferUpdateMessage() throws CommonException {
        this.transport.skip(1);
        int numberOfRectangles = this.transport.readUInt16();
        while (numberOfRectangles-- > 0) {
            FramebufferUpdateRectangle rect = new FramebufferUpdateRectangle();
            rect.fill(this.transport);
            Decoder decoder = this.protocol.getDecoderByType(rect.getEncodingType());
            if (decoder != null) {
                try {
                    if (this.baudrateMeter != null) {
                        this.baudrateMeter.startMeasuringCycle();
                    }
                    decoder.decode(this.transport, this.renderer, rect);
                }
                finally {
                    if (this.baudrateMeter != null) {
                        this.baudrateMeter.stopMeasuringCycle();
                    }
                }
                if (EncodingType.RICH_CURSOR == rect.getEncodingType() || EncodingType.CURSOR_POS == rect.getEncodingType()) {
                    this.repaintController.repaintCursor();
                    continue;
                }
                if (rect.getEncodingType() == EncodingType.DESKTOP_SIZE) {
                    ReceiverTask receiverTask = this;
                    synchronized (receiverTask) {
                        this.fullscreenFbUpdateIncrementalRequest = new FramebufferUpdateRequestMessage(0, 0, rect.width, rect.height, true);
                    }
                    this.renderer = this.repaintController.createRenderer(this.transport, rect.width, rect.height, this.protocol.getPixelFormat());
                    this.protocol.sendMessage(new FramebufferUpdateRequestMessage(0, 0, rect.width, rect.height, false));
                    continue;
                }
                this.repaintController.repaintBitmap(rect);
                continue;
            }
            String string = String.valueOf(rect.toString());
            throw new CommonException(string.length() != 0 ? "Unprocessed encoding: ".concat(string) : new String("Unprocessed encoding: "));
        }
        ReceiverTask receiverTask = this;
        synchronized (receiverTask) {
            if (this.needSendPixelFormat) {
                this.needSendPixelFormat = false;
                this.protocol.setPixelFormat(this.pixelFormat);
                this.protocol.sendMessage(new SetPixelFormatMessage(this.pixelFormat));
                String string = String.valueOf(this.pixelFormat);
                logger.fine(new StringBuilder(6 + String.valueOf(string).length()).append("sent: ").append(string).toString());
                this.protocol.sendRefreshMessage();
                logger.fine("sent: nonincremental fb update");
            } else {
                this.protocol.sendMessage(this.fullscreenFbUpdateIncrementalRequest);
            }
        }
    }

    public synchronized void queueUpdatePixelFormat(PixelFormat pf) {
        this.pixelFormat = pf;
        this.needSendPixelFormat = true;
    }

    public void stopTask() {
        this.isRunning = false;
    }
}

