/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.viewer.mac;

import com.glavsoft.exceptions.CommonException;
import com.glavsoft.utils.LazyLoaded;
import java.awt.Image;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class MacApplicationWrapper {
    private final Object applicationInstance;
    private static final LazyLoaded<Class<?>> applicationClass = new LazyLoaded(new LazyLoaded.Loader<Class<?>>(){

        @Override
        public Class<?> load() throws ClassNotFoundException {
            return Class.forName("com.apple.eawt.Application");
        }
    });
    private static final LazyLoaded<Method> getApplicationMethod = new LazyLoaded<Method>(new LazyLoaded.Loader<Method>(){

        @Override
        public Method load() throws NoSuchMethodException {
            return ((Class)applicationClass.get()).getMethod("getApplication", new Class[0]);
        }
    });
    private static final LazyLoaded<Method> setDockIconImageMethod = new LazyLoaded<Method>(new LazyLoaded.Loader<Method>(){

        @Override
        public Method load() throws Throwable {
            return ((Class)applicationClass.get()).getMethod("setDockIconImage", Image.class);
        }
    });
    private static final LazyLoaded<Method> setEnabledAboutMenuMethod = new LazyLoaded<Method>(new LazyLoaded.Loader<Method>(){

        @Override
        public Method load() throws Throwable {
            return ((Class)applicationClass.get()).getMethod("setEnabledAboutMenu", Boolean.TYPE);
        }
    });

    private MacApplicationWrapper(Object applicationInstance) {
        this.applicationInstance = applicationInstance;
    }

    public static MacApplicationWrapper getApplication() throws CommonException {
        try {
            return new MacApplicationWrapper(getApplicationMethod.get().invoke(null, new Object[0]));
        }
        catch (IllegalAccessException e) {
            String string = String.valueOf(e.getMessage());
            throw new CommonException(string.length() != 0 ? "Cannot invoke com.apple.eawt.Application.getApplication: ".concat(string) : new String("Cannot invoke com.apple.eawt.Application.getApplication: "));
        }
        catch (InvocationTargetException e) {
            String string = String.valueOf(e.getMessage());
            throw new CommonException(string.length() != 0 ? "Cannot invoke com.apple.eawt.Application.getApplication: ".concat(string) : new String("Cannot invoke com.apple.eawt.Application.getApplication: "));
        }
    }

    public void setDockIconImage(Image icon) throws CommonException {
        if (null == icon) {
            throw new CommonException("Icon null");
        }
        try {
            setDockIconImageMethod.get().invoke(this.applicationInstance, icon);
        }
        catch (IllegalAccessException e) {
            String string = String.valueOf(e.getMessage());
            throw new CommonException(string.length() != 0 ? "Cannot invoke com.apple.eawt.Application.setDockIconImage: ".concat(string) : new String("Cannot invoke com.apple.eawt.Application.setDockIconImage: "));
        }
        catch (InvocationTargetException e) {
            String string = String.valueOf(e.getMessage());
            throw new CommonException(string.length() != 0 ? "Cannot invoke com.apple.eawt.Application.setDockIconImage: ".concat(string) : new String("Cannot invoke com.apple.eawt.Application.setDockIconImage: "));
        }
    }

    public void setEnabledAboutMenu(boolean enable) throws CommonException {
        try {
            setEnabledAboutMenuMethod.get().invoke(this.applicationInstance, enable);
        }
        catch (IllegalAccessException e) {
            String string = String.valueOf(e.getMessage());
            throw new CommonException(string.length() != 0 ? "Cannot invoke com.apple.eawt.Application.setEnabledAboutMenu: ".concat(string) : new String("Cannot invoke com.apple.eawt.Application.setEnabledAboutMenu: "));
        }
        catch (InvocationTargetException e) {
            String string = String.valueOf(e.getMessage());
            throw new CommonException(string.length() != 0 ? "Cannot invoke com.apple.eawt.Application.setEnabledAboutMenu: ".concat(string) : new String("Cannot invoke com.apple.eawt.Application.setEnabledAboutMenu: "));
        }
    }
}

