/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.viewer.swing.ssh;

import com.glavsoft.utils.Strings;
import com.glavsoft.viewer.swing.Utils;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

class SwingSshUserInfo
implements UserInfo,
UIKeyboardInteractive {
    private String password;
    private String passphrase;
    private final JFrame parentFrame;

    SwingSshUserInfo(JFrame parentFrame) {
        this.parentFrame = parentFrame;
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean promptPassword(final String message) {
        final int[] result = new int[1];
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    final JPasswordField passwordField = new JPasswordField(20);
                    Object[] ob = new Object[]{message, passwordField};
                    JOptionPane pane = new JOptionPane(ob, 3, 2);
                    JDialog dialog = pane.createDialog(SwingSshUserInfo.this.parentFrame, "SSH Authentication");
                    Utils.decorateDialog(dialog);
                    dialog.addWindowFocusListener(new WindowAdapter(){

                        @Override
                        public void windowGainedFocus(WindowEvent e) {
                            passwordField.requestFocusInWindow();
                        }
                    });
                    dialog.setVisible(true);
                    int n = result[0] = pane.getValue() != null ? (Integer)pane.getValue() : -1;
                    if (0 == result[0]) {
                        SwingSshUserInfo.this.password = ((JTextComponent)passwordField).getText();
                    }
                    dialog.dispose();
                }
            });
        }
        catch (InterruptedException e) {
            this.getLogger().severe(e.getMessage());
        }
        catch (InvocationTargetException e) {
            this.getLogger().severe(e.getMessage());
        }
        return 0 == result[0];
    }

    public boolean promptPassphrase(final String message) {
        final int[] result = new int[1];
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    JPasswordField passphraseField = new JPasswordField(20);
                    Object[] ob = new Object[]{message, passphraseField};
                    JOptionPane pane = new JOptionPane(ob, 3, 2);
                    JDialog dialog = pane.createDialog(SwingSshUserInfo.this.parentFrame, "SSH Authentication");
                    Utils.decorateDialog(dialog);
                    dialog.setVisible(true);
                    int n = result[0] = pane.getValue() != null ? (Integer)pane.getValue() : -1;
                    if (0 == result[0]) {
                        SwingSshUserInfo.this.passphrase = ((JTextComponent)passphraseField).getText();
                    }
                    dialog.dispose();
                }
            });
        }
        catch (InterruptedException e) {
            this.getLogger().severe(e.getMessage());
        }
        catch (InvocationTargetException e) {
            this.getLogger().severe(e.getMessage());
        }
        return 0 == result[0];
    }

    public boolean promptYesNo(final String message) {
        final int[] result = new int[1];
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    result[0] = JOptionPane.showConfirmDialog(SwingSshUserInfo.this.parentFrame, message, "SSH: Warning", 0, 2);
                }
            });
        }
        catch (InterruptedException e) {
            this.getLogger().severe(e.getMessage());
        }
        catch (InvocationTargetException e) {
            this.getLogger().severe(e.getMessage());
        }
        return 0 == result[0];
    }

    public void showMessage(final String message) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(SwingSshUserInfo.this.parentFrame, message, "SSH", 1);
                }
            });
        }
        catch (InterruptedException e) {
            this.getLogger().severe(e.getMessage());
        }
        catch (InvocationTargetException e) {
            this.getLogger().severe(e.getCause().getMessage());
        }
    }

    public String[] promptKeyboardInteractive(final String destination, final String name, final String instruction, final String[] prompt, final boolean[] echo) {
        class WrapRes {
            String[] stringsRes;

            WrapRes() {
            }
        }
        final WrapRes wrapRes = new WrapRes();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){
                {
                }

                @Override
                public void run() {
                    String string;
                    JPanel panel = new JPanel();
                    panel.setLayout(new GridBagLayout());
                    GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
                    gbc.weightx = 1.0;
                    gbc.gridwidth = 0;
                    gbc.gridx = 0;
                    panel.add((Component)new JLabel(instruction), gbc);
                    ++gbc.gridy;
                    gbc.gridwidth = -1;
                    JTextField[] texts = new JTextField[prompt.length];
                    for (int i = 0; i < prompt.length; ++i) {
                        gbc.fill = 0;
                        gbc.gridx = 0;
                        gbc.weightx = 1.0;
                        panel.add((Component)new JLabel(prompt[i]), gbc);
                        gbc.gridx = 1;
                        gbc.fill = 2;
                        gbc.weighty = 1.0;
                        texts[i] = echo[i] ? new JTextField(20) : new JPasswordField(20);
                        panel.add((Component)texts[i], gbc);
                        ++gbc.gridy;
                    }
                    String string2 = destination;
                    if (Strings.isTrimmedEmpty(name)) {
                        string = "";
                    } else {
                        String string3 = String.valueOf(name);
                        string = string3.length() != 0 ? ": ".concat(string3) : new String(": ");
                    }
                    String string4 = string;
                    String title = new StringBuilder(23 + String.valueOf(string2).length() + String.valueOf(string4).length()).append("SSH authentication for ").append(string2).append(string4).toString();
                    JOptionPane pane = new JOptionPane(panel, 3, 2);
                    JDialog dialog = pane.createDialog(SwingSshUserInfo.this.parentFrame, title);
                    Utils.decorateDialog(dialog);
                    dialog.setVisible(true);
                    int result = pane.getValue() != null ? (Integer)pane.getValue() : -1;
                    wrapRes.stringsRes = null;
                    if (0 == result) {
                        wrapRes.stringsRes = new String[prompt.length];
                        for (int i = 0; i < prompt.length; ++i) {
                            wrapRes.stringsRes[i] = texts[i].getText();
                        }
                    }
                    dialog.dispose();
                }
            });
        }
        catch (InterruptedException e) {
            this.getLogger().severe(e.getMessage());
        }
        catch (InvocationTargetException e) {
            this.getLogger().severe(e.getMessage());
        }
        return wrapRes.stringsRes;
    }

    private Logger getLogger() {
        return Logger.getLogger(this.getClass().getName());
    }
}

