/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.visualstudio.internal;

import java.io.File;
import java.util.List;
import org.gradle.api.file.FileCollection;

public interface VisualStudioTargetBinary {
    public String getProjectPath();

    public String getComponentName();

    public ProjectType getProjectType();

    public List<String> getVariantDimensions();

    public FileCollection getSourceFiles();

    public FileCollection getResourceFiles();

    public FileCollection getHeaderFiles();

    public boolean isExecutable();

    public String getBuildTaskPath();

    public String getCleanTaskPath();

    public boolean isDebuggable();

    public File getOutputFile();

    public List<String> getCompilerDefines();

    public List<File> getIncludePaths();

    public Iterable<VisualStudioTargetBinary> getDependencies();

    public static enum ProjectType {
        EXE("Exe"),
        LIB("Lib"),
        DLL("Dll"),
        NONE("");

        private final String suffix;

        private ProjectType(String suffix) {
            this.suffix = suffix;
        }

        public String getSuffix() {
            return this.suffix;
        }
    }
}

