/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.visualstudio.plugins;

import javax.inject.Inject;
import org.gradle.api.Incubating;
import org.gradle.api.Project;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.ide.visualstudio.VisualStudioExtension;
import org.gradle.ide.visualstudio.VisualStudioRootExtension;
import org.gradle.ide.visualstudio.internal.DefaultVisualStudioExtension;
import org.gradle.ide.visualstudio.internal.DefaultVisualStudioRootExtension;
import org.gradle.ide.visualstudio.plugins.VisualStudioPluginRules;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.language.base.plugins.LifecycleBasePlugin;
import org.gradle.nativeplatform.plugins.NativeComponentModelPlugin;
import org.gradle.plugins.ide.internal.IdePlugin;

@Incubating
public class VisualStudioPlugin
extends IdePlugin {
    private static final String LIFECYCLE_TASK_NAME = "visualStudio";
    private final Instantiator instantiator;
    private final FileResolver fileResolver;

    @Inject
    public VisualStudioPlugin(Instantiator instantiator, FileResolver fileResolver) {
        this.instantiator = instantiator;
        this.fileResolver = fileResolver;
    }

    protected String getLifecycleTaskName() {
        return LIFECYCLE_TASK_NAME;
    }

    protected void onApply(Project target) {
        this.project.getPluginManager().apply(LifecycleBasePlugin.class);
        if (this.isRoot()) {
            VisualStudioRootExtension extension = (VisualStudioRootExtension)this.project.getExtensions().create(VisualStudioRootExtension.class, LIFECYCLE_TASK_NAME, DefaultVisualStudioRootExtension.class, new Object[]{this.project.getName(), this.instantiator, this.fileResolver, this});
            this.getLifecycleTask().dependsOn(new Object[]{extension.getSolution()});
        } else {
            VisualStudioExtension extension = (VisualStudioExtension)this.project.getExtensions().create(VisualStudioExtension.class, LIFECYCLE_TASK_NAME, DefaultVisualStudioExtension.class, new Object[]{this.instantiator, this.fileResolver, this});
            this.getLifecycleTask().dependsOn(new Object[]{extension.getProjects()});
        }
        this.project.getPluginManager().apply(NativeComponentModelPlugin.class);
        this.project.getPluginManager().apply(VisualStudioPluginRules.class);
    }
}

