/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.visualstudio.plugins;

import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.internal.project.ProjectIdentifier;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectRegistry;
import org.gradle.api.internal.resolve.ProjectModelResolver;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.ide.visualstudio.VisualStudioExtension;
import org.gradle.ide.visualstudio.VisualStudioProject;
import org.gradle.ide.visualstudio.VisualStudioRootExtension;
import org.gradle.ide.visualstudio.VisualStudioSolution;
import org.gradle.ide.visualstudio.internal.DefaultVisualStudioProject;
import org.gradle.ide.visualstudio.internal.NativeSpecVisualStudioTargetBinary;
import org.gradle.ide.visualstudio.internal.VisualStudioExtensionInternal;
import org.gradle.ide.visualstudio.internal.VisualStudioProjectInternal;
import org.gradle.ide.visualstudio.internal.VisualStudioSolutionInternal;
import org.gradle.ide.visualstudio.tasks.GenerateFiltersFileTask;
import org.gradle.ide.visualstudio.tasks.GenerateProjectFileTask;
import org.gradle.ide.visualstudio.tasks.GenerateSolutionFileTask;
import org.gradle.internal.Cast;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.model.Model;
import org.gradle.model.Mutate;
import org.gradle.model.RuleSource;
import org.gradle.nativeplatform.NativeBinarySpec;
import org.gradle.platform.base.BinaryContainer;

class VisualStudioPluginRules
extends RuleSource {
    VisualStudioPluginRules() {
    }

    @Model
    public static VisualStudioExtensionInternal visualStudio(ExtensionContainer extensionContainer) {
        return (VisualStudioExtensionInternal)extensionContainer.getByType(VisualStudioExtension.class);
    }

    @Mutate
    public static void includeBuildFileInProject(VisualStudioExtensionInternal visualStudio, final ProjectIdentifier projectIdentifier) {
        visualStudio.getProjects().all((Action)new Action<VisualStudioProject>(){

            public void execute(VisualStudioProject project) {
                if (projectIdentifier.getBuildFile() != null) {
                    ((DefaultVisualStudioProject)project).addSourceFile(projectIdentifier.getBuildFile());
                }
            }
        });
    }

    @Mutate
    public static void createVisualStudioModelForBinaries(VisualStudioExtensionInternal visualStudioExtension, BinaryContainer binaries, ProjectIdentifier projectIdentifier, ServiceRegistry serviceRegistry) {
        for (NativeBinarySpec binary : binaries.withType(NativeBinarySpec.class)) {
            visualStudioExtension.getProjectRegistry().addProjectConfiguration(new NativeSpecVisualStudioTargetBinary(binary));
        }
        if (VisualStudioPluginRules.isRoot(projectIdentifier)) {
            VisualStudioPluginRules.ensureSubprojectsAreRealized(projectIdentifier, serviceRegistry);
        }
    }

    @Mutate
    public static void createTasksForVisualStudio(TaskContainer tasks, VisualStudioExtensionInternal visualStudioExtension, ProjectIdentifier projectIdentifier) {
        for (VisualStudioProject vsProject : visualStudioExtension.getProjects()) {
            ((VisualStudioProjectInternal)vsProject).builtBy(VisualStudioPluginRules.createProjectsFileTask(tasks, vsProject), VisualStudioPluginRules.createFiltersFileTask(tasks, vsProject));
            Task lifecycleTask = (Task)tasks.maybeCreate(((VisualStudioProjectInternal)vsProject).getComponentName() + "VisualStudio");
            lifecycleTask.dependsOn(new Object[]{vsProject});
        }
        if (VisualStudioPluginRules.isRoot(projectIdentifier)) {
            VisualStudioRootExtension rootExtension = (VisualStudioRootExtension)((Object)visualStudioExtension);
            VisualStudioSolutionInternal vsSolution = (VisualStudioSolutionInternal)rootExtension.getSolution();
            vsSolution.builtBy(VisualStudioPluginRules.createSolutionTask(tasks, vsSolution));
        }
        VisualStudioPluginRules.addCleanTask(tasks);
    }

    private static void ensureSubprojectsAreRealized(ProjectIdentifier projectIdentifier, ServiceRegistry serviceRegistry) {
        ProjectModelResolver projectModelResolver = (ProjectModelResolver)serviceRegistry.get(ProjectModelResolver.class);
        ProjectRegistry projectRegistry = (ProjectRegistry)Cast.uncheckedCast((Object)serviceRegistry.get(ProjectRegistry.class));
        for (ProjectInternal subproject : projectRegistry.getSubProjects(projectIdentifier.getPath())) {
            projectModelResolver.resolveProjectModel(subproject.getPath()).find("visualStudio", VisualStudioExtension.class);
        }
    }

    private static boolean isRoot(ProjectIdentifier projectIdentifier) {
        return projectIdentifier.getParentIdentifier() == null;
    }

    private static void addCleanTask(TaskContainer tasks) {
        Delete cleanTask = (Delete)tasks.maybeCreate("cleanVisualStudio", Delete.class);
        for (Task task : tasks.withType(GenerateSolutionFileTask.class)) {
            cleanTask.delete(new Object[]{task.getOutputs().getFiles()});
        }
        for (Task task : tasks.withType(GenerateFiltersFileTask.class)) {
            cleanTask.delete(new Object[]{task.getOutputs().getFiles()});
        }
        for (Task task : tasks.withType(GenerateProjectFileTask.class)) {
            cleanTask.delete(new Object[]{task.getOutputs().getFiles()});
        }
        cleanTask.setGroup("IDE");
        cleanTask.setDescription("Removes all generated Visual Studio project and solution files");
    }

    private static Task createSolutionTask(TaskContainer tasks, VisualStudioSolution solution) {
        GenerateSolutionFileTask solutionFileTask = (GenerateSolutionFileTask)tasks.create(solution.getName() + "VisualStudioSolution", GenerateSolutionFileTask.class);
        solutionFileTask.setVisualStudioSolution(solution);
        return solutionFileTask;
    }

    private static Task createProjectsFileTask(TaskContainer tasks, VisualStudioProject vsProject) {
        GenerateProjectFileTask task = (GenerateProjectFileTask)tasks.create(vsProject.getName() + "VisualStudioProject", GenerateProjectFileTask.class);
        task.setVisualStudioProject(vsProject);
        task.initGradleCommand();
        return task;
    }

    private static Task createFiltersFileTask(TaskContainer tasks, VisualStudioProject vsProject) {
        GenerateFiltersFileTask task = (GenerateFiltersFileTask)tasks.create(vsProject.getName() + "VisualStudioFilters", GenerateFiltersFileTask.class);
        task.setVisualStudioProject(vsProject);
        return task;
    }
}

