/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.studio.appengine.gradle.facet;

import com.google.common.base.Strings;
import com.google.gct.studio.appengine.dom.AppEngineWebApp;
import com.google.gct.studio.appengine.dom.WebApp;
import com.google.gct.studio.appengine.gradle.facet.AppEngineConfigurationProperties;
import com.google.gct.studio.appengine.gradle.facet.AppEngineGradleFacetConfiguration;
import com.google.gct.studio.appengine.sdk.AppEngineSdk;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import java.io.File;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppEngineGradleFacet
extends Facet<AppEngineGradleFacetConfiguration> {
    private static final Logger LOG = Logger.getInstance(AppEngineGradleFacet.class);
    @NonNls
    public static final String ID = "app-engine-gradle";
    @NonNls
    public static final String NAME = "App Engine Gradle";
    public static final FacetTypeId<AppEngineGradleFacet> TYPE_ID = new FacetTypeId("app-engine-gradle");

    @Nullable
    public static AppEngineGradleFacet getInstance(@NotNull Module module) {
        if (module == null) {
            AppEngineGradleFacet.$$$reportNull$$$0(0);
        }
        return (AppEngineGradleFacet)FacetManager.getInstance((Module)module).getFacetByType(TYPE_ID);
    }

    public AppEngineGradleFacet(@NotNull FacetType facetType, @NotNull Module module, @NotNull String name, @NotNull AppEngineGradleFacetConfiguration configuration) {
        if (facetType == null) {
            AppEngineGradleFacet.$$$reportNull$$$0(1);
        }
        if (module == null) {
            AppEngineGradleFacet.$$$reportNull$$$0(2);
        }
        if (name == null) {
            AppEngineGradleFacet.$$$reportNull$$$0(3);
        }
        if (configuration == null) {
            AppEngineGradleFacet.$$$reportNull$$$0(4);
        }
        super(facetType, module, name, (FacetConfiguration)configuration, null);
    }

    public AppEngineWebApp getAppEngineWebXml() {
        XmlFile appEngineXmlFile = this.getAppEngineXmlFile("appengine-web.xml");
        DomManager domManager = DomManager.getDomManager((Project)this.getModule().getProject());
        return (AppEngineWebApp)domManager.getFileElement(appEngineXmlFile, AppEngineWebApp.class).getRootElement();
    }

    @Nullable
    public AppEngineSdk getAppEngineSdk() {
        AppEngineConfigurationProperties state = ((AppEngineGradleFacetConfiguration)this.getConfiguration()).getState();
        if (state != null) {
            String sdkRoot = state.APPENGINE_SDKROOT;
            return new AppEngineSdk(sdkRoot);
        }
        return null;
    }

    @Nullable
    private XmlFile getAppEngineXmlFile(@NotNull String fileName) {
        AppEngineConfigurationProperties model;
        if (fileName == null) {
            AppEngineGradleFacet.$$$reportNull$$$0(5);
        }
        if ((model = ((AppEngineGradleFacetConfiguration)this.getConfiguration()).getState()) == null || Strings.isNullOrEmpty((String)model.WEB_APP_DIR)) {
            return null;
        }
        String path = model.WEB_APP_DIR + "/WEB-INF/" + fileName;
        VirtualFile appEngineFile = LocalFileSystem.getInstance().findFileByPath(path.replace(File.separatorChar, '/'));
        if (appEngineFile == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.getModule().getProject()).findFile(appEngineFile);
        if (psiFile == null || !(psiFile instanceof XmlFile)) {
            return null;
        }
        return (XmlFile)psiFile;
    }

    @Nullable
    public WebApp getWebXml() {
        XmlFile webXmlFile = this.getAppEngineXmlFile("web.xml");
        return this.getDomElement(webXmlFile, WebApp.class);
    }

    @NotNull
    public WebApp getWebXmlForEdit() {
        XmlFile webXmlFile = this.getAppEngineXmlFile("web.xml");
        ReadonlyStatusHandler.getInstance((Project)this.getModule().getProject()).ensureFilesWritable(new VirtualFile[]{webXmlFile.getVirtualFile()});
        WebApp webApp = this.getDomElement(webXmlFile, WebApp.class);
        if (webApp == null) {
            AppEngineGradleFacet.$$$reportNull$$$0(6);
        }
        return webApp;
    }

    private <T extends DomElement> T getDomElement(XmlFile xmlFile, Class<T> domClass) {
        DomManager domManager = DomManager.getDomManager((Project)this.getModule().getProject());
        return (T)domManager.getFileElement(xmlFile, domClass).getRootElement();
    }

    public static FacetType<AppEngineGradleFacet, AppEngineGradleFacetConfiguration> getFacetType() {
        return FacetTypeRegistry.getInstance().findFacetType(ID);
    }

    @Nullable
    public static AppEngineGradleFacet getAppEngineFacetByModule(@Nullable Module module) {
        if (module == null) {
            return null;
        }
        return (AppEngineGradleFacet)FacetManager.getInstance((Module)module).getFacetByType(TYPE_ID);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facetType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/gct/studio/appengine/gradle/facet/AppEngineGradleFacet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/gct/studio/appengine/gradle/facet/AppEngineGradleFacet";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getWebXmlForEdit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAppEngineXmlFile";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

