/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.studio.appengine.gradle.notification;

import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.gct.studio.appengine.gradle.facet.AppEngineConfigurationProperties;
import com.google.gct.studio.appengine.gradle.facet.AppEngineGradleFacet;
import com.google.gct.studio.appengine.gradle.facet.AppEngineGradleFacetConfiguration;
import com.google.gct.studio.util.GctStudioBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import java.io.File;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppEngineStatusNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Logger LOG = Logger.getInstance(AppEngineStatusNotificationProvider.class);
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"appengine.sdk.status");
    @NotNull
    private final Project myProject;

    public AppEngineStatusNotificationProvider(@NotNull Project project) {
        if (project == null) {
            AppEngineStatusNotificationProvider.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            AppEngineStatusNotificationProvider.$$$reportNull$$$0(1);
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        AppEngineConfigurationProperties state;
        Module module;
        if (file == null) {
            AppEngineStatusNotificationProvider.$$$reportNull$$$0(2);
        }
        if (fileEditor == null) {
            AppEngineStatusNotificationProvider.$$$reportNull$$$0(3);
        }
        if ((module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)this.myProject)) == null) {
            return null;
        }
        AppEngineGradleFacet facet = AppEngineGradleFacet.getInstance(module);
        if (facet != null && (state = ((AppEngineGradleFacetConfiguration)facet.getConfiguration()).getState()) != null && !new File(state.APPENGINE_SDKROOT).exists()) {
            return new DownloadSdkNotification(module);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/gct/studio/appengine/gradle/notification/AppEngineStatusNotificationProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/gct/studio/appengine/gradle/notification/AppEngineStatusNotificationProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class DownloadSdkNotification
    extends EditorNotificationPanel {
        DownloadSdkNotification(Module module) {
            if (module == null) {
                DownloadSdkNotification.$$$reportNull$$$0(0);
            }
            this.setText(GctStudioBundle.message("appengine.sdk.invalid", module.getName()));
            this.createActionLabel(GctStudioBundle.message("appengine.sdk.gradle.install", new Object[0]), new Runnable(){

                @Override
                public void run() {
                    GradleBuildInvoker.getInstance((Project)AppEngineStatusNotificationProvider.this.myProject).executeTasks(Collections.singletonList("appengineDownloadSdk"));
                }
            });
            final VirtualFile buildFile = GradleUtil.getGradleBuildFile((Module)module);
            if (buildFile != null && buildFile.exists()) {
                this.createActionLabel(GctStudioBundle.message("appengine.sdk.open.gradle.build", new Object[0]), new Runnable(){

                    @Override
                    public void run() {
                        FileEditorManager.getInstance((Project)AppEngineStatusNotificationProvider.this.myProject).openFile(buildFile, true);
                    }
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/google/gct/studio/appengine/gradle/notification/AppEngineStatusNotificationProvider$DownloadSdkNotification", "<init>"));
        }
    }
}

