/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.studio.appengine.gradle.service;

import com.android.tools.idea.gradle.project.sync.idea.data.service.AndroidProjectKeys;
import com.google.common.collect.Maps;
import com.google.gct.login.stats.UsageTrackerService;
import com.google.gct.studio.appengine.gradle.project.IdeaAppEngineProject;
import com.google.gct.studio.appengine.gradle.service.AppEngineGradleProjectSetup;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppEngineGradleProjectDataService
extends AbstractProjectDataService<IdeaAppEngineProject, Void> {
    private static final Logger LOG = Logger.getInstance(AppEngineGradleProjectDataService.class);
    @NotNull
    public static final Key<IdeaAppEngineProject> IDE_APP_ENGINE_PROJECT = Key.create(IdeaAppEngineProject.class, (int)(AndroidProjectKeys.IMPORTED_MODULE.getProcessingWeight() + 10));
    private NotificationGroup myLoggingNotification;

    @NotNull
    public Key<IdeaAppEngineProject> getTargetDataKey() {
        Key<IdeaAppEngineProject> key = IDE_APP_ENGINE_PROJECT;
        if (key == null) {
            AppEngineGradleProjectDataService.$$$reportNull$$$0(0);
        }
        return key;
    }

    public void importData(final @NotNull Collection<DataNode<IdeaAppEngineProject>> toImport, @Nullable ProjectData projectData, @NotNull Project project, final @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            AppEngineGradleProjectDataService.$$$reportNull$$$0(1);
        }
        if (project == null) {
            AppEngineGradleProjectDataService.$$$reportNull$$$0(2);
        }
        if (modelsProvider == null) {
            AppEngineGradleProjectDataService.$$$reportNull$$$0(3);
        }
        if (toImport.isEmpty()) {
            return;
        }
        RunResult result = new WriteCommandAction.Simple(project, new PsiFile[0]){

            protected void run() throws Throwable {
                Map importModulesMap = AppEngineGradleProjectDataService.indexByModuleName(toImport);
                for (Module module : modelsProvider.getModules()) {
                    if (!importModulesMap.containsKey(module.getName())) continue;
                    AppEngineGradleProjectSetup.addAppEngineGradleFacet((IdeaAppEngineProject)importModulesMap.get(module.getName()), module, modelsProvider);
                    AppEngineGradleProjectSetup.addAppEngineRunConfiguration(module);
                    UsageTrackerService.getInstance().trackEvent("com.google.cloud.tools", "appengine.gradle.import", null, null);
                }
            }
        }.execute();
        Throwable error = result.getThrowable();
        if (error != null) {
            LOG.warn("Failed to set up App Engine Gradle Modules");
            this.syncFailed(project, error.getMessage());
        }
    }

    public void syncFailed(@NotNull Project project, @NotNull String message) {
        if (project == null) {
            AppEngineGradleProjectDataService.$$$reportNull$$$0(4);
        }
        if (message == null) {
            AppEngineGradleProjectDataService.$$$reportNull$$$0(5);
        }
        String logMsg = "Gradle sync failed";
        if (StringUtil.isNotEmpty((String)message)) {
            logMsg = logMsg + String.format(": %1$s", message);
        }
        this.addToEventLog(project, logMsg, MessageType.ERROR);
    }

    private void addToEventLog(@NotNull Project project, @NotNull String message, @NotNull MessageType type) {
        if (project == null) {
            AppEngineGradleProjectDataService.$$$reportNull$$$0(6);
        }
        if (message == null) {
            AppEngineGradleProjectDataService.$$$reportNull$$$0(7);
        }
        if (type == null) {
            AppEngineGradleProjectDataService.$$$reportNull$$$0(8);
        }
        this.getLoggingNotification().createNotification(message, type).notify(project);
    }

    private synchronized NotificationGroup getLoggingNotification() {
        if (this.myLoggingNotification == null) {
            NotificationGroup registeredGroup = NotificationGroup.findRegisteredGroup((String)"Gradle sync");
            this.myLoggingNotification = registeredGroup != null ? registeredGroup : NotificationGroup.logOnlyGroup((String)"Gradle sync");
        }
        return this.myLoggingNotification;
    }

    @NotNull
    private static Map<String, IdeaAppEngineProject> indexByModuleName(@NotNull Collection<DataNode<IdeaAppEngineProject>> dataNodes) {
        if (dataNodes == null) {
            AppEngineGradleProjectDataService.$$$reportNull$$$0(9);
        }
        HashMap index = Maps.newHashMap();
        for (DataNode<IdeaAppEngineProject> d : dataNodes) {
            IdeaAppEngineProject appEngineProject = (IdeaAppEngineProject)d.getData();
            index.put(appEngineProject.getModuleName(), appEngineProject);
        }
        HashMap hashMap = index;
        if (hashMap == null) {
            AppEngineGradleProjectDataService.$$$reportNull$$$0(10);
        }
        return hashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/gct/studio/appengine/gradle/service/AppEngineGradleProjectDataService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toImport";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetDataKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/gct/studio/appengine/gradle/service/AppEngineGradleProjectDataService";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "indexByModuleName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "importData";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "syncFailed";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addToEventLog";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "indexByModuleName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

