/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.studio.samples;

import com.appspot.gsamplesindex.samplesindex.model.Sample;
import com.appspot.gsamplesindex.samplesindex.model.SampleCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.treeStructure.Tree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SampleImportTreeManager {
    private final SampleCollection mySamples;
    private final Tree myTree;
    private final Map<DefaultMutableTreeNode, Sample> mySampleMap;
    private final Map<String, String> myFormattedNameMap;
    private final Map<String, DefaultMutableTreeNode> myCategoryMap;
    private final Map<String, List<DefaultMutableTreeNode>> myCategorySampleNodeMap;

    public SampleImportTreeManager(@NotNull Tree tree, @NotNull SampleCollection samples) {
        if (tree == null) {
            SampleImportTreeManager.$$$reportNull$$$0(0);
        }
        if (samples == null) {
            SampleImportTreeManager.$$$reportNull$$$0(1);
        }
        this.mySampleMap = new HashMap<DefaultMutableTreeNode, Sample>();
        this.myFormattedNameMap = new HashMap<String, String>();
        this.myCategoryMap = new TreeMap<String, DefaultMutableTreeNode>();
        this.myCategorySampleNodeMap = new HashMap<String, List<DefaultMutableTreeNode>>();
        this.myTree = tree;
        this.mySamples = samples;
        this.init();
    }

    private void init() {
        for (Sample sample : this.mySamples.getItems()) {
            if (StringUtil.isEmpty((String)sample.getTitle())) continue;
            String formattedName = SampleImportTreeManager.formatName(sample.getTitle());
            this.myFormattedNameMap.put(sample.getTitle(), formattedName);
            for (String category : sample.getCategories()) {
                DefaultMutableTreeNode sampleNode = new DefaultMutableTreeNode(formattedName);
                this.mySampleMap.put(sampleNode, sample);
                if (!this.myCategoryMap.containsKey(category)) {
                    DefaultMutableTreeNode categoryNode = new DefaultMutableTreeNode(StringUtil.capitalize((String)category));
                    this.myCategoryMap.put(category, categoryNode);
                }
                if (!this.myCategorySampleNodeMap.containsKey(category)) {
                    this.myCategorySampleNodeMap.put(category, new ArrayList());
                }
                this.myCategorySampleNodeMap.get(category).add(sampleNode);
            }
        }
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Samples");
        DefaultTreeModel treeModel = new DefaultTreeModel(root);
        this.myTree.setModel((TreeModel)treeModel);
        this.myTree.setEditable(false);
        this.myTree.getSelectionModel().setSelectionMode(1);
        this.myTree.setRootVisible(false);
        this.populateSamplesTree(this.mySamples.getItems(), true);
    }

    static String formatName(String name) {
        if (StringUtil.isEmpty((String)name) || name.trim().isEmpty()) {
            return "Unnamed";
        }
        name = name.replace("-", " - ");
        StringBuilder sb = new StringBuilder(2 * name.length());
        int n = name.length();
        boolean lastWasLowerCase = Character.isLowerCase(name.charAt(0));
        for (int i = 0; i < n; ++i) {
            char c = name.charAt(i);
            boolean isUpperCase = Character.isUpperCase(c);
            if (isUpperCase && lastWasLowerCase) {
                sb.append(' ');
            }
            lastWasLowerCase = Character.isLetter(c) && !isUpperCase;
            sb.append(c);
        }
        return sb.toString().replaceAll(" +", " ").trim();
    }

    private void populateSamplesTree(@NotNull Collection<Sample> samples, boolean expand) {
        if (samples == null) {
            SampleImportTreeManager.$$$reportNull$$$0(2);
        }
        DefaultTreeModel model = (DefaultTreeModel)this.myTree.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        root.removeAllChildren();
        for (String category : this.myCategoryMap.keySet()) {
            DefaultMutableTreeNode categoryNode = this.myCategoryMap.get(category);
            categoryNode.removeAllChildren();
            for (DefaultMutableTreeNode node : this.myCategorySampleNodeMap.get(category)) {
                if (!samples.contains(this.mySampleMap.get(node))) continue;
                this.myCategoryMap.get(category).add(node);
            }
            if (categoryNode.getChildCount() <= 0) continue;
            root.add(categoryNode);
        }
        model.reload();
        if (expand) {
            for (int i = 0; i < this.myTree.getRowCount(); ++i) {
                this.myTree.expandRow(i);
            }
            try {
                this.myTree.setSelectionPath(new TreePath(root.getFirstLeaf().getPath()));
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
    }

    @Nullable
    public Sample getSelectedSample() {
        DefaultMutableTreeNode selected = (DefaultMutableTreeNode)this.myTree.getLastSelectedPathComponent();
        if (selected == null || !selected.isLeaf()) {
            return null;
        }
        return this.mySampleMap.get(selected);
    }

    @NotNull
    Set<Sample> filterSamples(@NotNull String query) {
        if (query == null) {
            SampleImportTreeManager.$$$reportNull$$$0(3);
        }
        ImmutableSet filteredSamples = new HashSet(this.mySamples.getItems());
        HashSet<Sample> filterByWord = new HashSet<Sample>();
        for (String keyword : query.split(" ")) {
            filterByWord.clear();
            for (Sample sample : this.mySamples.getItems()) {
                if (!this.hasKeyword(sample, keyword)) continue;
                filterByWord.add(sample);
            }
            filteredSamples = Sets.intersection(filteredSamples, filterByWord).immutableCopy();
        }
        ImmutableSet immutableSet = filteredSamples;
        if (immutableSet == null) {
            SampleImportTreeManager.$$$reportNull$$$0(4);
        }
        return immutableSet;
    }

    private boolean hasKeyword(Sample sample, String keyword) {
        if (sample.getTitle() != null && (StringUtil.containsIgnoreCase((String)sample.getTitle(), (String)keyword) || StringUtil.containsIgnoreCase((String)this.myFormattedNameMap.get(sample.getTitle()), (String)keyword))) {
            return true;
        }
        if (sample.getDescription() != null && StringUtil.containsIgnoreCase((String)sample.getDescription(), (String)keyword)) {
            return true;
        }
        for (String category : sample.getCategories()) {
            if (category == null || !StringUtil.containsIgnoreCase((String)category, (String)keyword)) continue;
            return true;
        }
        return false;
    }

    public void filterTree(@NotNull String query) {
        if (query == null) {
            SampleImportTreeManager.$$$reportNull$$$0(5);
        }
        this.populateSamplesTree(this.filterSamples(query), true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "samples";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/gct/studio/samples/SampleImportTreeManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/gct/studio/samples/SampleImportTreeManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "filterSamples";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "populateSamplesTree";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "filterSamples";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "filterTree";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

