/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.studio.samples;

import com.android.tools.idea.gradle.project.importing.GradleProjectImporter;
import com.android.tools.idea.npw.project.AndroidGradleModuleUtils;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.wizard.model.WizardModel;
import com.appspot.gsamplesindex.samplesindex.model.Sample;
import com.google.common.base.Strings;
import com.google.gct.login.stats.UsageTrackerService;
import com.google.gct.studio.samples.GithubRepoContents;
import com.google.gct.studio.util.GctStudioBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public final class SampleModel
extends WizardModel {
    private final OptionalProperty<Sample> mySample = new OptionalValueProperty();
    private final OptionalProperty<String> myProjectName = new OptionalValueProperty();
    private final OptionalProperty<File> myDir = new OptionalValueProperty();

    @NotNull
    public static String trimSlashes(@NotNull String path) {
        if (path == null) {
            SampleModel.$$$reportNull$$$0(0);
        }
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        while (path.startsWith("/")) {
            path = path.substring(1, path.length());
        }
        String string = path;
        if (string == null) {
            SampleModel.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static Logger getLog() {
        return Logger.getInstance(SampleModel.class);
    }

    public OptionalProperty<Sample> sample() {
        return this.mySample;
    }

    public OptionalProperty<String> projectName() {
        return this.myProjectName;
    }

    public OptionalProperty<File> dir() {
        return this.myDir;
    }

    protected void handleFinished() {
        String basePath;
        Project tmpProject;
        String projectName;
        block13: {
            if (!(((Optional)this.mySample.get()).isPresent() && ((Optional)this.myDir.get()).isPresent() && ((Optional)this.myProjectName.get()).isPresent())) {
                SampleModel.getLog().error("SampleImportWizard did not collect expected information and will not complete. Please report this error.");
                return;
            }
            Sample sample = (Sample)this.mySample.getValue();
            File dir = (File)this.myDir.getValue();
            projectName = (String)this.myProjectName.getValue();
            if (!FileUtilRt.createDirectory((File)dir)) {
                Messages.showErrorDialog((String)GctStudioBundle.message("create.project.dir.failed", new Object[0]), (String)GctStudioBundle.message("sample.import.error.title", new Object[0]));
                return;
            }
            tmpProject = ProjectManager.getInstance().createProject(projectName, dir.getAbsolutePath());
            assert (tmpProject != null);
            String url = SampleModel.trimSlashes(sample.getCloneUrl());
            GithubRepoContents downloadResult = GithubRepoContents.download(tmpProject, url, null, null);
            if (downloadResult.isCancelled()) {
                SampleModel.getLog().info("Sample download cancelled by user");
                return;
            }
            String errorMessage = downloadResult.getErrorMessage();
            if (errorMessage != null) {
                SampleModel.getLog().warn(errorMessage);
                Messages.showErrorDialog((String)errorMessage, (String)GctStudioBundle.message("sample.import.error.title", new Object[0]));
                return;
            }
            List<File> sampleRoots = downloadResult.getSampleRoots();
            if (sampleRoots.isEmpty()) {
                Messages.showErrorDialog((String)GctStudioBundle.message("git.project.dir.empty", new Object[0]), (String)GctStudioBundle.message("sample.import.error.title", new Object[0]));
                return;
            }
            File rootFolder = downloadResult.getRootFolder();
            basePath = tmpProject.getBasePath();
            assert (basePath != null);
            try {
                String path = sample.getPath();
                if (!Strings.isNullOrEmpty((String)path)) {
                    path = SampleModel.trimSlashes(path);
                    for (File sampleRoot : sampleRoots) {
                        if (!sampleRoot.getCanonicalPath().equals(new File(rootFolder, path).getCanonicalPath())) continue;
                        FileUtil.copyDir((File)sampleRoot, (File)new File(basePath));
                        break block13;
                    }
                    Messages.showErrorDialog((String)GctStudioBundle.message("git.project.missing.sample.root", path), (String)GctStudioBundle.message("sample.import.error.title", new Object[0]));
                    return;
                }
                FileUtil.copyDir((File)sampleRoots.get(0), (File)new File(basePath));
            }
            catch (IOException e) {
                SampleModel.getLog().error((Throwable)e);
                Messages.showErrorDialog((String)GctStudioBundle.message("sample.copy.to.project.failed", new Object[0]), (String)GctStudioBundle.message("sample.import.error.title", new Object[0]));
                return;
            }
        }
        try {
            AndroidGradleModuleUtils.setGradleWrapperExecutable((File)new File(basePath));
        }
        catch (IOException e) {
            Messages.showWarningDialog((String)GctStudioBundle.message("sample.import.no.gradlew.exec", projectName), (String)GctStudioBundle.message("sample.import.warning.title", new Object[0]));
            SampleModel.getLog().error((Throwable)e);
        }
        UsageTrackerService.getInstance().trackEvent("com.google.cloud.tools", "sample.importer", projectName, null);
        GradleProjectImporter.getInstance().importProject(tmpProject.getBaseDir());
        ApplicationManager.getApplication().runWriteAction(() -> Disposer.dispose((Disposable)tmpProject));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/gct/studio/samples/SampleModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/gct/studio/samples/SampleModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "trimSlashes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "trimSlashes";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

