/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.studio.samples;

import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.InvalidationListener;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.SettableValue;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.core.ObservableString;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.expressions.Expression;
import com.android.tools.idea.observable.expressions.string.StringExpression;
import com.android.tools.idea.observable.expressions.value.TransformOptionalExpression;
import com.android.tools.idea.observable.ui.TextProperty;
import com.android.tools.idea.ui.validation.validators.PathValidator;
import com.android.tools.idea.ui.wizard.WizardUtils;
import com.android.tools.idea.ui.wizard.deprecated.StudioWizardStepPanel;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.tools.idea.wizard.model.WizardModel;
import com.appspot.gsamplesindex.samplesindex.model.Sample;
import com.google.gct.studio.samples.SampleModel;
import com.google.gct.studio.util.GctStudioBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SampleSetupStep
extends ModelWizardStep<SampleModel> {
    private static final String DEFAULT_SAMPLE_NAME = GctStudioBundle.message("sample.default.name", new Object[0]);
    private final StudioWizardStepPanel myStudioPanel;
    private final ValidatorPanel myValidatorPanel;
    private final BindingsManager myBindings;
    private final StringProperty myProjectName;
    private final StringProperty myDir;
    private final ObservableString myNameToPathExpression;
    private JTextField myProjectNameField;
    private HyperlinkLabel myUrlField;
    private TextFieldWithBrowseButton myProjectLocationField;
    private JPanel myPanel;
    @NotNull
    private String myUrl;

    public SampleSetupStep(@NotNull SampleModel model) {
        if (model == null) {
            SampleSetupStep.$$$reportNull$$$0(0);
        }
        super((WizardModel)model, GctStudioBundle.message("sample.setup.title", new Object[0]));
        this.$$$setupUI$$$();
        this.myBindings = new BindingsManager();
        this.myUrl = "";
        this.myProjectName = new TextProperty((JTextComponent)this.myProjectNameField);
        this.myDir = new TextProperty((JTextComponent)this.myProjectLocationField.getTextField());
        this.myValidatorPanel = new ValidatorPanel((Disposable)this, (JComponent)this.myPanel);
        this.myStudioPanel = new StudioWizardStepPanel((JPanel)this.myValidatorPanel, GctStudioBundle.message("sample.setup.description", new Object[0]));
        this.myNameToPathExpression = new StringExpression(new ObservableValue[]{this.myProjectName}){

            @NotNull
            public String get() {
                String string = SampleSetupStep.getFileLocation((String)SampleSetupStep.this.myProjectName.get()).getAbsolutePath();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/studio/samples/SampleSetupStep$1", "get"));
            }
        };
    }

    private static String getUniqueName(String projectName) {
        File file = SampleSetupStep.getFileLocation(projectName);
        String name = projectName;
        int i = 0;
        while (file.exists()) {
            name = projectName + ++i;
            file = SampleSetupStep.getFileLocation(name);
        }
        return name;
    }

    private static File getFileLocation(String projectName) {
        return new File(WizardUtils.getProjectLocationParent(), projectName.replaceAll("[^a-zA-Z0-9_\\-.]", ""));
    }

    public void setUrl(@NotNull String url) {
        if (url == null) {
            SampleSetupStep.$$$reportNull$$$0(1);
        }
        this.myUrl = url;
    }

    @NotNull
    protected JComponent getComponent() {
        StudioWizardStepPanel studioWizardStepPanel = this.myStudioPanel;
        if (studioWizardStepPanel == null) {
            SampleSetupStep.$$$reportNull$$$0(2);
        }
        return studioWizardStepPanel;
    }

    @Nullable
    protected JComponent getPreferredFocusComponent() {
        return this.myProjectNameField;
    }

    protected void onWizardStarting(@NotNull ModelWizard.Facade wizard) {
        if (wizard == null) {
            SampleSetupStep.$$$reportNull$$$0(3);
        }
        this.myProjectLocationField.addBrowseFolderListener(GctStudioBundle.message("select.project.location", new Object[0]), null, null, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.myBindings.bind((SettableValue)this.myProjectName, (ObservableValue)new TransformOptionalExpression<Sample, String>("", ((SampleModel)this.getModel()).sample()){

            @NotNull
            protected String transform(@NotNull Sample sample) {
                String name;
                if (sample == null) {
                    2.$$$reportNull$$$0(0);
                }
                String string = SampleSetupStep.getUniqueName(StringUtil.isEmpty((String)(name = sample.getTitle())) ? DEFAULT_SAMPLE_NAME : name);
                if (string == null) {
                    2.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "sample";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/google/gct/studio/samples/SampleSetupStep$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/google/gct/studio/samples/SampleSetupStep$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "transform";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "transform";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        BoolValueProperty isNameDirSynced = new BoolValueProperty(Boolean.valueOf(true));
        this.myDir.addListener(new InvalidationListener((BoolProperty)isNameDirSynced){
            final /* synthetic */ BoolProperty val$isNameDirSynced;
            {
                this.val$isNameDirSynced = boolProperty;
            }

            public void onInvalidated(@NotNull ObservableValue<?> sender) {
                if (sender == null) {
                    3.$$$reportNull$$$0(0);
                }
                this.val$isNameDirSynced.set((Object)((String)SampleSetupStep.this.myDir.get()).equals(SampleSetupStep.this.myNameToPathExpression.get()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sender", "com/google/gct/studio/samples/SampleSetupStep$3", "onInvalidated"));
            }
        });
        this.myBindings.bind((SettableValue)this.myDir, (ObservableValue)this.myNameToPathExpression, (ObservableValue)isNameDirSynced);
        this.myValidatorPanel.registerValidator((ObservableValue)this.myProjectName, (Validator)new Validator<String>(){

            @NotNull
            public Validator.Result validate(@NotNull String projectName) {
                if (projectName == null) {
                    4.$$$reportNull$$$0(0);
                }
                Validator.Result result = StringUtil.isEmptyOrSpaces((String)projectName) ? new Validator.Result(Validator.Severity.ERROR, GctStudioBundle.message("application.name.not.set", new Object[0])) : Validator.Result.OK;
                if (result == null) {
                    4.$$$reportNull$$$0(1);
                }
                return result;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "projectName";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/google/gct/studio/samples/SampleSetupStep$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/google/gct/studio/samples/SampleSetupStep$4";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "validate";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "validate";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        PathValidator pathValidator = PathValidator.createDefault((String)"sample location");
        Expression<File> myDirFile = new Expression<File>(new ObservableValue[]{this.myDir}){

            @NotNull
            public File get() {
                File file = new File((String)SampleSetupStep.this.myDir.get());
                if (file == null) {
                    5.$$$reportNull$$$0(0);
                }
                return file;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/studio/samples/SampleSetupStep$5", "get"));
            }
        };
        this.myValidatorPanel.registerValidator((ObservableValue)myDirFile, (Validator)pathValidator);
    }

    protected void onEntering() {
        this.myUrlField.setHyperlinkTarget(this.myUrl);
        this.myUrlField.setHyperlinkText(this.myUrl);
        this.myDir.set(this.myNameToPathExpression.get());
    }

    @NotNull
    protected ObservableBool canGoForward() {
        ObservableBool observableBool = this.myValidatorPanel.hasErrors().not();
        if (observableBool == null) {
            SampleSetupStep.$$$reportNull$$$0(4);
        }
        return observableBool;
    }

    protected void onProceeding() {
        ((SampleModel)this.getModel()).projectName().setValue(this.myProjectName.get());
        ((SampleModel)this.getModel()).dir().setValue((Object)new File((String)this.myDir.get()));
    }

    public void dispose() {
        this.myBindings.releaseAll();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/gct/studio/samples/SampleSetupStep";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wizard";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/gct/studio/samples/SampleSetupStep";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "canGoForward";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setUrl";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "onWizardStarting";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        HyperlinkLabel hyperlinkLabel;
        JTextField jTextField;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myProjectNameField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myUrlField = hyperlinkLabel = new HyperlinkLabel();
        jPanel.add((Component)hyperlinkLabel, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setHorizontalAlignment(10);
        jBLabel.setText("GitHub URL:");
        jPanel.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Project location:");
        jPanel.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Application name:");
        jPanel.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myProjectLocationField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        jBLabel2.setLabelFor((Component)textFieldWithBrowseButton);
        jBLabel3.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

