/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes;

import java.util.Comparator;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.ActionConfiguration;
import org.gradle.api.attributes.AttributeDisambiguationRule;
import org.gradle.api.attributes.DisambiguationRuleChain;
import org.gradle.api.attributes.MultipleCandidatesDetails;
import org.gradle.api.internal.DefaultActionConfiguration;
import org.gradle.api.internal.attributes.AttributeMatchException;
import org.gradle.api.internal.attributes.AttributeMatchingRules;
import org.gradle.api.internal.attributes.DisambiguationRule;
import org.gradle.api.internal.attributes.MultipleCandidatesResult;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.model.internal.type.ModelType;

public class DefaultDisambiguationRuleChain<T>
implements DisambiguationRuleChain<T>,
DisambiguationRule<T> {
    private static final Object[] NO_PARAMS = new Object[0];
    private final List<Action<? super MultipleCandidatesDetails<T>>> rules = Lists.newArrayList();
    private final Instantiator instantiator;

    public DefaultDisambiguationRuleChain(Instantiator instantiator) {
        this.instantiator = instantiator;
    }

    @Override
    public void add(Class<? extends AttributeDisambiguationRule<T>> rule, Action<? super ActionConfiguration> configureAction) {
        DefaultActionConfiguration configuration = new DefaultActionConfiguration();
        configureAction.execute(configuration);
        this.rules.add(new InstantiatingAction(rule, configuration.getParams(), this.instantiator));
    }

    @Override
    public void add(Class<? extends AttributeDisambiguationRule<T>> rule) {
        this.rules.add(new InstantiatingAction(rule, NO_PARAMS, this.instantiator));
    }

    @Override
    public void pickFirst(Comparator<? super T> comparator) {
        Action<MultipleCandidatesDetails<? super T>> rule = AttributeMatchingRules.orderedDisambiguation(comparator, true);
        this.rules.add(rule);
    }

    @Override
    public void pickLast(Comparator<? super T> comparator) {
        Action<MultipleCandidatesDetails<? super T>> rule = AttributeMatchingRules.orderedDisambiguation(comparator, false);
        this.rules.add(rule);
    }

    @Override
    public void execute(MultipleCandidatesResult<T> details) {
        for (Action<MultipleCandidatesDetails<MultipleCandidatesResult<T>>> action : this.rules) {
            action.execute(details);
            if (!details.hasResult()) continue;
            return;
        }
    }

    private static class InstantiatingAction<T>
    implements Action<MultipleCandidatesDetails<T>> {
        private final Class<? extends AttributeDisambiguationRule<T>> rule;
        private final Object[] params;
        private final Instantiator instantiator;

        InstantiatingAction(Class<? extends AttributeDisambiguationRule<T>> rule, Object[] params, Instantiator instantiator) {
            this.rule = rule;
            this.params = params;
            this.instantiator = instantiator;
        }

        @Override
        public void execute(MultipleCandidatesDetails<T> details) {
            try {
                AttributeDisambiguationRule<MultipleCandidatesDetails<T>> instance = this.instantiator.newInstance(this.rule, this.params);
                instance.execute(details);
            }
            catch (Throwable t) {
                throw new AttributeMatchException(String.format("Could not select value from candidates %s using %s.", details.getCandidateValues(), ModelType.of(this.rule).getDisplayName()), t);
            }
        }
    }
}

