/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.rules;

import java.io.File;
import org.gradle.api.internal.changedetection.rules.ChangeType;
import org.gradle.api.internal.changedetection.rules.TaskStateChange;
import org.gradle.api.tasks.incremental.InputFileDetails;
import org.gradle.internal.file.FileType;
import org.gradle.internal.impldep.com.google.common.base.Objects;

public class FileChange
implements TaskStateChange,
InputFileDetails {
    private final String path;
    private final ChangeType change;
    private final String title;
    private final FileType previousFileType;
    private final FileType currentFileType;

    public static FileChange added(String path, String title, FileType currentFileType) {
        return new FileChange(path, ChangeType.ADDED, title, FileType.Missing, currentFileType);
    }

    public static FileChange removed(String path, String title, FileType previousFileType) {
        return new FileChange(path, ChangeType.REMOVED, title, previousFileType, FileType.Missing);
    }

    public static FileChange modified(String path, String title, FileType previousFileType, FileType currentFileType) {
        return new FileChange(path, ChangeType.MODIFIED, title, previousFileType, currentFileType);
    }

    private FileChange(String path, ChangeType change, String title, FileType previousFileType, FileType currentFileType) {
        this.path = path;
        this.change = change;
        this.title = title;
        this.previousFileType = previousFileType;
        this.currentFileType = currentFileType;
    }

    public String getMessage() {
        return this.title + " file " + this.path + " " + this.getDisplayedChangeType().describe() + ".";
    }

    private ChangeType getDisplayedChangeType() {
        if (this.change != ChangeType.MODIFIED) {
            return this.change;
        }
        if (this.previousFileType == FileType.Missing) {
            return ChangeType.ADDED;
        }
        if (this.currentFileType == FileType.Missing) {
            return ChangeType.REMOVED;
        }
        return ChangeType.MODIFIED;
    }

    public String toString() {
        return this.getMessage();
    }

    public String getPath() {
        return this.path;
    }

    public File getFile() {
        return new File(this.path);
    }

    public ChangeType getType() {
        return this.change;
    }

    public boolean isAdded() {
        return this.change == ChangeType.ADDED;
    }

    public boolean isModified() {
        return this.change == ChangeType.MODIFIED;
    }

    public boolean isRemoved() {
        return this.change == ChangeType.REMOVED;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileChange that = (FileChange)o;
        return Objects.equal((Object)this.path, (Object)that.path) && this.change == that.change && Objects.equal((Object)this.title, (Object)that.title) && Objects.equal((Object)((Object)this.previousFileType), (Object)((Object)that.previousFileType)) && Objects.equal((Object)((Object)this.currentFileType), (Object)((Object)that.currentFileType));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.path, this.change, this.title, this.previousFileType, this.currentFileType});
    }
}

