/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import javax.annotation.Nullable;
import org.gradle.api.Transformer;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.provider.Provider;
import org.gradle.internal.Cast;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Providers {
    public static final String NULL_TRANSFORMER_RESULT = "Transformer for this provider returned a null value.";
    public static final String NULL_VALUE = "No value has been specified for this provider.";
    private static final Provider<Object> NULL_PROVIDER = new ProviderInternal<Object>(){

        @Override
        public Object get() {
            throw new IllegalStateException(Providers.NULL_VALUE);
        }

        @Override
        @Nullable
        public Class<Object> getType() {
            return null;
        }

        @Override
        public Object getOrNull() {
            return null;
        }

        @Override
        public Object getOrElse(Object defaultValue) {
            return defaultValue;
        }

        @Override
        public <S> ProviderInternal<S> map(Transformer<? extends S, ? super Object> transformer) {
            return (ProviderInternal)Cast.uncheckedCast(this);
        }

        @Override
        public boolean isPresent() {
            return false;
        }
    };
    public static final Provider<Boolean> TRUE = Providers.of(true);
    public static final Provider<Boolean> FALSE = Providers.of(false);
    public static final Provider<Character> CHAR_ZERO = Providers.of(Character.valueOf('\u0000'));
    public static final Provider<Byte> BYTE_ZERO = Providers.of((byte)0);
    public static final Provider<Short> SHORT_ZERO = Providers.of((short)0);
    public static final Provider<Integer> INTEGER_ZERO = Providers.of(0);
    public static final Provider<Long> LONG_ZERO = Providers.of(0L);
    public static final Provider<Float> FLOAT_ZERO = Providers.of(Float.valueOf(0.0f));
    public static final Provider<Double> DOUBLE_ZERO = Providers.of(0.0);

    public static <T> Provider<T> notDefined() {
        return (Provider)Cast.uncheckedCast(NULL_PROVIDER);
    }

    public static <T> Provider<T> of(T value) {
        return new FixedValueProvider<T>(value);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MappedFixedValueProvider<S, T>
    implements ProviderInternal<S> {
        private final Transformer<? extends S, ? super T> transformer;
        private final Provider<T> provider;
        private S value;

        MappedFixedValueProvider(Transformer<? extends S, ? super T> transformer, Provider<T> provider) {
            this.transformer = transformer;
            this.provider = provider;
        }

        @Override
        @Nullable
        public Class<S> getType() {
            if (this.value != null) {
                return (Class)Cast.uncheckedCast(this.value.getClass());
            }
            return null;
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public S get() {
            if (this.value == null) {
                this.value = this.transformer.transform(this.provider.get());
                if (this.value == null) {
                    throw new IllegalStateException(Providers.NULL_TRANSFORMER_RESULT);
                }
            }
            return this.value;
        }

        @Override
        public S getOrElse(S defaultValue) {
            return this.get();
        }

        @Override
        @Nullable
        public S getOrNull() {
            return this.get();
        }

        @Override
        public <U> ProviderInternal<U> map(Transformer<? extends U, ? super S> transformer) {
            return new MappedFixedValueProvider<U, S>(transformer, this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FixedValueProvider<T>
    implements ProviderInternal<T> {
        private final T value;

        FixedValueProvider(T value) {
            this.value = value;
        }

        @Override
        @Nullable
        public Class<T> getType() {
            return (Class)Cast.uncheckedCast(this.value.getClass());
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public T getOrElse(T defaultValue) {
            return this.value;
        }

        @Override
        public T getOrNull() {
            return this.value;
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public <S> ProviderInternal<S> map(Transformer<? extends S, ? super T> transformer) {
            return new MappedFixedValueProvider<S, T>(transformer, this);
        }
    }
}

