/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.gradle.api.NonNullApi;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionVisitor;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.tasks.AbstractTaskOutputPropertySpec;
import org.gradle.api.internal.tasks.CacheableTaskOutputCompositeFilePropertyElementSpec;
import org.gradle.api.internal.tasks.DeclaredTaskOutputFileProperty;
import org.gradle.api.internal.tasks.NonCacheableTaskOutputPropertySpec;
import org.gradle.api.internal.tasks.OutputType;
import org.gradle.api.internal.tasks.TaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.TaskValidationContext;
import org.gradle.api.internal.tasks.ValidatingValue;
import org.gradle.api.internal.tasks.ValidationAction;
import org.gradle.internal.impldep.com.google.common.collect.AbstractIterator;
import org.gradle.internal.impldep.com.google.common.collect.Iterators;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.util.DeferredUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullApi
public class CompositeTaskOutputPropertySpec
extends AbstractTaskOutputPropertySpec
implements DeclaredTaskOutputFileProperty {
    private final OutputType outputType;
    private final ValidatingValue paths;
    private final ValidationAction validationAction;
    private final String taskName;
    private final FileResolver resolver;

    public CompositeTaskOutputPropertySpec(String taskName, FileResolver resolver, OutputType outputType, ValidatingValue paths, ValidationAction validationAction) {
        this.taskName = taskName;
        this.resolver = resolver;
        this.outputType = outputType;
        this.paths = paths;
        this.validationAction = validationAction;
    }

    public OutputType getOutputType() {
        return this.outputType;
    }

    public Iterator<TaskOutputFilePropertySpec> resolveToOutputProperties() {
        Object unpackedPaths = DeferredUtil.unpack(this.paths);
        if (unpackedPaths == null) {
            return Iterators.emptyIterator();
        }
        if (unpackedPaths instanceof Map) {
            final Iterator iterator = ((Map)unpackedPaths).entrySet().iterator();
            return new AbstractIterator<TaskOutputFilePropertySpec>(){

                protected TaskOutputFilePropertySpec computeNext() {
                    if (iterator.hasNext()) {
                        Map.Entry entry = (Map.Entry)iterator.next();
                        Object key = entry.getKey();
                        if (key == null) {
                            throw new IllegalArgumentException(String.format("Mapped output property '%s' has null key", CompositeTaskOutputPropertySpec.this.getPropertyName()));
                        }
                        String id = key.toString();
                        File file = CompositeTaskOutputPropertySpec.this.resolver.resolve(entry.getValue());
                        return new CacheableTaskOutputCompositeFilePropertyElementSpec(CompositeTaskOutputPropertySpec.this, "." + id, file);
                    }
                    return (TaskOutputFilePropertySpec)this.endOfData();
                }
            };
        }
        final ArrayList roots = Lists.newArrayList();
        this.resolver.resolveFiles(this.paths).visitRootElements(new FileCollectionVisitor(){

            public void visitCollection(FileCollectionInternal fileCollection) {
                this.visitRoot(fileCollection);
            }

            public void visitTree(FileTreeInternal fileTree) {
                this.visitRoot(fileTree);
            }

            public void visitDirectoryTree(DirectoryFileTree directoryTree) {
                this.visitRoot(directoryTree);
            }

            private void visitRoot(Object root) {
                roots.add(root);
            }
        });
        final Iterator iterator = roots.iterator();
        return new AbstractIterator<TaskOutputFilePropertySpec>(){
            private int index;

            protected TaskOutputFilePropertySpec computeNext() {
                if (!iterator.hasNext()) {
                    return (TaskOutputFilePropertySpec)this.endOfData();
                }
                Object root = iterator.next();
                return new NonCacheableTaskOutputPropertySpec(CompositeTaskOutputPropertySpec.this.taskName, CompositeTaskOutputPropertySpec.this, ++this.index, CompositeTaskOutputPropertySpec.this.resolver, root);
            }
        };
    }

    @Override
    public void validate(TaskValidationContext context) {
        this.paths.validate(this.getPropertyName(), this.isOptional(), this.validationAction, context);
    }
}

