/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.JavaVersion;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.MinimalJavaCompileOptions;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.compile.ForkOptions;
import org.gradle.internal.Factory;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.util.DeprecationLogger;
import org.gradle.util.GUtil;

public class JavaCompilerArgumentsBuilder {
    public static final Logger LOGGER = Logging.getLogger(JavaCompilerArgumentsBuilder.class);
    public static final String USE_UNSHARED_COMPILER_TABLE_OPTION = "-XDuseUnsharedTable=true";
    public static final String EMPTY_SOURCE_PATH_REF_DIR = "emptySourcePathRef";
    private final JavaCompileSpec spec;
    private boolean includeLauncherOptions;
    private boolean includeMainOptions = true;
    private boolean includeClasspath = true;
    private boolean includeSourceFiles;
    private boolean allowEmptySourcePath = true;
    private List<String> args;

    public JavaCompilerArgumentsBuilder(JavaCompileSpec spec) {
        this.spec = spec;
    }

    public JavaCompilerArgumentsBuilder includeLauncherOptions(boolean flag) {
        this.includeLauncherOptions = flag;
        return this;
    }

    public JavaCompilerArgumentsBuilder includeMainOptions(boolean flag) {
        this.includeMainOptions = flag;
        return this;
    }

    public JavaCompilerArgumentsBuilder includeClasspath(boolean flag) {
        this.includeClasspath = flag;
        return this;
    }

    public JavaCompilerArgumentsBuilder includeSourceFiles(boolean flag) {
        this.includeSourceFiles = flag;
        return this;
    }

    public JavaCompilerArgumentsBuilder noEmptySourcePath() {
        this.allowEmptySourcePath = false;
        return this;
    }

    public List<String> build() {
        this.args = new ArrayList<String>();
        ArrayList compArgs = Lists.newArrayList(this.spec.getCompileOptions().getCompilerArgs());
        this.addLauncherOptions();
        this.addMainOptions(compArgs);
        this.addClasspath();
        this.addUserProvidedArgs(compArgs);
        this.addSourceFiles();
        return this.args;
    }

    private void addLauncherOptions() {
        if (!this.includeLauncherOptions) {
            return;
        }
        ForkOptions forkOptions = this.spec.getCompileOptions().getForkOptions();
        if (forkOptions.getMemoryInitialSize() != null) {
            this.args.add("-J-Xms" + forkOptions.getMemoryInitialSize().trim());
        }
        if (forkOptions.getMemoryMaximumSize() != null) {
            this.args.add("-J-Xmx" + forkOptions.getMemoryMaximumSize().trim());
        }
        if (forkOptions.getJvmArgs() != null) {
            this.args.addAll(forkOptions.getJvmArgs());
        }
    }

    private void addMainOptions(List<String> compilerArgs) {
        String bootClasspath;
        File destinationDir;
        if (!this.includeMainOptions) {
            return;
        }
        final MinimalJavaCompileOptions compileOptions = this.spec.getCompileOptions();
        if (!this.releaseOptionIsSet(compilerArgs)) {
            String targetCompatibility;
            String sourceCompatibility = this.spec.getSourceCompatibility();
            if (sourceCompatibility != null) {
                this.args.add("-source");
                this.args.add(sourceCompatibility);
            }
            if ((targetCompatibility = this.spec.getTargetCompatibility()) != null) {
                this.args.add("-target");
                this.args.add(targetCompatibility);
            }
        }
        if ((destinationDir = this.spec.getDestinationDir()) != null) {
            this.args.add("-d");
            this.args.add(destinationDir.getPath());
        }
        if (compileOptions.isVerbose()) {
            this.args.add("-verbose");
        }
        if (compileOptions.isDeprecation()) {
            this.args.add("-deprecation");
        }
        if (!compileOptions.isWarnings()) {
            this.args.add("-nowarn");
        }
        if (compileOptions.getEncoding() != null) {
            this.args.add("-encoding");
            this.args.add(compileOptions.getEncoding());
        }
        if ((bootClasspath = DeprecationLogger.whileDisabled(new Factory<String>(){

            @Override
            @Nullable
            public String create() {
                return compileOptions.getBootClasspath();
            }
        })) != null) {
            this.args.add("-bootclasspath");
            this.args.add(bootClasspath);
        }
        if (compileOptions.getExtensionDirs() != null) {
            this.args.add("-extdirs");
            this.args.add(compileOptions.getExtensionDirs());
        }
        if (compileOptions.getAnnotationProcessorGeneratedSourcesDirectory() != null) {
            this.args.add("-s");
            this.args.add(compileOptions.getAnnotationProcessorGeneratedSourcesDirectory().getPath());
        }
        if (compileOptions.isDebug()) {
            if (compileOptions.getDebugOptions().getDebugLevel() != null) {
                this.args.add("-g:" + compileOptions.getDebugOptions().getDebugLevel().trim());
            } else {
                this.args.add("-g");
            }
        } else {
            this.args.add("-g:none");
        }
        List<File> sourcepath = compileOptions.getSourcepath();
        String userProvidedSourcepath = this.extractSourcepathFrom(compilerArgs, false);
        if (this.allowEmptySourcePath || sourcepath != null && !sourcepath.isEmpty() || !userProvidedSourcepath.isEmpty()) {
            this.args.add("-sourcepath");
            this.args.add(sourcepath == null ? userProvidedSourcepath : Joiner.on((String)File.pathSeparator).skipNulls().join((Object)GUtil.asPath(sourcepath), (Object)(userProvidedSourcepath.isEmpty() ? null : userProvidedSourcepath), new Object[0]));
        }
        if (this.spec.getSourceCompatibility() == null || JavaVersion.toVersion(this.spec.getSourceCompatibility()).compareTo(JavaVersion.VERSION_1_6) >= 0) {
            List<File> annotationProcessorPath = this.spec.getAnnotationProcessorPath();
            if (annotationProcessorPath == null || annotationProcessorPath.isEmpty()) {
                this.args.add("-proc:none");
            } else {
                this.args.add("-processorpath");
                this.args.add(Joiner.on((String)File.pathSeparator).join(annotationProcessorPath));
            }
        }
        this.args.add(USE_UNSHARED_COMPILER_TABLE_OPTION);
    }

    private void addUserProvidedArgs(List<String> compilerArgs) {
        if (!this.includeMainOptions) {
            return;
        }
        if (compilerArgs != null) {
            if (compilerArgs.contains("--module-source-path") && !this.extractSourcepathFrom(this.args, true).isEmpty()) {
                LOGGER.warn("You specified both --module-source-path and a sourcepath. These options are mutually exclusive. Removing sourcepath.");
            }
            this.args.addAll(compilerArgs);
        }
    }

    private String extractSourcepathFrom(List<String> compilerArgs, boolean silently) {
        Iterator<String> argIterator = compilerArgs.iterator();
        String userProvidedSourcepath = "";
        while (argIterator.hasNext()) {
            String current = argIterator.next();
            if (!current.equals("-sourcepath") && !current.equals("--source-path")) continue;
            if (!silently) {
                DeprecationLogger.nagUserOfDeprecated("Specifying the source path in the CompilerOptions compilerArgs property", "Instead, use the CompilerOptions sourcepath property directly");
            }
            argIterator.remove();
            if (!argIterator.hasNext()) continue;
            userProvidedSourcepath = argIterator.next();
            argIterator.remove();
        }
        return userProvidedSourcepath;
    }

    private boolean releaseOptionIsSet(List<String> compilerArgs) {
        return compilerArgs != null && compilerArgs.contains("--release");
    }

    private void addClasspath() {
        if (!this.includeClasspath) {
            return;
        }
        List<File> classpath = this.spec.getCompileClasspath();
        this.args.add("-classpath");
        this.args.add(classpath == null ? "" : Joiner.on((char)File.pathSeparatorChar).join(classpath));
    }

    private void addSourceFiles() {
        if (!this.includeSourceFiles) {
            return;
        }
        for (File file : this.spec.getSource()) {
            this.args.add(file.getPath());
        }
    }
}

