/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal.graph.nodes;

import java.util.Collections;
import java.util.Set;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.artifacts.result.UnresolvedDependencyResult;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.DependencyEdge;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.InvertedRenderableModuleResult;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.RenderableDependency;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;

public class UnresolvedDependencyEdge
implements DependencyEdge {
    private final UnresolvedDependencyResult dependency;
    private final ModuleComponentIdentifier actual;

    public UnresolvedDependencyEdge(UnresolvedDependencyResult dependency) {
        this.dependency = dependency;
        ModuleComponentSelector attempted = (ModuleComponentSelector)dependency.getAttempted();
        this.actual = DefaultModuleComponentIdentifier.newId(attempted.getGroup(), attempted.getModule(), attempted.getVersionConstraint().getPreferredVersion());
    }

    @Override
    public boolean isResolvable() {
        return false;
    }

    @Override
    public ComponentSelector getRequested() {
        return this.dependency.getRequested();
    }

    @Override
    public ModuleComponentIdentifier getActual() {
        return this.actual;
    }

    @Override
    public ComponentSelectionReason getReason() {
        return this.dependency.getAttemptedReason();
    }

    @Override
    public ModuleComponentIdentifier getFrom() {
        return (ModuleComponentIdentifier)this.dependency.getFrom().getId();
    }

    @Override
    public Set<? extends RenderableDependency> getChildren() {
        return Collections.singleton(new InvertedRenderableModuleResult(this.dependency.getFrom()));
    }
}

