/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.tasks;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.SortedSet;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.changedetection.state.FileContentSnapshot;
import org.gradle.api.internal.tasks.ResolvedTaskOutputFilePropertySpec;
import org.gradle.caching.internal.tasks.TaskOutputPacker;
import org.gradle.caching.internal.tasks.origin.TaskOutputOriginReader;
import org.gradle.caching.internal.tasks.origin.TaskOutputOriginWriter;
import org.gradle.internal.impldep.org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GZipTaskOutputPacker
implements TaskOutputPacker {
    private final TaskOutputPacker delegate;

    public GZipTaskOutputPacker(TaskOutputPacker delegate) {
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskOutputPacker.PackResult pack(SortedSet<ResolvedTaskOutputFilePropertySpec> propertySpecs, Map<String, Map<String, FileContentSnapshot>> outputFiles, OutputStream output, TaskOutputOriginWriter writeOrigin) throws IOException {
        GZIPOutputStream gzipOutput = this.createGzipOutputStream(output);
        try {
            TaskOutputPacker.PackResult packResult = this.delegate.pack(propertySpecs, outputFiles, gzipOutput, writeOrigin);
            return packResult;
        }
        finally {
            IOUtils.closeQuietly((OutputStream)gzipOutput);
        }
    }

    private GZIPOutputStream createGzipOutputStream(OutputStream output) {
        try {
            return new GZIPOutputStream(output);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskOutputPacker.UnpackResult unpack(SortedSet<ResolvedTaskOutputFilePropertySpec> propertySpecs, InputStream input, TaskOutputOriginReader readOrigin) throws IOException {
        GZIPInputStream gzipInput = this.createGzipInputStream(input);
        try {
            TaskOutputPacker.UnpackResult unpackResult = this.delegate.unpack(propertySpecs, gzipInput, readOrigin);
            return unpackResult;
        }
        finally {
            IOUtils.closeQuietly((InputStream)gzipInput);
        }
    }

    private GZIPInputStream createGzipInputStream(InputStream input) {
        try {
            return new GZIPInputStream(input);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

