/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.artifacts.DependenciesMetadata;
import org.gradle.api.artifacts.DependencyMetadata;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.internal.component.external.descriptor.Configuration;
import org.gradle.internal.component.external.model.DefaultConfigurationMetadata;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.external.model.MutableModuleComponentResolveMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.DependencyMetadataRules;
import org.gradle.internal.component.model.ModuleSource;
import org.gradle.internal.hash.HashUtil;
import org.gradle.internal.hash.HashValue;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;

abstract class AbstractMutableModuleComponentResolveMetadata<T extends DefaultConfigurationMetadata>
implements MutableModuleComponentResolveMetadata {
    public static final HashValue EMPTY_CONTENT = HashUtil.createHash("", "MD5");
    private ModuleComponentIdentifier componentId;
    private ModuleVersionIdentifier id;
    private boolean changing;
    private boolean missing;
    private String status = "integration";
    private List<String> statusScheme = ComponentResolveMetadata.DEFAULT_STATUS_SCHEME;
    private ModuleSource moduleSource;
    private List<? extends ModuleDependencyMetadata> dependencies;
    private HashValue contentHash = EMPTY_CONTENT;
    @Nullable
    private ImmutableList<? extends ModuleComponentArtifactMetadata> artifactOverrides;
    private ImmutableMap<String, T> configurations;
    protected final Map<String, DependencyMetadataRules> dependencyMetadataRules = Maps.newHashMap();

    protected AbstractMutableModuleComponentResolveMetadata(ModuleVersionIdentifier id, ModuleComponentIdentifier componentIdentifier, List<? extends ModuleDependencyMetadata> dependencies) {
        this.componentId = componentIdentifier;
        this.id = id;
        this.dependencies = dependencies;
    }

    protected AbstractMutableModuleComponentResolveMetadata(ModuleComponentResolveMetadata metadata) {
        this.componentId = metadata.getComponentId();
        this.id = metadata.getId();
        this.changing = metadata.isChanging();
        this.missing = metadata.isMissing();
        this.status = metadata.getStatus();
        this.statusScheme = metadata.getStatusScheme();
        this.moduleSource = metadata.getSource();
        this.artifactOverrides = metadata.getArtifactOverrides();
        this.dependencies = metadata.getDependencies();
        this.contentHash = metadata.getContentHash();
    }

    @Override
    public ModuleComponentIdentifier getComponentId() {
        return this.componentId;
    }

    @Override
    public ModuleVersionIdentifier getId() {
        return this.id;
    }

    @Override
    public void setComponentId(ModuleComponentIdentifier componentId) {
        this.componentId = componentId;
        this.id = DefaultModuleVersionIdentifier.newId(componentId);
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    protected abstract Map<String, Configuration> getConfigurationDefinitions();

    public ImmutableMap<String, T> getConfigurations() {
        if (this.configurations == null) {
            this.configurations = this.populateConfigurationsFromDescriptor(this.getConfigurationDefinitions());
        }
        return this.configurations;
    }

    protected void resetConfigurations() {
        this.configurations = null;
    }

    private ImmutableMap<String, T> populateConfigurationsFromDescriptor(Map<String, Configuration> configurationDefinitions) {
        Set<String> configurationsNames = configurationDefinitions.keySet();
        HashMap configurations = new HashMap(configurationsNames.size());
        for (String configName : configurationsNames) {
            Object configuration = this.populateConfigurationFromDescriptor(configName, configurationDefinitions, configurations);
            ((DefaultConfigurationMetadata)configuration).populateDependencies(this.dependencies, this.dependencyMetadataRules.get(configName));
        }
        return ImmutableMap.copyOf(configurations);
    }

    private T populateConfigurationFromDescriptor(String name, Map<String, Configuration> configurationDefinitions, Map<String, T> configurations) {
        DefaultConfigurationMetadata populated = (DefaultConfigurationMetadata)configurations.get(name);
        if (populated != null) {
            return (T)populated;
        }
        Configuration descriptorConfiguration = configurationDefinitions.get(name);
        List<String> extendsFrom = descriptorConfiguration.getExtendsFrom();
        boolean transitive = descriptorConfiguration.isTransitive();
        boolean visible = descriptorConfiguration.isVisible();
        if (extendsFrom.isEmpty()) {
            populated = this.createConfiguration(this.componentId, name, transitive, visible, ImmutableList.of(), this.artifactOverrides);
            configurations.put(name, populated);
            return (T)populated;
        }
        if (extendsFrom.size() == 1) {
            populated = this.createConfiguration(this.componentId, name, transitive, visible, ImmutableList.of(this.populateConfigurationFromDescriptor(extendsFrom.get(0), configurationDefinitions, configurations)), this.artifactOverrides);
            configurations.put(name, populated);
            return (T)populated;
        }
        ArrayList<T> hierarchy = new ArrayList<T>(extendsFrom.size());
        for (String confName : extendsFrom) {
            hierarchy.add(this.populateConfigurationFromDescriptor(confName, configurationDefinitions, configurations));
        }
        populated = this.createConfiguration(this.componentId, name, transitive, visible, ImmutableList.copyOf(hierarchy), this.artifactOverrides);
        configurations.put(name, populated);
        return (T)populated;
    }

    protected abstract T createConfiguration(ModuleComponentIdentifier var1, String var2, boolean var3, boolean var4, ImmutableList<T> var5, ImmutableList<? extends ModuleComponentArtifactMetadata> var6);

    @Override
    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public List<String> getStatusScheme() {
        return this.statusScheme;
    }

    @Override
    public void setStatusScheme(List<String> statusScheme) {
        this.statusScheme = statusScheme;
    }

    @Override
    public boolean isMissing() {
        return this.missing;
    }

    @Override
    public void setMissing(boolean missing) {
        this.missing = missing;
    }

    @Override
    public boolean isChanging() {
        return this.changing;
    }

    @Override
    public void setChanging(boolean changing) {
        this.changing = changing;
    }

    @Override
    public HashValue getContentHash() {
        return this.contentHash;
    }

    @Override
    public void setContentHash(HashValue contentHash) {
        this.contentHash = contentHash;
    }

    @Override
    public ModuleSource getSource() {
        return this.moduleSource;
    }

    @Override
    public void setSource(ModuleSource source) {
        this.moduleSource = source;
    }

    @Override
    public ModuleComponentArtifactMetadata artifact(String type, @Nullable String extension, @Nullable String classifier) {
        DefaultIvyArtifactName ivyArtifactName = new DefaultIvyArtifactName(this.getId().getName(), type, extension, classifier);
        return new DefaultModuleComponentArtifactMetadata(this.getComponentId(), ivyArtifactName);
    }

    @Override
    public void addDependencyMetadataRule(String variantName, Action<DependenciesMetadata> action, Instantiator instantiator, NotationParser<Object, DependencyMetadata> dependencyNotationParser) {
        DependencyMetadataRules rulesForVariant = this.dependencyMetadataRules.get(variantName);
        if (rulesForVariant == null) {
            this.dependencyMetadataRules.put(variantName, new DependencyMetadataRules(instantiator, dependencyNotationParser));
        }
        this.dependencyMetadataRules.get(variantName).addAction(action);
        this.resetConfigurations();
    }

    @Override
    @Nullable
    public ImmutableList<? extends ModuleComponentArtifactMetadata> getArtifactOverrides() {
        return this.artifactOverrides;
    }

    @Override
    public void setArtifactOverrides(Iterable<? extends ModuleComponentArtifactMetadata> artifacts) {
        this.artifactOverrides = ImmutableList.copyOf(artifacts);
        this.resetConfigurations();
    }

    @Override
    public List<? extends ModuleDependencyMetadata> getDependencies() {
        return this.dependencies;
    }

    @Override
    public void setDependencies(Iterable<? extends ModuleDependencyMetadata> dependencies) {
        this.dependencies = ImmutableList.copyOf(dependencies);
        this.resetConfigurations();
    }
}

