/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.external.descriptor.Artifact;
import org.gradle.internal.component.external.descriptor.MavenScope;
import org.gradle.internal.component.external.model.MavenModuleResolveMetadata;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.ConfigurationNotFoundException;
import org.gradle.internal.component.model.DefaultDependencyMetadata;
import org.gradle.internal.component.model.Exclude;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Sets;

public class MavenDependencyMetadata
extends DefaultDependencyMetadata {
    private final MavenScope scope;
    private final Set<String> moduleConfigurations;
    private final List<Exclude> excludes;

    public MavenDependencyMetadata(MavenScope scope, boolean optional, ModuleComponentSelector selector, List<Artifact> artifacts, List<Exclude> excludes) {
        super(selector, artifacts, optional);
        this.scope = scope;
        this.moduleConfigurations = this.isOptional() && scope != MavenScope.Test && scope != MavenScope.System ? ImmutableSet.of((Object)"optional", (Object)scope.name().toLowerCase()) : ImmutableSet.of((Object)scope.name().toLowerCase());
        this.excludes = ImmutableList.copyOf(excludes);
    }

    public String toString() {
        return "dependency: " + this.getSelector() + ", scope: " + (Object)((Object)this.scope) + ", optional: " + this.isOptional();
    }

    public MavenScope getScope() {
        return this.scope;
    }

    @Override
    public Set<String> getModuleConfigurations() {
        return this.moduleConfigurations;
    }

    @Override
    public boolean isChanging() {
        return false;
    }

    @Override
    public boolean isTransitive() {
        return true;
    }

    @Override
    public boolean isForce() {
        return false;
    }

    @Override
    public Set<ConfigurationMetadata> selectConfigurations(ImmutableAttributes consumerAttributes, ComponentResolveMetadata fromComponent, ConfigurationMetadata fromConfiguration, ComponentResolveMetadata targetComponent, AttributesSchemaInternal consumerSchema) {
        ConfigurationMetadata master;
        if (!(targetComponent.getVariantsForGraphTraversal().isEmpty() || consumerAttributes.isEmpty() && !(targetComponent instanceof MavenModuleResolveMetadata))) {
            return ImmutableSet.of((Object)this.selectConfigurationUsingAttributeMatching(consumerAttributes, targetComponent, consumerSchema));
        }
        LinkedHashSet result = Sets.newLinkedHashSet();
        boolean requiresCompile = fromConfiguration.getName().equals("compile");
        if (!requiresCompile) {
            ConfigurationMetadata runtime = this.findTargetConfiguration(fromComponent, fromConfiguration, targetComponent, "runtime");
            result.add(runtime);
            boolean bl = requiresCompile = !runtime.getHierarchy().contains("compile");
        }
        if (requiresCompile) {
            result.add(this.findTargetConfiguration(fromComponent, fromConfiguration, targetComponent, "compile"));
        }
        if (!((master = targetComponent.getConfiguration("master")) == null || master.getDependencies().isEmpty() && master.getArtifacts().isEmpty())) {
            result.add(master);
        }
        return result;
    }

    private ConfigurationMetadata findTargetConfiguration(ComponentResolveMetadata fromComponent, ConfigurationMetadata fromConfiguration, ComponentResolveMetadata targetComponent, String target) {
        ConfigurationMetadata configuration = targetComponent.getConfiguration(target);
        if (configuration == null && (configuration = targetComponent.getConfiguration("default")) == null) {
            throw new ConfigurationNotFoundException(fromComponent.getComponentId(), fromConfiguration.getName(), target, targetComponent.getComponentId());
        }
        return configuration;
    }

    @Override
    protected ModuleDependencyMetadata withRequested(ModuleComponentSelector newRequested) {
        return new MavenDependencyMetadata(this.scope, this.isOptional(), newRequested, this.getDependencyArtifacts(), this.getExcludes());
    }

    @Override
    public List<Exclude> getExcludes() {
        return this.excludes;
    }

    @Override
    public List<Exclude> getExcludes(Collection<String> configurations) {
        return this.excludes;
    }

    @Override
    public String getDynamicConstraintVersion() {
        return this.getSelector().getVersionConstraint().getPreferredVersion();
    }
}

