/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.artifacts.DependenciesMetadata;
import org.gradle.api.artifacts.DependencyMetadata;
import org.gradle.api.internal.artifacts.repositories.resolver.DependenciesMetadataAdapter;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;

public class DependencyMetadataRules {
    private final Instantiator instantiator;
    private final NotationParser<Object, DependencyMetadata> dependencyNotationParser;
    private final List<Action<DependenciesMetadata>> actions = new ArrayList<Action<DependenciesMetadata>>();

    public DependencyMetadataRules(Instantiator instantiator, NotationParser<Object, DependencyMetadata> dependencyNotationParser) {
        this.instantiator = instantiator;
        this.dependencyNotationParser = dependencyNotationParser;
    }

    public void addAction(Action<DependenciesMetadata> action) {
        this.actions.add(action);
    }

    public <T extends ModuleDependencyMetadata> List<T> execute(List<T> dependencies) {
        ArrayList<T> calculatedDependencies = new ArrayList<T>(dependencies);
        for (Action<DependenciesMetadata> dependenciesMetadataAction : this.actions) {
            dependenciesMetadataAction.execute(this.instantiator.newInstance(DependenciesMetadataAdapter.class, calculatedDependencies, this.instantiator, this.dependencyNotationParser));
        }
        return calculatedDependencies;
    }
}

