/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.gradle.internal.hash.HashValue;
import org.gradle.internal.impldep.org.apache.http.Header;
import org.gradle.internal.impldep.org.apache.http.HttpEntity;
import org.gradle.internal.impldep.org.apache.http.HttpResponse;
import org.gradle.internal.impldep.org.apache.http.client.methods.CloseableHttpResponse;
import org.gradle.internal.impldep.org.apache.http.client.utils.DateUtils;
import org.gradle.internal.impldep.org.apache.http.client.utils.HttpClientUtils;
import org.gradle.internal.resource.metadata.DefaultExternalResourceMetaData;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;
import org.gradle.internal.resource.transfer.ExternalResourceReadResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResponseResource
implements ExternalResourceReadResponse {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpResponseResource.class);
    private final String method;
    private final URI source;
    private final CloseableHttpResponse response;
    private final ExternalResourceMetaData metaData;
    private boolean wasOpened;

    public HttpResponseResource(String method, URI source, CloseableHttpResponse response) {
        this.method = method;
        this.source = source;
        this.response = response;
        String etag = HttpResponseResource.getEtag((HttpResponse)response);
        this.metaData = new DefaultExternalResourceMetaData(source, this.getLastModified(), this.getContentLength(), this.getContentType(), etag, HttpResponseResource.getSha1((HttpResponse)response, etag));
    }

    public URI getURI() {
        return this.source;
    }

    public String toString() {
        return "Http " + this.method + " Resource: " + this.source;
    }

    @Override
    public ExternalResourceMetaData getMetaData() {
        return this.metaData;
    }

    public int getStatusCode() {
        return this.response.getStatusLine().getStatusCode();
    }

    public long getLastModified() {
        Header responseHeader = this.response.getFirstHeader("last-modified");
        if (responseHeader == null) {
            return 0L;
        }
        try {
            return DateUtils.parseDate((String)responseHeader.getValue()).getTime();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public long getContentLength() {
        Header header = this.response.getFirstHeader("Content-Length");
        if (header == null) {
            return -1L;
        }
        String value = header.getValue();
        if (value == null) {
            return -1L;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    public String getHeaderValue(String name) {
        Header header = this.response.getFirstHeader(name);
        return header != null ? header.getValue() : null;
    }

    public String getContentType() {
        Header header = this.response.getFirstHeader("Content-Type");
        return header == null ? null : header.getValue();
    }

    public boolean isLocal() {
        return false;
    }

    @Override
    public InputStream openStream() throws IOException {
        if (this.wasOpened) {
            throw new IOException("Unable to open Stream as it was opened before.");
        }
        LOGGER.debug("Attempting to download resource {}.", (Object)this.source);
        this.wasOpened = true;
        HttpEntity entity = this.response.getEntity();
        if (entity == null) {
            throw new IOException(String.format("Response %d: %s has no content!", this.getStatusCode(), this.response.getStatusLine().getReasonPhrase()));
        }
        return entity.getContent();
    }

    @Override
    public void close() throws IOException {
        HttpClientUtils.closeQuietly((CloseableHttpResponse)this.response);
    }

    private static String getEtag(HttpResponse response) {
        Header etagHeader = response.getFirstHeader("ETag");
        return etagHeader == null ? null : etagHeader.getValue();
    }

    private static HashValue getSha1(HttpResponse response, String etag) {
        Header sha1Header = response.getFirstHeader("X-Checksum-Sha1");
        if (sha1Header != null) {
            return new HashValue(sha1Header.getValue());
        }
        if (etag != null && etag.startsWith("{SHA1{")) {
            String hash = etag.substring(6, etag.length() - 2);
            return new HashValue(hash);
        }
        return null;
    }
}

