/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.swift.plugins;

import javax.inject.Inject;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.attributes.Usage;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.swift.SwiftLibrary;
import org.gradle.language.swift.SwiftSharedLibrary;
import org.gradle.language.swift.internal.DefaultSwiftLibrary;
import org.gradle.language.swift.plugins.SwiftBasePlugin;
import org.gradle.language.swift.tasks.SwiftCompile;
import org.gradle.util.GUtil;

@Incubating
public class SwiftLibraryPlugin
implements Plugin<Project> {
    private final FileOperations fileOperations;

    @Inject
    public SwiftLibraryPlugin(FileOperations fileOperations) {
        this.fileOperations = fileOperations;
    }

    @Override
    public void apply(Project project) {
        project.getPluginManager().apply(SwiftBasePlugin.class);
        TaskContainer tasks = project.getTasks();
        ConfigurationContainer configurations = project.getConfigurations();
        ObjectFactory objectFactory = project.getObjects();
        SwiftLibrary library = project.getExtensions().create(SwiftLibrary.class, "library", DefaultSwiftLibrary.class, "main", project.getLayout(), objectFactory, this.fileOperations, configurations);
        project.getComponents().add(library);
        SwiftSharedLibrary debugSharedLibrary = library.getDebugSharedLibrary();
        project.getComponents().add(debugSharedLibrary);
        SwiftSharedLibrary releaseSharedLibrary = library.getReleaseSharedLibrary();
        project.getComponents().add(releaseSharedLibrary);
        Property<String> module = library.getModule();
        module.set(GUtil.toCamelCase(project.getName()));
        SwiftCompile compileDebug = (SwiftCompile)tasks.getByName("compileDebugSwift");
        SwiftCompile compileRelease = (SwiftCompile)tasks.getByName("compileReleaseSwift");
        tasks.getByName("assemble").dependsOn(library.getDevelopmentBinary().getRuntimeFile());
        Configuration implementation = library.getImplementationDependencies();
        Configuration api = library.getApiDependencies();
        Configuration debugApiElements = (Configuration)configurations.maybeCreate("debugSwiftApiElements");
        debugApiElements.extendsFrom(api);
        debugApiElements.setCanBeResolved(false);
        debugApiElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, objectFactory.named(Usage.class, "swift-api"));
        debugApiElements.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, true);
        debugApiElements.getOutgoing().artifact(compileDebug.getModuleFile());
        Configuration debugLinkElements = (Configuration)configurations.maybeCreate("debugLinkElements");
        debugLinkElements.extendsFrom(implementation);
        debugLinkElements.setCanBeResolved(false);
        debugLinkElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, objectFactory.named(Usage.class, "native-link"));
        debugLinkElements.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, true);
        debugLinkElements.getOutgoing().artifact(debugSharedLibrary.getRuntimeFile());
        Configuration debugRuntimeElements = (Configuration)configurations.maybeCreate("debugRuntimeElements");
        debugRuntimeElements.extendsFrom(implementation);
        debugRuntimeElements.setCanBeResolved(false);
        debugRuntimeElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, objectFactory.named(Usage.class, "native-runtime"));
        debugRuntimeElements.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, true);
        debugRuntimeElements.getOutgoing().artifact(debugSharedLibrary.getRuntimeFile());
        Configuration releaseApiElements = (Configuration)configurations.maybeCreate("releaseSwiftApiElements");
        releaseApiElements.extendsFrom(api);
        releaseApiElements.setCanBeResolved(false);
        releaseApiElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, objectFactory.named(Usage.class, "swift-api"));
        releaseApiElements.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, false);
        releaseApiElements.getOutgoing().artifact(compileRelease.getModuleFile());
        Configuration releaseLinkElements = (Configuration)configurations.maybeCreate("releaseLinkElements");
        releaseLinkElements.extendsFrom(implementation);
        releaseLinkElements.setCanBeResolved(false);
        releaseLinkElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, objectFactory.named(Usage.class, "native-link"));
        releaseLinkElements.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, false);
        releaseLinkElements.getOutgoing().artifact(releaseSharedLibrary.getRuntimeFile());
        Configuration releaseRuntimeElements = (Configuration)configurations.maybeCreate("releaseRuntimeElements");
        releaseRuntimeElements.extendsFrom(implementation);
        releaseRuntimeElements.setCanBeResolved(false);
        releaseRuntimeElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, objectFactory.named(Usage.class, "native-runtime"));
        releaseRuntimeElements.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, false);
        releaseRuntimeElements.getOutgoing().artifact(releaseSharedLibrary.getRuntimeFile());
    }
}

