/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.binding;

import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;
import org.gradle.internal.impldep.com.google.common.collect.Ordering;
import org.gradle.model.internal.manage.binding.ManagedProperty;
import org.gradle.model.internal.manage.binding.StructBindings;
import org.gradle.model.internal.manage.binding.StructMethodBinding;
import org.gradle.model.internal.manage.schema.StructSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultStructBindings<T>
implements StructBindings<T> {
    private final StructSchema<T> publicSchema;
    private final Set<StructSchema<?>> declaredViewSchemas;
    private final Set<StructSchema<?>> implementedViewSchemas;
    private final StructSchema<?> delegateSchema;
    private final Map<String, ManagedProperty<?>> managedProperties;
    private final Collection<StructMethodBinding> methodBindings;

    protected DefaultStructBindings(StructSchema<T> publicSchema, Iterable<? extends StructSchema<?>> declaredViewSchemas, Iterable<? extends StructSchema<?>> implementedViewSchemas, @Nullable StructSchema<?> delegateSchema, Map<String, ManagedProperty<?>> managedProperties, Iterable<StructMethodBinding> methodBindings) {
        this.publicSchema = publicSchema;
        this.declaredViewSchemas = ImmutableSet.copyOf(declaredViewSchemas);
        this.implementedViewSchemas = ImmutableSet.copyOf(implementedViewSchemas);
        this.delegateSchema = delegateSchema;
        this.managedProperties = ImmutableSortedMap.copyOf(managedProperties, (Comparator)Ordering.natural());
        this.methodBindings = ImmutableList.copyOf(methodBindings);
    }

    @Override
    public StructSchema<T> getPublicSchema() {
        return this.publicSchema;
    }

    @Override
    public Set<StructSchema<?>> getDeclaredViewSchemas() {
        return this.declaredViewSchemas;
    }

    @Override
    public Set<StructSchema<?>> getImplementedViewSchemas() {
        return this.implementedViewSchemas;
    }

    @Override
    @Nullable
    public StructSchema<?> getDelegateSchema() {
        return this.delegateSchema;
    }

    @Override
    public Map<String, ManagedProperty<?>> getManagedProperties() {
        return this.managedProperties;
    }

    @Override
    public ManagedProperty<?> getManagedProperty(String name) {
        return this.managedProperties.get(name);
    }

    @Override
    public Collection<StructMethodBinding> getMethodBindings() {
        return this.methodBindings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultStructBindings that = (DefaultStructBindings)o;
        return Objects.equal(this.publicSchema, that.publicSchema) && Objects.equal(this.declaredViewSchemas, that.declaredViewSchemas) && Objects.equal(this.delegateSchema, that.delegateSchema);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.publicSchema, this.declaredViewSchemas, this.delegateSchema});
    }

    public String toString() {
        return "StructBindings[" + this.publicSchema.getType().getDisplayName() + "]";
    }
}

