/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.test.cpp.plugins;

import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.language.cpp.CppComponent;
import org.gradle.language.cpp.plugins.CppBasePlugin;
import org.gradle.language.cpp.plugins.CppExecutablePlugin;
import org.gradle.language.cpp.plugins.CppLibraryPlugin;
import org.gradle.nativeplatform.tasks.AbstractLinkTask;
import org.gradle.nativeplatform.tasks.InstallExecutable;
import org.gradle.nativeplatform.test.cpp.CppTestSuite;
import org.gradle.nativeplatform.test.cpp.internal.DefaultCppTestSuite;
import org.gradle.nativeplatform.test.tasks.RunTestExecutable;
import org.gradle.testing.base.plugins.TestingBasePlugin;

@Incubating
public class CppUnitTestPlugin
implements Plugin<ProjectInternal> {
    private final ObjectFactory objectFactory;
    private final FileOperations fileOperations;

    @Inject
    public CppUnitTestPlugin(FileOperations fileOperations, ObjectFactory objectFactory) {
        this.fileOperations = fileOperations;
        this.objectFactory = objectFactory;
    }

    @Override
    public void apply(final ProjectInternal project) {
        project.getPluginManager().apply(CppBasePlugin.class);
        project.getPluginManager().apply(TestingBasePlugin.class);
        ConfigurationContainer configurations = project.getConfigurations();
        final CppTestSuite testComponent = this.objectFactory.newInstance(DefaultCppTestSuite.class, "unitTest", project.getLayout(), this.objectFactory, this.fileOperations, configurations);
        project.getComponents().add(testComponent);
        project.getComponents().add(testComponent.getTestExecutable());
        project.getExtensions().add(CppTestSuite.class, "unitTest", testComponent);
        Action<Plugin<ProjectInternal>> projectConfiguration = new Action<Plugin<ProjectInternal>>(){

            @Override
            public void execute(Plugin<ProjectInternal> plugin) {
                final TaskContainerInternal tasks = project.getTasks();
                CppComponent mainComponent = (CppComponent)project.getComponents().withType(CppComponent.class).findByName("main");
                ((DefaultCppTestSuite)testComponent).getTestedComponent().set(mainComponent);
                AbstractLinkTask linkTest = tasks.withType(AbstractLinkTask.class).getByName("linkUnitTest");
                linkTest.source(mainComponent.getDevelopmentBinary().getObjects());
                RunTestExecutable testTask = tasks.create("runUnitTest", RunTestExecutable.class, new Action<RunTestExecutable>(){

                    @Override
                    public void execute(RunTestExecutable testTask) {
                        testTask.setGroup("verification");
                        testTask.setDescription("Executes C++ unit tests.");
                        InstallExecutable installTask = (InstallExecutable)tasks.getByName("installUnitTest");
                        testTask.setExecutable(installTask.getRunScript());
                        testTask.dependsOn(testComponent.getTestExecutable().getInstallDirectory());
                        testTask.setOutputDir(project.getLayout().getBuildDirectory().dir("test-results/unitTest").get().getAsFile());
                    }
                });
                tasks.getByName("check").dependsOn(testTask);
            }
        };
        project.getPlugins().withType(CppLibraryPlugin.class, projectConfiguration);
        project.getPlugins().withType(CppExecutablePlugin.class, projectConfiguration);
    }
}

