/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal;

import org.gradle.api.Action;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.Task;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.platform.base.BinaryTasksCollection;
import org.gradle.platform.base.internal.BinarySpecInternal;

public class DefaultBinaryTasksCollection
extends DefaultDomainObjectSet<Task>
implements BinaryTasksCollection {
    private final BinarySpecInternal binary;
    private final ITaskFactory taskFactory;

    public DefaultBinaryTasksCollection(BinarySpecInternal binarySpecInternal, ITaskFactory taskFactory) {
        super(Task.class);
        this.binary = binarySpecInternal;
        this.taskFactory = taskFactory;
    }

    @Override
    public String taskName(String verb) {
        return verb + StringUtils.capitalize((String)this.binary.getProjectScopedName());
    }

    @Override
    public String taskName(String verb, String object) {
        return verb + StringUtils.capitalize((String)this.binary.getProjectScopedName()) + StringUtils.capitalize((String)object);
    }

    @Override
    public Task getBuild() {
        return this.binary.getBuildTask();
    }

    @Override
    public Task getCheck() {
        return this.binary.getCheckTask();
    }

    public <T extends Task> T findSingleTaskWithType(Class<T> type) {
        DomainObjectCollection tasks = this.withType(type);
        if (tasks.size() == 0) {
            return null;
        }
        if (tasks.size() > 1) {
            throw new UnknownDomainObjectException(String.format("Multiple tasks with type '%s' found.", type.getSimpleName()));
        }
        return (T)((Task)tasks.iterator().next());
    }

    @Override
    public <T extends Task> void create(String name, Class<T> type, Action<? super T> config) {
        Task task = (Task)this.taskFactory.create(name, type);
        this.add(task);
        config.execute(task);
    }
}

