/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.internal.twirl;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.gradle.language.twirl.TwirlImports;
import org.gradle.language.twirl.TwirlTemplateFormat;
import org.gradle.play.internal.twirl.TwirlCompilerAdapterV10X;
import org.gradle.scala.internal.reflect.ScalaCodecMapper;
import org.gradle.scala.internal.reflect.ScalaMethod;
import org.gradle.scala.internal.reflect.ScalaReflectionUtil;
import org.gradle.util.CollectionUtils;

class TwirlCompilerAdapterV13X
extends TwirlCompilerAdapterV10X {
    private static final Iterable<String> SHARED_PACKAGES = Arrays.asList("play.twirl.compiler", "scala.io", "scala.util.parsing.input", "scala.collection");
    private static final List<String> DEFAULT_JAVA_TEMPLATE_IMPORTS;
    private static final List<String> DEFAULT_SCALA_TEMPLATE_IMPORTS;
    private static final List<String> DEFAULT_TEMPLATE_IMPORTS;

    public TwirlCompilerAdapterV13X(String twirlVersion, String scalaVersion) {
        super(twirlVersion, scalaVersion);
    }

    @Override
    public ScalaMethod getCompileMethod(ClassLoader cl) throws ClassNotFoundException {
        return ScalaReflectionUtil.scalaMethod(cl, "play.twirl.compiler.TwirlCompiler", "compile", File.class, File.class, File.class, String.class, cl.loadClass("scala.collection.Seq"), cl.loadClass("scala.collection.Seq"), cl.loadClass(ScalaCodecMapper.getClassName()), Boolean.TYPE);
    }

    @Override
    public Object[] createCompileParameters(ClassLoader cl, File file, File sourceDirectory, File destinationDirectory, TwirlImports defaultImports, TwirlTemplateFormat templateFormat, List<String> additionalImports) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        return new Object[]{file, sourceDirectory, destinationDirectory, templateFormat.getFormatType(), this.toScalaSeq(CollectionUtils.flattenCollections(this.getDefaultImports(defaultImports), additionalImports, templateFormat.getTemplateImports()), cl), this.toScalaSeq(Collections.emptyList(), cl), ScalaCodecMapper.create(cl, "UTF-8"), this.isInclusiveDots()};
    }

    private Object toScalaSeq(Collection<?> list, ClassLoader classLoader) {
        ScalaMethod method = ScalaReflectionUtil.scalaMethod(classLoader, "scala.collection.JavaConversions", "asScalaBuffer", List.class);
        return method.invoke(list);
    }

    private boolean isInclusiveDots() {
        return false;
    }

    @Override
    public Iterable<String> getClassLoaderPackages() {
        return SHARED_PACKAGES;
    }

    @Override
    public List<String> getDependencyNotation() {
        if (this.scalaVersion.startsWith("2.12")) {
            return CollectionUtils.flattenCollections(super.getDependencyNotation(), "org.scala-lang.modules:scala-parser-combinators_2.12:1.0.6");
        }
        return super.getDependencyNotation();
    }

    @Override
    protected Collection<String> getDefaultScalaImports() {
        return DEFAULT_SCALA_TEMPLATE_IMPORTS;
    }

    @Override
    protected Collection<String> getDefaultJavaImports() {
        return DEFAULT_JAVA_TEMPLATE_IMPORTS;
    }

    static {
        DEFAULT_TEMPLATE_IMPORTS = Collections.unmodifiableList(Arrays.asList("models._", "controllers._", "play.api.i18n._", "play.api.templates.PlayMagic._", "_root_.play.twirl.api.TwirlFeatureImports._", "_root_.play.twirl.api.TwirlHelperImports._", "_root_.play.twirl.api.Html", "_root_.play.twirl.api.JavaScript", "_root_.play.twirl.api.Txt", "_root_.play.twirl.api.Xml"));
        ArrayList<String> defaultJavaImports = new ArrayList<String>();
        defaultJavaImports.addAll(DEFAULT_TEMPLATE_IMPORTS);
        defaultJavaImports.add("java.lang._");
        defaultJavaImports.add("java.util._");
        defaultJavaImports.add("scala.collection.JavaConverters._");
        defaultJavaImports.add("play.core.j.PlayMagicForJava._");
        defaultJavaImports.add("play.mvc._");
        defaultJavaImports.add("play.libs.F");
        defaultJavaImports.add("play.api.data.Field");
        defaultJavaImports.add("play.mvc.Http.Context.Implicit._");
        defaultJavaImports.add("play.data._");
        defaultJavaImports.add("play.core.j.PlayFormsMagicForJava._");
        DEFAULT_JAVA_TEMPLATE_IMPORTS = Collections.unmodifiableList(defaultJavaImports);
        ArrayList<String> scalaImports = new ArrayList<String>();
        scalaImports.addAll(DEFAULT_TEMPLATE_IMPORTS);
        scalaImports.add("play.api.mvc._");
        scalaImports.add("play.api.data._");
        DEFAULT_SCALA_TEMPLATE_IMPORTS = Collections.unmodifiableList(scalaImports);
    }
}

