/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.worker;

import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Set;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.classloader.ClasspathUtil;
import org.gradle.internal.operations.BuildOperationIdentifierRegistry;
import org.gradle.internal.remote.ObjectConnection;
import org.gradle.process.internal.JavaExecHandleBuilder;
import org.gradle.process.internal.worker.DefaultWorkerProcessBuilder;
import org.gradle.process.internal.worker.SingleRequestWorkerProcessBuilder;
import org.gradle.process.internal.worker.WorkerProcess;
import org.gradle.process.internal.worker.WorkerProcessException;
import org.gradle.process.internal.worker.WorkerProcessSettings;
import org.gradle.process.internal.worker.request.Receiver;
import org.gradle.process.internal.worker.request.RequestProtocol;
import org.gradle.process.internal.worker.request.ResponseProtocol;
import org.gradle.process.internal.worker.request.WorkerAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultSingleRequestWorkerProcessBuilder<PROTOCOL>
implements SingleRequestWorkerProcessBuilder<PROTOCOL> {
    private final Class<PROTOCOL> protocolType;
    private final Class<? extends PROTOCOL> workerImplementation;
    private final DefaultWorkerProcessBuilder builder;

    public DefaultSingleRequestWorkerProcessBuilder(Class<PROTOCOL> protocolType, Class<? extends PROTOCOL> workerImplementation, DefaultWorkerProcessBuilder builder) {
        this.protocolType = protocolType;
        this.workerImplementation = workerImplementation;
        this.builder = builder;
        builder.worker(new WorkerAction(workerImplementation));
        builder.setImplementationClasspath(ClasspathUtil.getClasspath(workerImplementation.getClassLoader()).getAsURLs());
    }

    @Override
    public WorkerProcessSettings setBaseName(String baseName) {
        this.builder.setBaseName(baseName);
        return this;
    }

    @Override
    public String getBaseName() {
        return this.builder.getBaseName();
    }

    @Override
    public WorkerProcessSettings applicationClasspath(Iterable<File> files) {
        this.builder.applicationClasspath((Iterable)files);
        return this;
    }

    @Override
    public Set<File> getApplicationClasspath() {
        return this.builder.getApplicationClasspath();
    }

    @Override
    public WorkerProcessSettings sharedPackages(String ... packages) {
        this.builder.sharedPackages(packages);
        return this;
    }

    @Override
    public WorkerProcessSettings sharedPackages(Iterable<String> packages) {
        this.builder.sharedPackages((Iterable)packages);
        return this;
    }

    @Override
    public Set<String> getSharedPackages() {
        return this.builder.getSharedPackages();
    }

    @Override
    public JavaExecHandleBuilder getJavaCommand() {
        return this.builder.getJavaCommand();
    }

    @Override
    public LogLevel getLogLevel() {
        return this.builder.getLogLevel();
    }

    @Override
    public WorkerProcessSettings setLogLevel(LogLevel logLevel) {
        this.builder.setLogLevel(logLevel);
        return this;
    }

    @Override
    public PROTOCOL build() {
        return this.protocolType.cast(Proxy.newProxyInstance(this.protocolType.getClassLoader(), new Class[]{this.protocolType}, new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Receiver receiver = new Receiver(DefaultSingleRequestWorkerProcessBuilder.this.getBaseName());
                try {
                    WorkerProcess workerProcess = DefaultSingleRequestWorkerProcessBuilder.this.builder.build();
                    workerProcess.start();
                    ObjectConnection connection = workerProcess.getConnection();
                    RequestProtocol requestProtocol = connection.addOutgoing(RequestProtocol.class);
                    connection.addIncoming(ResponseProtocol.class, receiver);
                    connection.useJavaSerializationForParameters(DefaultSingleRequestWorkerProcessBuilder.this.workerImplementation.getClassLoader());
                    connection.connect();
                    requestProtocol.runThenStop(method.getName(), method.getParameterTypes(), args, BuildOperationIdentifierRegistry.getCurrentOperationIdentifier());
                    boolean hasResult = receiver.awaitNextResult();
                    workerProcess.waitForStop();
                    if (!hasResult) {
                        throw new IllegalStateException(String.format("No response was received from %s but the worker process has finished.", DefaultSingleRequestWorkerProcessBuilder.this.getBaseName()));
                    }
                }
                catch (Exception e) {
                    throw WorkerProcessException.runFailed(DefaultSingleRequestWorkerProcessBuilder.this.getBaseName(), e);
                }
                return receiver.getNextResult();
            }
        }));
    }
}

