/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.worker.child;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.logging.LogLevel;
import org.gradle.initialization.GradleUserHomeDirProvider;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.event.DefaultListenerManager;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.io.ClassLoaderObjectInputStream;
import org.gradle.internal.logging.LoggingManagerInternal;
import org.gradle.internal.logging.services.LoggingServiceRegistry;
import org.gradle.internal.remote.MessagingClient;
import org.gradle.internal.remote.ObjectConnection;
import org.gradle.internal.remote.internal.inet.MultiChoiceAddress;
import org.gradle.internal.remote.internal.inet.MultiChoiceAddressSerializer;
import org.gradle.internal.remote.services.MessagingServices;
import org.gradle.internal.serialize.InputStreamBackedDecoder;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.time.Clock;
import org.gradle.internal.time.Time;
import org.gradle.process.internal.health.memory.DefaultJvmMemoryInfo;
import org.gradle.process.internal.health.memory.DefaultMemoryManager;
import org.gradle.process.internal.health.memory.DisabledOsMemoryInfo;
import org.gradle.process.internal.health.memory.JvmMemoryInfo;
import org.gradle.process.internal.health.memory.JvmMemoryStatus;
import org.gradle.process.internal.health.memory.JvmMemoryStatusListener;
import org.gradle.process.internal.health.memory.MemoryManager;
import org.gradle.process.internal.health.memory.OsMemoryInfo;
import org.gradle.process.internal.worker.WorkerJvmMemoryInfoSerializer;
import org.gradle.process.internal.worker.WorkerLoggingSerializer;
import org.gradle.process.internal.worker.child.DefaultWorkerDirectoryProvider;
import org.gradle.process.internal.worker.child.WorkerContext;
import org.gradle.process.internal.worker.child.WorkerDirectoryProvider;
import org.gradle.process.internal.worker.child.WorkerJvmMemoryInfoProtocol;
import org.gradle.process.internal.worker.child.WorkerLogEventListener;
import org.gradle.process.internal.worker.child.WorkerLoggingProtocol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemApplicationClassLoaderWorker
implements Callable<Void> {
    private final DataInputStream configInputStream;

    public SystemApplicationClassLoaderWorker(DataInputStream configInputStream) {
        this.configInputStream = configInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws Exception {
        ObjectConnection connection;
        MessagingServices messagingServices;
        LoggingManagerInternal loggingManager;
        block9: {
            if (System.getProperty("org.gradle.worker.test.stuck") != null) {
                Thread.sleep(30000L);
                return null;
            }
            InputStreamBackedDecoder decoder = new InputStreamBackedDecoder(this.configInputStream);
            int logLevel = decoder.readSmallInt();
            loggingManager = this.createLoggingManager();
            loggingManager.setLevelInternal(LogLevel.values()[logLevel]).start();
            boolean shouldPublishJvmMemoryInfo = decoder.readBoolean();
            String gradleUserHomeDirPath = decoder.readString();
            File gradleUserHomeDir = new File(gradleUserHomeDirPath);
            MultiChoiceAddress serverAddress = new MultiChoiceAddressSerializer().read(decoder);
            messagingServices = new MessagingServices();
            final WorkerServices workerServices = new WorkerServices((ServiceRegistry)messagingServices, gradleUserHomeDir);
            connection = null;
            WorkerLogEventListener workerLogEventListener = null;
            try {
                Action action;
                byte[] serializedWorker = decoder.readBinary();
                try {
                    ClassLoaderObjectInputStream instr = new ClassLoaderObjectInputStream(new ByteArrayInputStream(serializedWorker), this.getClass().getClassLoader());
                    action = (Action)instr.readObject();
                }
                catch (Exception e) {
                    throw UncheckedException.throwAsUncheckedException(e);
                }
                connection = messagingServices.get(MessagingClient.class).getConnection(serverAddress);
                workerLogEventListener = this.configureLogging(loggingManager, connection);
                if (shouldPublishJvmMemoryInfo) {
                    this.configureWorkerJvmMemoryInfoEvents(workerServices, connection);
                }
                final ObjectConnection serverConnection = connection;
                action.execute(new WorkerContext(){

                    public ClassLoader getApplicationClassLoader() {
                        return ClassLoader.getSystemClassLoader();
                    }

                    public ObjectConnection getServerConnection() {
                        return serverConnection;
                    }

                    public ServiceRegistry getServiceRegistry() {
                        return workerServices;
                    }
                });
                if (workerLogEventListener == null) break block9;
            }
            catch (Throwable throwable) {
                if (workerLogEventListener != null) {
                    loggingManager.removeOutputEventListener(workerLogEventListener);
                }
                if (connection != null) {
                    connection.stop();
                }
                messagingServices.close();
                loggingManager.stop();
                throw throwable;
            }
            loggingManager.removeOutputEventListener(workerLogEventListener);
        }
        if (connection != null) {
            connection.stop();
        }
        messagingServices.close();
        loggingManager.stop();
        return null;
    }

    private WorkerLogEventListener configureLogging(LoggingManagerInternal loggingManager, ObjectConnection connection) {
        connection.useParameterSerializers(WorkerLoggingSerializer.create());
        WorkerLoggingProtocol workerLoggingProtocol = connection.addOutgoing(WorkerLoggingProtocol.class);
        WorkerLogEventListener workerLogEventListener = new WorkerLogEventListener(workerLoggingProtocol);
        loggingManager.addOutputEventListener(workerLogEventListener);
        return workerLogEventListener;
    }

    private void configureWorkerJvmMemoryInfoEvents(WorkerServices services, ObjectConnection connection) {
        connection.useParameterSerializers(WorkerJvmMemoryInfoSerializer.create());
        final WorkerJvmMemoryInfoProtocol workerJvmMemoryInfoProtocol = connection.addOutgoing(WorkerJvmMemoryInfoProtocol.class);
        services.get(MemoryManager.class).addListener(new JvmMemoryStatusListener(){

            public void onJvmMemoryStatus(JvmMemoryStatus jvmMemoryStatus) {
                workerJvmMemoryInfoProtocol.sendJvmMemoryStatus(jvmMemoryStatus);
            }
        });
    }

    LoggingManagerInternal createLoggingManager() {
        LoggingManagerInternal loggingManagerInternal = LoggingServiceRegistry.newEmbeddableLogging().newInstance(LoggingManagerInternal.class);
        loggingManagerInternal.captureSystemSources();
        return loggingManagerInternal;
    }

    private static class WorkerServices
    extends DefaultServiceRegistry {
        public WorkerServices(ServiceRegistry parent, final File gradleUserHomeDir) {
            super(parent);
            this.addProvider(new Object(){

                GradleUserHomeDirProvider createGradleUserHomeDirProvider() {
                    return new GradleUserHomeDirProvider(){

                        public File getGradleUserHomeDirectory() {
                            return gradleUserHomeDir;
                        }
                    };
                }
            });
        }

        Clock createClock() {
            return Time.clock();
        }

        ListenerManager createListenerManager() {
            return new DefaultListenerManager();
        }

        OsMemoryInfo createOsMemoryInfo() {
            return new DisabledOsMemoryInfo();
        }

        JvmMemoryInfo createJvmMemoryInfo() {
            return new DefaultJvmMemoryInfo();
        }

        MemoryManager createMemoryManager(OsMemoryInfo osMemoryInfo, JvmMemoryInfo jvmMemoryInfo, ListenerManager listenerManager, ExecutorFactory executorFactory) {
            return new DefaultMemoryManager(osMemoryInfo, jvmMemoryInfo, listenerManager, executorFactory);
        }

        WorkerDirectoryProvider createWorkerDirectoryProvider(GradleUserHomeDirProvider gradleUserHomeDirProvider) {
            return new DefaultWorkerDirectoryProvider(gradleUserHomeDirProvider);
        }
    }
}

